//----------------------------------------------------------------------------
// C main line
//----------------------------------------------------------------------------

#include <m8c.h>        // part specific constants and macros
#include "PSoCAPI.h"    // PSoC API definitions for all User Modules


#define MMC_SCS 0x01	//p[1]0
#define SW1 0x01

unsigned char PWM_End_Flag;
unsigned char pInData;

#pragma fastcall16 SPI_SEND
#pragma fastcall16 ADPCM_INIT
#pragma fastcall16 ADPCMDecoder1
#pragma fastcall16 ADPCMDecoder2

extern unsigned char SPI_SEND(unsigned char UUBUF);		//read from assemble file
extern void ADPCM_INIT(void);
extern unsigned int ADPCMDecoder1(unsigned char code);
extern unsigned int ADPCMDecoder2(unsigned char code);

/*
unsigned char SPI_SEND(unsigned char UUBUF){
	SPIM_1_SendTxData(UUBUF);
	while(!(SPIM_1_bReadStatus() & SPIM_1_SPIM_SPI_COMPLETE)); //transmit complete?
    return(SPIM_1_bReadRxData());
}
*/
unsigned char MMC_CMD(unsigned char CMD,unsigned long ADDR,unsigned char MMC_CRC){
	unsigned char USERBUF;
	SPI_SEND(0xff);
	SPI_SEND(0x40 + CMD);						
	SPI_SEND((ADDR >> 24) & 0xff);
	SPI_SEND((ADDR >> 16) & 0xff);
	SPI_SEND((ADDR >> 8) & 0xfe);
	SPI_SEND(/*ADDR  & */0x00);
	SPI_SEND(MMC_CRC & 0xFF);		
	//----------------------------
	//	wait R1 resp
	//----------------------------
	for(;;){
		USERBUF	=	SPI_SEND(0xff);
		if(!(USERBUF & 0x80))break;	
	}//timed out
	return(USERBUF);
}

void MMC_INIT(void){
	unsigned char LP1;
	// ----------- SD memory Card initialize ------------
	// 74 or more cycle dummy clock sending
	// --------------------------------------------------
	pInData = PRT1DR;
	pInData |= MMC_SCS;
	PRT1DR = pInData;		// CS = High
	for(LP1=100;LP1!=0;LP1--)SPI_SEND(0xff);
	// -------- dummy clock send was over ---------------
	// ------- Send CMD0 to MMC or SD memory Card -------
	pInData = PRT1DR;
	pInData &= ~MMC_SCS;
	PRT1DR = pInData;		// CS = Low
	MMC_CMD(0,0,0x95);		//CMD0,CRC=0x95
	// -------- Send ACMD41 to SD memory Card -------
	// -------- 	ACMD41 = CMD55 + CMD41	  -------
	do{
		MMC_CMD(55,0,0xFF);				//CMD55,CRC=0xFFh
	}while(MMC_CMD(41,0,0x01) != 0x00);	//CMD41,CRC=0x01h 
	// --------		ACMD41 send was End			-------
	// ------------------------------------------------
	while(!SPI_SEND(0xff));	//wait busy
	while(!SPI_SEND(0xff));	//wait busy
	MMC_CMD(16,512,0x01);	//SET_BLOCKLEN = 512 byte
	
}

void MMC_SEND_STOP(void){
	unsigned char LP1;
	
	pInData = PRT1DR;
//	pInData |= MMC_SCS;
//	PRT1DR = pInData;		// CS = High
	pInData &= ~MMC_SCS;
	PRT1DR = pInData;		// CS = Low	
	for(LP1=100;LP1!=0;LP1--)SPI_SEND(0xff);
	MMC_CMD(12,0,0x01);		//CMD12
	while(!SPI_SEND(0xff));	//wait busy
	while(!SPI_SEND(0xff));	//wait busy
	for(LP1=100;LP1!=0;LP1--)SPI_SEND(0xff);
}

// Registors To read FAT
// Supported FAT16 only
unsigned char Sector_Per_Cluster;

unsigned long SectorZero;
unsigned long Beginning_Of_FAT_Sector;
unsigned long Reserved_for_FAT_Sector;
unsigned long Beginning_Of_Dir_Sector;
unsigned long Beginning_Of_Data_Sector;
unsigned long Now_Cluster;

void Get_Sector_Zero(void){
	unsigned int  LP1;
	SectorZero = 0;
	
	do{
		for(LP1=100;LP1!=0;LP1--)SPI_SEND(0xff);					
	}while(MMC_CMD(18,0x00,0x01)!= 0x00);	//end do
	//CMD18=52_(4-byte data address)_01h	
	//-----------------------------
	// read start
	//-----------------------------		
	while(SPI_SEND(0xff) != 0xfe);	//get start token?
	for(LP1=0;LP1<512;LP1++){
		switch(LP1){
			case 454:
				SectorZero = SPI_SEND(0xff);
				break;
			default:
				SPI_SEND(0xff);
				break;
		}// end switch(LP1)
	}	//end for(LP1=0;LP1<512;LP1++)
	SPI_SEND(0xff);		//16-bit CRC
	SPI_SEND(0xff);		//16-bit CRC
	MMC_SEND_STOP();
	
}


void Read_BPB(void){
	unsigned int LP1;
	
	do{
		for(LP1=100;LP1!=0;LP1--)SPI_SEND(0xff);					
	}while(MMC_CMD(18,(SectorZero << 9),0x01)!= 0x00);	//end do
	//CMD18=52_(4-byte data address)_01h	
	//-----------------------------
	// read start
	//-----------------------------		
	while(SPI_SEND(0xff) != 0xfe);	//get start token?
	for(LP1=0;LP1<512;LP1++){
		switch(LP1){
			case 13:
				Sector_Per_Cluster = SPI_SEND(0xff);
				break;
			case 14:
				Beginning_Of_FAT_Sector = SPI_SEND(0xff);
				break;
			case 22:
				Reserved_for_FAT_Sector = SPI_SEND(0xff); 
				break;
			default:
				SPI_SEND(0xff);
				break;
		}
		
	}	//end for(LP1=0;LP1<512;LP1++)
	SPI_SEND(0xff);		//16-bit CRC
	SPI_SEND(0xff);		//16-bit CRC
	MMC_SEND_STOP();
	
	Beginning_Of_Dir_Sector = Beginning_Of_FAT_Sector + (Reserved_for_FAT_Sector * 2);
	Beginning_Of_Data_Sector = Beginning_Of_Dir_Sector + 32;
}

unsigned long Get_File_Num(unsigned int Num){
	unsigned long File_Length_Sector = 0;
	unsigned int LP1;
	unsigned char LP2;

	unsigned char UUBUF[32];
	if(Num > 16)Num = 16;
	
	do{
		for(LP1=100;LP1!=0;LP1--)SPI_SEND(0xff);					
	}while(MMC_CMD(18,((Beginning_Of_Dir_Sector + SectorZero) << 9),0x01)!= 0x00);	//end do
	//CMD18=52_(4-byte data address)_01h	
	//-----------------------------
	// read start
	//-----------------------------		
	while(SPI_SEND(0xff) != 0xfe);	//get start token?
	for(LP1=0;LP1 < Num;LP1++){
		for(LP2=0;LP2<32;LP2++){
			UUBUF[LP2] = SPI_SEND(0xff);
		}
		if((UUBUF[11]!=0x20)||(UUBUF[0]==0xE5)||(UUBUF[26]==0x00)){//deleted file or folder?
			Num++;
			if(Num > 16)Num = 1;
		}
	}	//end for(LP1=0;LP1<Num;LP1++)
	Now_Cluster = (UUBUF[27]<< 8)|UUBUF[26];
	
	File_Length_Sector = (UUBUF[31]<< 8)|UUBUF[30];
	File_Length_Sector <<= 8;	//bug of C compiler
	File_Length_Sector |= UUBUF[29];
	
	//File_Length_Sector= *(unsigned long *)&UUBUF[31];
	File_Length_Sector >>= 1;	//512byte order
	File_Length_Sector &= 0x007FFFFF;
	MMC_SEND_STOP();
	return(File_Length_Sector);
}

void main(void){
	unsigned char UUBUF;
	unsigned char TrackNum;
	unsigned char LP1;

	unsigned long FileLength;
	SPIM_1_Start(SPIM_1_SPIM_MODE_0 | SPIM_1_SPIM_MSB_FIRST);
	MMC_INIT();
	//init to read FAT
	Get_Sector_Zero();
	Read_BPB();
	TrackNum = 1;
	FileLength = Get_File_Num(TrackNum);
	
	PWM16_1_Start();	
	PWM16_2_Start();
	PWM8_3_Start();
	DAC_Modulator_1_Start(DAC_Modulator_1_HIGHPOWER);
	DAC_Modulator_2_Start(DAC_Modulator_2_HIGHPOWER);
	AMD_CR0 = 0x21;		//GOE0 & GOE1 are busses as modulator
	
	ADPCM_INIT();
	PWM_End_Flag = 1;	// 0:Go, 1:Stop
	PRT1DR = pInData;
	


	M8C_EnableGInt;
	M8C_EnableIntMask(INT_MSK1,INT_MSK1_DCB03);	
	while(1){
		do{
			for(LP1=100;LP1!=0;LP1--)SPI_SEND(0xff);					
		}while(MMC_CMD(18,((((Now_Cluster - 2) * Sector_Per_Cluster)+Beginning_Of_Data_Sector + SectorZero)<<9),0x01)!= 0x00);	//end do
		//CMD18=52_(4-byte data address)_01h	
		//-----------------------------
		// read start
		//-----------------------------		
		while(--FileLength){
		
			while(SPI_SEND(0xff) != 0xfe);	//get start token?
			LP1=127;
			do{
				UUBUF	=	SPI_SEND(0xff);
				PWM16_1_WritePulseWidth(ADPCMDecoder1(UUBUF));			
				PWM16_2_WritePulseWidth(ADPCMDecoder2(UUBUF >> 4));
				while(PWM_End_Flag);
				PWM_End_Flag = 1;
				UUBUF	=	SPI_SEND(0xff);
				PWM16_1_WritePulseWidth(ADPCMDecoder1(UUBUF));			
				PWM16_2_WritePulseWidth(ADPCMDecoder2(UUBUF >> 4));
				while(PWM_End_Flag);
				PWM_End_Flag = 1;
				UUBUF	=	SPI_SEND(0xff);
				PWM16_1_WritePulseWidth(ADPCMDecoder1(UUBUF));			
				PWM16_2_WritePulseWidth(ADPCMDecoder2(UUBUF >> 4));
				while(PWM_End_Flag);
				PWM_End_Flag = 1;
				UUBUF	=	SPI_SEND(0xff);
				PWM16_1_WritePulseWidth(ADPCMDecoder1(UUBUF));			
				PWM16_2_WritePulseWidth(ADPCMDecoder2(UUBUF >> 4));
				while(PWM_End_Flag);
				PWM_End_Flag = 1;
			}while(LP1--);	//end do-while
			SPI_SEND(0xff);		//16-bit CRC
			SPI_SEND(0xff);		//16-bit CRC
			if(PRT1DR & SW1)break;
	
		}	//end while(1)
		

////////////////////////////////////////
/////////		STOP Tran 
////////////////////////////////////////
	while(PRT1DR & SW1);
	MMC_SEND_STOP();
	ADPCM_INIT();
	TrackNum++;
	if(!Get_File_Num(TrackNum))TrackNum = 1;
	FileLength = Get_File_Num(TrackNum);
	}//end while(1)	
	
	
}
/*
#pragma interrupt_handler PWM8_3_INT 
void PWM8_3_INT(void)
{
	PWM_End_Flag = 0;//0:Go
}
*/