;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: PWM8_3.inc
;;   Version: 2.5, Updated on 2009/10/15 at 17:11:37
;;  Generated by PSoC Designer 5.0.1127.0
;;
;;  DESCRIPTION: Assembler declarations for the PWM8 user module interface
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2009. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for PWM8_3 API's.
;--------------------------------------------------

PWM8_3_CONTROL_REG_START_BIT:              equ 0x01    ; Control register start bit
PWM8_3_INT_REG:                            equ 0x0e1
PWM8_3_INT_MASK:                           equ 0x08


;--------------------------------------------------
; Constants for PWM8_3 user defined values
;--------------------------------------------------

PWM8_3_PERIOD:                             equ 0xf8
PWM8_3_PULSE_WIDTH:                        equ 0x00


;--------------------------------------------------
; Register Address Constants for PWM8_3
;--------------------------------------------------

PWM8_3_COUNTER_REG:                    equ 0x2c   ; DR0 Count register
PWM8_3_PERIOD_REG:                     equ 0x2d   ; DR1 Period register
PWM8_3_COMPARE_REG:                    equ 0x2e   ; DR2 Compare register
PWM8_3_CONTROL_REG:                    equ 0x2f   ; Control register
PWM8_3_FUNC_REG:                       equ 0x2c   ; Function register
PWM8_3_INPUT_REG:                      equ 0x2d   ; Input register
PWM8_3_OUTPUT_REG:                     equ 0x2e   ; Output register


;--------------------------------------------------
; PWM8_3 Macro 'Functions'
;--------------------------------------------------

   macro PWM8_3_Start_M
   or    reg[PWM8_3_CONTROL_REG],  PWM8_3_CONTROL_REG_START_BIT
   endm

   macro PWM8_3_Stop_M
   and   reg[PWM8_3_CONTROL_REG], ~PWM8_3_CONTROL_REG_START_BIT
   endm

   macro PWM8_3_EnableInt_M
   M8C_EnableIntMask PWM8_3_INT_REG, PWM8_3_INT_MASK
   endm

   macro PWM8_3_DisableInt_M
   M8C_DisableIntMask PWM8_3_INT_REG, PWM8_3_INT_MASK
   endm


; end of file PWM8_3.inc
