<?php
/*! @file
 *@brief
 * PSGraph_pie
 *  円グラフ
 *
 *@author hirohito
 *@note
 */
/* This file is distributed under BSD licence. Please read the COPYRIGHT file. */


include_once 'psgraph_base.php';



//================================================
/*!@brief
 * 円グラフ
 *
 */
class PSGraphPie extends PSGraph_util
{
    public $AtPlotArea = array( 'X'=>10, 'Y'=>10, 'Fill'=>'#fff' );	//!< プロットエリアアトリビュート
    public $AtDataLabels = null;					//!< データラベルアトリビュート（未実装）


    //================================================================
    /*! constructor
     *
     *@param	width	幅
     *@param	height	高さ
     */
    function __construct( $width = 320, $height = 240 )
    {
	parent::__construct( $width, $height );

	/*
	 * make default
	 */
	$this->AtPlotArea['Width'] = $this->Width - 20;
	if( $this->AtPlotArea['Width'] < 0 ) $this->AtPlotArea['Width'] = 0;
	$this->AtPlotArea['Height'] = $this->Height - 20;
	if( $this->AtPlotArea['Height'] < 0 ) $this->AtPlotArea['Height'] = 0;
    }


    //================================================================
    /*! データの追加
     *
     *@param	ydata	データの配列
     *@param	labels	ラベルの配列
     */
    function addData( array $ydata, array $labels )
    {
	for( $i = 0; $i < count( $ydata ); $i++ ) {
	    $this->DataSeries[] = new PSGraph_container_pie( $ydata[$i], $labels[$i], self::$COLORLIST[$i % count(self::$COLORLIST)] );
	}

	if( ! $this->AtLegend ) {
	    $this->addLegend();
	}

	return $this->DataSeries;
    }



    //================================================================
    /*! 描画
     *
     */
    function draw()
    {
	/*
	 * calc some params.
	 */
	$total = 0;
	foreach( $this->DataSeries as $ds ) {
	    $total += $ds->DataValue;
	}

	foreach( $this->DataSeries as $ds ) {
	    $ds->Percentage = $ds->DataValue / $total;
	}

	$cx0 = $this->AtPlotArea['X'] + $this->AtPlotArea['Width'] / 2;
	$cy0 = $this->AtPlotArea['Y'] + $this->AtPlotArea['Height'] / 2;
	if( isset( $this->AtPlotArea['R'] ) ) {
	    $r = $this->AtPlotArea['R'];
	} else {
	    $r = ($this->AtPlotArea['Width'] < $this->AtPlotArea['Height'])? $this->AtPlotArea['Width']: $this->AtPlotArea['Height'];
	    $r = $r / 2 - 10;
	    if( $r < 0 ) $r = 0;
	}
	
	/*
	 * draw start.
	 */
	$this->draw_common1();

	/*
	 * draw each pieces.
	 */
	$this->Output->printf( "\n<!-- draw pie chart -->\n" );

	$x1 = 0;
	$y1 = -$r;
	$total2 = 0;
	for( $i = 0; $i < count( $this->DataSeries ); $i++ ) {
	    $vector = ($total2 + $this->DataSeries[$i]->DataValue / 2 ) / $total * 2 * M_PI;
	    $total2 += $this->DataSeries[$i]->DataValue;
	    $x2 = $r * sin( $total2 / $total * 2 * M_PI );
	    $y2 = -$r * cos( $total2 / $total * 2 * M_PI );
	    $l_arc = ($this->DataSeries[$i]->Percentage > 0.5)? 1: 0;
	    if( isset( $this->DataSeries[$i]->AtPiece['SeparateDistance'] ) ) {
		$d = $this->DataSeries[$i]->AtPiece['SeparateDistance'];
		$cx = $cx0 + $d * sin( $vector );
		$cy = $cy0 - $d * cos( $vector );
	    } else {
		$cx = $cx0;
		$cy = $cy0;
	    }

	    $this->Output->printf( '<path d="M0,0 L%d,%d A%d,%d 0 %d,1 %d,%d Z" transform="translate(%d,%d)" %s title="'.
		$this->DataSeries[$i]->DataValue. "\"/>\n",
		$x1,$y1, $r,$r, $l_arc, $x2,$y2,
		$cx,$cy,
		$this->make_common_attribute_string( $this->DataSeries[$i]->AtPiece ) );
	    $x1 = $x2;
	    $y1 = $y2;
	}

	/*
	 * draw legend
	 */
	$this->Output->printf( "\n<!-- draw legends -->\n" );
	if( $this->AtLegend ) {
	    if( !isset( $this->AtLegend['Y'] ) ) {
		$this->AtLegend['Y'] = ($this->Height - count( $this->DataSeries )
					* ($this->AtLegend['FontSize'] + 4)) / 2;
		if( $this->AtLegend['Y'] < 0 ) $this->AtLegend['Y'] = 0;
	    }

	    $attr = $this->AtLegend;
	    $attr['X'] += 10;
	    $attr['Y'] += $attr['FontSize'];

	    for( $i = 0; $i < count( $this->DataSeries ); $i++ ) {
		$this->Output->printf( "<text %s>%s</text>\n",
			$this->make_common_attribute_string( $attr ), htmlspecialchars( $this->DataSeries[$i]->Legend ) );
		$this->Output->printf( "<rect x=\"%d\" y=\"%d\" width=\"%d\" height=\"%d\" stroke=\"black\" stroke-width=\"1\" fill=\"%s\" />\n",
			$attr['X']-$attr['FontSize']-5, $attr['Y']-$attr['FontSize'], $attr['FontSize'], $attr['FontSize'],
			$this->DataSeries[$i]->AtPiece['Fill'] );
		$attr['Y'] += $this->AtLegend['FontSize'] + 4;
	    }
	}

	$this->draw_common2();
    }


    //================================================================
    /*! 未実装
     *
     *@param	
     *@retval	
     *@note
     */
    function addDataLabels()
    {
//	$this->AtDataLabels = array( 'Position'=>$pos, 'FontSize'=>9, 'TextAnchor'=>'middle' );
	$this->AtDataLabels = array( 'FontSize'=>9 );
    }
}



//================================================================
/*!@brief
 * 円グラフ用データコンテナ
 *
 */
class PSGraph_container_pie
{
    public $DataValue;		//!< データ値
    public $Percentage;		//!< 全体率
    public $Legend;		//!< 凡例文字列
    public $AtPiece = array( 'StrokeWidth'=>1, 'Stroke'=>'black' );	//!< グラフアトリビュート

    
    //================================================================
    /*! constructor
     *
     *@param	value	データ値
     *@param	legend	凡例文字列
     *@param	color	色
     *@note
     * データ列を管理するのではなく、一つの値を管理する。
     * 折れ線用などとは思想が違うので注意。
     */
    function __construct( $value, $legend, $color )
    {
	$this->DataValue = $value;
	$this->Legend = $legend;
	$this->AtPiece['Fill'] = $color;
    }


    //================================================================
    /*! 色の指定
     *
     *@param	color	色
     */
    function setColor( $color )
    {
	$this->AtPiece['Fill'] = $color;
    }


    //================================================================
    /*! セパレート
     *
     *@param	dim	距離
     */
    function separate( $dim = 20 )
    {
	$this->AtPiece['SeparateDistance'] = $dim;
    }
}
