/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propsearch.search.ui.text;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FileLabelProvider
extends LabelProvider {
    public static final int SHOW_LABEL = 1;
    public static final int SHOW_LABEL_PATH = 2;
    public static final int SHOW_PATH = 4;
    public static final int SHOW_PATH_LABEL = 3;
    private String[] fArgs = new String[2];
    private WorkbenchLabelProvider fLabelProvider = new WorkbenchLabelProvider();
    private int fOrder;
    private AbstractTextSearchViewPage fPage;
    private static final String fgSeparatorFormat = "{0} - {1}";

    public FileLabelProvider(AbstractTextSearchViewPage page, int orderFlag) {
        this.fOrder = orderFlag;
        this.fPage = page;
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        this.fLabelProvider.addListener(listener);
    }

    public void dispose() {
        super.dispose();
        this.fLabelProvider.dispose();
    }

    public Image getImage(Object element) {
        if (!(element instanceof IResource)) {
            return null;
        }
        IResource resource = (IResource)element;
        Image image = this.fLabelProvider.getImage((Object)resource);
        return image;
    }

    public int getOrder() {
        return this.fOrder;
    }

    public String getText(Object element) {
        if (!(element instanceof IResource)) {
            return null;
        }
        IResource resource = (IResource)element;
        String text = null;
        if (!resource.exists()) {
            text = SearchMessages.getString((String)"FileLabelProvider.removed_resource.label");
        } else {
            IPath path = resource.getFullPath().removeLastSegments(1);
            if (path.getDevice() == null) {
                path = path.makeRelative();
            }
            if (this.fOrder == 1 || this.fOrder == 2) {
                text = this.fLabelProvider.getText((Object)resource);
                if (path != null && this.fOrder == 2) {
                    this.fArgs[0] = text;
                    this.fArgs[1] = path.toString();
                    text = MessageFormat.format(fgSeparatorFormat, this.fArgs);
                }
            } else {
                text = path != null ? path.toString() : "";
                if (this.fOrder == 3) {
                    this.fArgs[0] = text;
                    this.fArgs[1] = this.fLabelProvider.getText((Object)resource);
                    text = MessageFormat.format(fgSeparatorFormat, this.fArgs);
                }
            }
        }
        int matchCount = 0;
        AbstractTextSearchResult result = this.fPage.getInput();
        if (result != null) {
            matchCount = result.getMatchCount(element);
        }
        if (matchCount <= 1) {
            return text;
        }
        String format = SearchMessages.getString((String)"FileLabelProvider.count.format");
        return MessageFormat.format(format, text, new Integer(matchCount));
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.fLabelProvider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        this.fLabelProvider.removeListener(listener);
    }

    public void setOrder(int orderFlag) {
        this.fOrder = orderFlag;
    }
}

