/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.FileSearchPage;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.FileSearchQuery;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.RegExContentAssistProcessor;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.ReplaceAction2;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.ReplaceDialog;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.ReplaceDialog2;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.TextSearchOperation;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.TextSearchResultCollector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.core.ISearchScope;
import org.eclipse.search.internal.core.text.TextSearchScope;
import org.eclipse.search.internal.ui.ScopePart;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchResultView;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.internal.ui.util.FileTypeEditor;
import org.eclipse.search.internal.ui.util.RowLayouter;
import org.eclipse.search.internal.ui.util.SWTUtil;
import org.eclipse.search.ui.IReplacePage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.contentassist.ContentAssistHandler;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class PropertySearchPage
extends DialogPage
implements ISearchPage,
IReplacePage {
    public static final String EXTENSION_POINT_ID = "jp.gr.java_conf.ussiy.app.property.search.internal.ui.text.PropertySearchPage";
    private static final String PAGE_NAME = "TeSearchPage";
    private static final String STORE_CASE_SENSITIVE = "TeSearchPageCASE_SENSITIVE";
    private static final String STORE_IS_REG_EX_SEARCH = "TeSearchPageREG_EX_SEARCH";
    private static final String STORE_SEARCH_DERIVED = "TeSearchPageSEARCH_DERIVED";
    static /* synthetic */ Class class$org$eclipse$core$resources$IProject;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;
    private ISearchPageContainer fContainer;
    private IDialogSettings fDialogSettings;
    private Combo fExtensions;
    private FileTypeEditor fFileTypeEditor;
    private boolean fFirstTime = true;
    private Button fIgnoreCase;
    private boolean fIsCaseSensitive;
    private Button fIsRegExCheckbox;
    private boolean fIsRegExSearch;
    private Combo fPattern;
    private ContentAssistHandler fReplaceContentAssistHandler;
    private boolean fSearchDerived;
    private Button fSearchDerivedCheckbox;
    private Label fStatusLabel;
    private static List fgPreviousSearchPatterns = new ArrayList(20);

    private void checkRegex() {
        if (this.fIsRegExCheckbox.getSelection()) {
            try {
                Pattern.compile(this.fPattern.getText());
            }
            catch (PatternSyntaxException e) {
                this.statusMessage(true, e.getLocalizedMessage());
                this.getContainer().setPerformActionEnabled(false);
                return;
            }
            this.statusMessage(false, "");
        } else {
            this.statusMessage(false, SearchMessages.getString((String)"SearchPage.containingText.hint"));
        }
        this.getContainer().setPerformActionEnabled(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)new GridData(768));
        RowLayouter layouter = new RowLayouter(layout.numColumns);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 18;
        layouter.setDefaultGridData(gd, 0);
        layouter.setDefaultGridData(gd, 1);
        layouter.setDefaultGridData(gd, 2);
        layouter.setDefaultSpan();
        layouter.perform(this.createTextSearchComposite(result));
        Label filler = new Label(result, 16384);
        gd = new GridData(17);
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 3;
        filler.setLayoutData((Object)gd);
        layouter.perform(new Control[]{filler}, 3);
        layouter.perform(this.createFileNamePatternComposite(result));
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
        WorkbenchHelp.setHelp((Control)result, (String)"org.eclipse.search.text_search_page_context");
        this.fPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertySearchPage.this.checkRegex();
            }
        });
    }

    private Control createFileNamePatternComposite(Composite group) {
        Label label = new Label(group, 16384);
        label.setText(SearchMessages.getString((String)"SearchPage.fileNamePatterns.text"));
        GridData gd = new GridData(1);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.fExtensions = new Combo(group, 2052);
        this.fExtensions.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PropertySearchPage.this.getContainer().setPerformActionEnabled(PropertySearchPage.this.getContainer().hasValidScope());
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fExtensions.setLayoutData((Object)gd);
        Button button = new Button(group, 8);
        button.setText(SearchMessages.getString((String)"SearchPage.browse"));
        gd = new GridData(128);
        button.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint((Button)button);
        this.fFileTypeEditor = new FileTypeEditor(SearchPlugin.getDefault().getWorkbench().getEditorRegistry(), this.fExtensions, button);
        label = new Label(group, 16384);
        label.setText(SearchMessages.getString((String)"SearchPage.fileNamePatterns.hint"));
        gd = new GridData(1);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.fSearchDerivedCheckbox = new Button(group, 32);
        gd = new GridData(1);
        this.fSearchDerivedCheckbox.setLayoutData((Object)gd);
        this.fSearchDerivedCheckbox.setText(SearchMessages.getString((String)"TextSearchPage.searchDerived.label"));
        this.fSearchDerivedCheckbox.setSelection(this.fSearchDerived);
        this.fSearchDerivedCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertySearchPage.this.fSearchDerived = PropertySearchPage.this.fSearchDerivedCheckbox.getSelection();
                PropertySearchPage.this.writeConfiguration();
            }
        });
        return group;
    }

    private Control createTextSearchComposite(Composite group) {
        Label label = new Label(group, 16384);
        label.setText(SearchMessages.getString((String)"SearchPage.containingText.text"));
        GridData gd = new GridData(1);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.fPattern = new Combo(group, 2052);
        this.fPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertySearchPage.this.handleWidgetSelected();
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fPattern.setLayoutData((Object)gd);
        this.fIgnoreCase = new Button(group, 32);
        this.fIgnoreCase.setText(SearchMessages.getString((String)"SearchPage.caseSensitive"));
        gd = new GridData(32);
        this.fIgnoreCase.setLayoutData((Object)gd);
        this.fIgnoreCase.setSelection(!this.fIsCaseSensitive);
        this.fIgnoreCase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertySearchPage.this.fIsCaseSensitive = !PropertySearchPage.this.fIgnoreCase.getSelection();
                PropertySearchPage.this.writeConfiguration();
            }
        });
        this.fStatusLabel = new Label(group, 16384);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fStatusLabel.setLayoutData((Object)gd);
        this.fIsRegExCheckbox = new Button(group, 32);
        this.fIsRegExCheckbox.setText(SearchMessages.getString((String)"SearchPage.regularExpression"));
        gd = new GridData(32);
        this.fIsRegExCheckbox.setLayoutData((Object)gd);
        this.fIsRegExCheckbox.setSelection(this.fIsRegExSearch);
        this.setContentAssistsEnablement(this.fIsRegExSearch);
        this.fIsRegExCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertySearchPage.this.fIsRegExSearch = PropertySearchPage.this.fIsRegExCheckbox.getSelection();
                PropertySearchPage.this.checkRegex();
                PropertySearchPage.this.writeConfiguration();
                PropertySearchPage.this.setContentAssistsEnablement(PropertySearchPage.this.fIsRegExSearch);
            }
        });
        return group;
    }

    private TextSearchOperation createTextSearchOperation() {
        SearchPatternData patternData = this.getPatternData();
        if (patternData.fileNamePatterns == null || this.fExtensions.getText().length() <= 0) {
            patternData.fileNamePatterns = new HashSet(1);
            patternData.fileNamePatterns.add("*");
        }
        TextSearchScope scope = null;
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                scope = TextSearchScope.newWorkspaceScope();
                break;
            }
            case 1: {
                scope = this.getSelectedResourcesScope(false);
                break;
            }
            case 3: {
                scope = this.getSelectedResourcesScope(true);
                break;
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                String desc = SearchMessages.getFormattedString((String)"WorkingSetScope", (Object)ScopePart.toString((IWorkingSet[])workingSets));
                scope = new TextSearchScope(desc, workingSets);
            }
        }
        scope.addExtensions(patternData.fileNamePatterns);
        SearchUI.activateSearchResultView();
        TextSearchResultCollector collector = new TextSearchResultCollector();
        TextSearchOperation op = new TextSearchOperation(SearchPlugin.getWorkspace(), patternData.textPattern, FileSearchQuery.isCaseSensitive(this.getSearchOptions()), FileSearchQuery.isRegexSearch(this.getSearchOptions()), (ISearchScope)scope, collector);
        return op;
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = SearchPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(PAGE_NAME);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(PAGE_NAME);
        }
        return this.fDialogSettings;
    }

    private IProject getEditorProject() {
        IEditorPart editor;
        IEditorInput input;
        IWorkbenchPart activePart = SearchPlugin.getActivePage().getActivePart();
        if (activePart instanceof IEditorPart && (input = (editor = (IEditorPart)activePart).getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getProject();
        }
        return null;
    }

    private String getExtensionFromEditor() {
        IEditorInput elem;
        IEditorPart ep = SearchPlugin.getActivePage().getActiveEditor();
        if (ep != null && (elem = ep.getEditorInput()) instanceof IFileEditorInput) {
            String extension = ((IFileEditorInput)elem).getFile().getFileExtension();
            if (extension == null) {
                return ((IFileEditorInput)elem).getFile().getName();
            }
            return "*." + extension;
        }
        return null;
    }

    private Set getExtensions() {
        return this.fFileTypeEditor.getFileTypes();
    }

    private String getPattern() {
        return this.fPattern.getText();
    }

    private SearchPatternData getPatternData() {
        SearchPatternData match = null;
        String textPattern = this.fPattern.getText();
        int i = fgPreviousSearchPatterns.size() - 1;
        while (i >= 0) {
            match = (SearchPatternData)fgPreviousSearchPatterns.get(i);
            if (textPattern.equals(match.textPattern)) break;
            --i;
        }
        if (i >= 0) {
            match.ignoreCase = this.ignoreCase();
            match.isRegExSearch = this.fIsRegExCheckbox.getSelection();
            match.textPattern = this.getPattern();
            match.fileNamePatterns = this.getExtensions();
            match.scope = this.getContainer().getSelectedScope();
            match.workingSets = this.getContainer().getSelectedWorkingSets();
            fgPreviousSearchPatterns.remove(match);
        } else {
            match = new SearchPatternData(this.getPattern(), this.ignoreCase(), this.fIsRegExCheckbox.getSelection(), this.getExtensions(), this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets());
        }
        fgPreviousSearchPatterns.add(match);
        return match;
    }

    private String[] getPreviousExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(fgPreviousSearchPatterns.size());
        int i = fgPreviousSearchPatterns.size() - 1;
        while (i >= 0) {
            SearchPatternData data = (SearchPatternData)fgPreviousSearchPatterns.get(i);
            String text = FileTypeEditor.typesToString((Set)data.fileNamePatterns);
            if (!extensions.contains(text)) {
                extensions.add(text);
            }
            --i;
        }
        return extensions.toArray(new String[extensions.size()]);
    }

    private String[] getPreviousSearchPatterns() {
        int size = fgPreviousSearchPatterns.size();
        String[] patterns = new String[size];
        int i = 0;
        while (i < size) {
            patterns[i] = ((SearchPatternData)PropertySearchPage.fgPreviousSearchPatterns.get((int)(size - 1 - i))).textPattern;
            ++i;
        }
        return patterns;
    }

    private IRunnableContext getRunnableContext() {
        IRunnableContext context = null;
        context = this.getContainer().getRunnableContext();
        Shell shell = this.fPattern.getShell();
        if (context == null) {
            context = new ProgressMonitorDialog(shell);
        }
        return context;
    }

    private String getSearchOptions() {
        StringBuffer result = new StringBuffer();
        if (!this.ignoreCase()) {
            result.append("i");
        }
        if (this.fIsRegExSearch) {
            result.append("r");
        }
        return result.toString();
    }

    private TextSearchScope getSelectedResourcesScope(boolean isProjectScope) {
        IProject editorProject;
        TextSearchScope scope = new TextSearchScope(SearchMessages.getString((String)"SelectionScope"));
        int elementCount = 0;
        IProject firstProject = null;
        if (this.getSelection() instanceof IStructuredSelection && !this.getSelection().isEmpty()) {
            Iterator iter = ((IStructuredSelection)this.getSelection()).iterator();
            while (iter.hasNext()) {
                Object selection = iter.next();
                if (selection instanceof ISearchResultViewEntry) {
                    selection = ((ISearchResultViewEntry)selection).getGroupByKey();
                }
                IResource resource = null;
                if (selection instanceof IResource) {
                    resource = (IResource)selection;
                } else if (selection instanceof IAdaptable) {
                    if (isProjectScope) {
                        resource = (IProject)((IAdaptable)selection).getAdapter(class$org$eclipse$core$resources$IProject == null ? PropertySearchPage.class$("org.eclipse.core.resources.IProject") : class$org$eclipse$core$resources$IProject);
                    }
                    if (resource == null) {
                        resource = (IResource)((IAdaptable)selection).getAdapter(class$org$eclipse$core$resources$IResource == null ? PropertySearchPage.class$("org.eclipse.core.resources.IResource") : class$org$eclipse$core$resources$IResource);
                    }
                }
                if (resource == null) continue;
                if (isProjectScope) {
                    if ((resource = resource.getProject()) == null || isProjectScope && scope.encloses(resource)) continue;
                    if (firstProject == null) {
                        firstProject = (IProject)resource;
                    }
                }
                ++elementCount;
                scope.add(resource);
            }
        } else if (isProjectScope && (editorProject = this.getEditorProject()) != null) {
            scope.add((IResource)editorProject);
        }
        if (isProjectScope) {
            if (elementCount > 1) {
                scope.setDescription(SearchMessages.getFormattedString((String)"EnclosingProjectsScope", (Object)firstProject.getName()));
            } else if (elementCount == 1) {
                scope.setDescription(SearchMessages.getFormattedString((String)"EnclosingProjectScope", (Object)firstProject.getName()));
            } else {
                scope.setDescription(SearchMessages.getFormattedString((String)"EnclosingProjectScope", (Object)""));
            }
        }
        return scope;
    }

    private ISelection getSelection() {
        return this.fContainer.getSelection();
    }

    private void handleWidgetSelected() {
        if (this.fPattern.getSelectionIndex() < 0) {
            return;
        }
        int index = fgPreviousSearchPatterns.size() - 1 - this.fPattern.getSelectionIndex();
        SearchPatternData patternData = (SearchPatternData)fgPreviousSearchPatterns.get(index);
        if (patternData == null || !this.fPattern.getText().equals(patternData.textPattern)) {
            return;
        }
        this.fIgnoreCase.setSelection(patternData.ignoreCase);
        this.fIsRegExCheckbox.setSelection(patternData.isRegExSearch);
        this.fPattern.setText(patternData.textPattern);
        this.fFileTypeEditor.setFileTypes(patternData.fileNamePatterns);
        if (patternData.workingSets != null) {
            this.getContainer().setSelectedWorkingSets(patternData.workingSets);
        } else {
            this.getContainer().setSelectedScope(patternData.scope);
        }
    }

    private boolean ignoreCase() {
        return this.fIgnoreCase.getSelection();
    }

    private void initializePatternControl() {
        ISelection selection = this.getSelection();
        String text = "";
        String extension = null;
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)this.getSelection();
            text = textSelection.getText();
        } else {
            IResource resource = null;
            Object item = null;
            if (selection instanceof IStructuredSelection) {
                item = ((IStructuredSelection)selection).getFirstElement();
            }
            if (item instanceof IResource) {
                resource = (IResource)item;
                text = resource.getName();
            } else if (item instanceof ISearchResultViewEntry) {
                IMarker marker = ((ISearchResultViewEntry)item).getSelectedMarker();
                resource = marker.getResource();
                try {
                    text = (String)marker.getAttribute("line");
                }
                catch (CoreException ex) {
                    ExceptionHandler.handle((CoreException)ex, (String)SearchMessages.getString((String)"Search.Error.markerAttributeAccess.title"), (String)SearchMessages.getString((String)"Search.Error.markerAttributeAccess.message"));
                    text = "";
                }
            } else if (item instanceof IAdaptable) {
                Object adapter = ((IAdaptable)item).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = PropertySearchPage.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter);
                if (adapter instanceof IWorkbenchAdapter) {
                    text = ((IWorkbenchAdapter)adapter).getLabel(item);
                }
                if ((adapter = ((IAdaptable)item).getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = PropertySearchPage.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource)) instanceof IResource) {
                    resource = (IResource)adapter;
                    if (text == null) {
                        text = resource.getName();
                    }
                }
            }
            extension = resource instanceof IFile ? ((extension = resource.getFileExtension()) == null ? resource.getName() : "*." + extension) : "*";
        }
        this.fPattern.setText(this.insertEscapeChars(text));
        if (this.getPreviousExtensions().length > 0) {
            this.fExtensions.setText(this.getPreviousExtensions()[0]);
        } else {
            if (extension == null) {
                extension = this.getExtensionFromEditor();
            }
            if (extension != null) {
                this.fExtensions.setText(extension);
            }
        }
    }

    private String insertEscapeChars(String text) {
        if (text == null || text.equals("")) {
            return "";
        }
        StringBuffer sbIn = new StringBuffer(text);
        BufferedReader reader = new BufferedReader(new StringReader(text));
        int lengthOfFirstLine = 0;
        try {
            lengthOfFirstLine = reader.readLine().length();
        }
        catch (IOException ex) {
            return "";
        }
        StringBuffer sbOut = new StringBuffer(lengthOfFirstLine + 5);
        int i = 0;
        while (i < lengthOfFirstLine) {
            char ch = sbIn.charAt(i);
            if (ch == '*' || ch == '?' || ch == '\\') {
                sbOut.append("\\");
            }
            sbOut.append(ch);
            ++i;
        }
        return sbOut.toString();
    }

    public boolean isValid() {
        return true;
    }

    public boolean performAction() {
        if (SearchPlugin.useNewSearch()) {
            return this.performNewSearch(false);
        }
        return this.performOldSearch();
    }

    private boolean performNewSearch(boolean forground) {
        SearchPatternData patternData = this.getPatternData();
        if (patternData.fileNamePatterns == null || this.fExtensions.getText().length() <= 0) {
            patternData.fileNamePatterns = new HashSet(1);
            patternData.fileNamePatterns.add("*");
        }
        TextSearchScope scope = null;
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                scope = TextSearchScope.newWorkspaceScope();
                break;
            }
            case 1: {
                scope = this.getSelectedResourcesScope(false);
                break;
            }
            case 3: {
                scope = this.getSelectedResourcesScope(true);
                break;
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                String desc = SearchMessages.getFormattedString((String)"WorkingSetScope", (Object)ScopePart.toString((IWorkingSet[])workingSets));
                scope = new TextSearchScope(desc, workingSets);
            }
        }
        NewSearchUI.activateSearchResultView();
        scope.addExtensions(patternData.fileNamePatterns);
        FileSearchQuery wsJob = new FileSearchQuery(scope, this.getSearchOptions(), patternData.textPattern, this.fSearchDerived);
        if (forground) {
            IStatus status = NewSearchUI.runQueryInForeground((IRunnableContext)this.getRunnableContext(), (ISearchQuery)wsJob);
            return status != null && status.isOK();
        }
        NewSearchUI.runQuery((ISearchQuery)wsJob);
        return true;
    }

    private boolean performOldSearch() {
        TextSearchOperation op = this.createTextSearchOperation();
        return this.runOperation(op);
    }

    public boolean performReplace() {
        if (SearchPlugin.useNewSearch()) {
            if (!this.performNewSearch(true)) {
                return false;
            }
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    ISearchResultPage page;
                    ISearchResultViewPart view = NewSearchUI.activateSearchResultView();
                    if (view != null && (page = view.getActivePage()) instanceof FileSearchPage) {
                        FileSearchPage filePage = (FileSearchPage)page;
                        Object[] elements = filePage.getInput().getElements();
                        IFile[] files = new IFile[elements.length];
                        System.arraycopy(elements, 0, files, 0, files.length);
                        new ReplaceAction2(filePage, files).run();
                    }
                }
            });
        } else {
            final TextSearchOperation op = this.createTextSearchOperation();
            if (!this.runOperation(op)) {
                return false;
            }
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    SearchResultView view = (SearchResultView)SearchPlugin.getSearchResultView();
                    new ReplaceDialog(SearchPlugin.getSearchResultView().getViewSite().getShell(), (List)view.getViewer().getInput(), op).open();
                }
            });
        }
        return true;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.fIsCaseSensitive = s.getBoolean(STORE_CASE_SENSITIVE);
        this.fIsRegExSearch = s.getBoolean(STORE_IS_REG_EX_SEARCH);
        this.fSearchDerived = s.getBoolean(STORE_SEARCH_DERIVED);
    }

    private boolean runOperation(TextSearchOperation op) {
        try {
            this.getRunnableContext().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof PatternSyntaxException) {
                this.showRegExSyntaxError((PatternSyntaxException)ex.getTargetException());
            } else {
                ExceptionHandler.handle((InvocationTargetException)ex, (String)SearchMessages.getString((String)"Search.Error.search.title"), (String)SearchMessages.getString((String)"Search.Error.search.message"));
            }
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        IStatus status = op.getStatus();
        if (status != null && !status.isOK()) {
            String title = SearchMessages.getString((String)"Search.Problems.title");
            ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)status);
            return false;
        }
        return true;
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    private void setContentAssistsEnablement(boolean enable) {
        if (enable) {
            if (this.fReplaceContentAssistHandler == null) {
                this.fReplaceContentAssistHandler = ContentAssistHandler.createHandlerForCombo((Combo)this.fPattern, (SubjectControlContentAssistant)ReplaceDialog2.createContentAssistant(RegExContentAssistProcessor.fgFindProposalKeys));
            }
            this.fReplaceContentAssistHandler.setEnabled(true);
        } else {
            if (this.fReplaceContentAssistHandler == null) {
                return;
            }
            this.fReplaceContentAssistHandler.setEnabled(false);
        }
    }

    public void setVisible(boolean visible) {
        if (visible && this.fPattern != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.fPattern.setItems(this.getPreviousSearchPatterns());
                this.fExtensions.setItems(this.getPreviousExtensions());
                this.initializePatternControl();
            }
            this.fPattern.setFocus();
            this.getContainer().setPerformActionEnabled(this.getContainer().hasValidScope());
        }
        super.setVisible(visible);
    }

    private void showRegExSyntaxError(PatternSyntaxException ex) {
        String title = SearchMessages.getString((String)"SearchPage.regularExpressionSyntaxProblem.title");
        MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)ex.getLocalizedMessage());
    }

    private void statusMessage(boolean error, String message) {
        this.fStatusLabel.setText(message);
        if (error) {
            this.fStatusLabel.setForeground(JFaceColors.getErrorText((Display)this.fStatusLabel.getDisplay()));
        } else {
            this.fStatusLabel.setForeground(null);
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put(STORE_CASE_SENSITIVE, this.fIsCaseSensitive);
        s.put(STORE_IS_REG_EX_SEARCH, this.fIsRegExSearch);
        s.put(STORE_SEARCH_DERIVED, this.fSearchDerived);
    }

    private static class SearchPatternData {
        Set fileNamePatterns;
        boolean ignoreCase;
        boolean isRegExSearch;
        int scope;
        String textPattern;
        IWorkingSet[] workingSets;

        public SearchPatternData(String textPattern, boolean ignoreCase, boolean isRegExSearch, Set fileNamePatterns, int scope, IWorkingSet[] workingSets) {
            this.ignoreCase = ignoreCase;
            this.isRegExSearch = isRegExSearch;
            this.textPattern = textPattern;
            this.fileNamePatterns = fileNamePatterns;
            this.scope = scope;
            this.workingSets = workingSets;
        }
    }
}

