/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text;

import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.core.text.TextSearchEngine;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.FileMatch;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.FileSearchResult;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.SearchResultUpdater;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.internal.core.ISearchScope;
import org.eclipse.search.internal.core.SearchScope;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.MatchLocator;
import org.eclipse.search.internal.core.text.TextSearchScope;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;

public class FileSearchQuery
implements ISearchQuery {
    private FileSearchResult fResult;
    private TextSearchScope fScope;
    private String fSearchOptions;
    private String fSearchString;
    private boolean fVisitDerived;

    public FileSearchQuery(TextSearchScope scope, String options, String searchString) {
        this(scope, options, searchString, false);
    }

    public FileSearchQuery(TextSearchScope scope, String options, String searchString, boolean visitDerived) {
        this.fVisitDerived = visitDerived;
        this.fScope = scope;
        this.fSearchOptions = options;
        this.fSearchString = searchString;
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    protected FileMatch createMatch(IFile file, int start, int length, int lineNumber) {
        return new FileMatch(file, start, length);
    }

    public String getLabel() {
        return SearchMessages.getString((String)"FileSearchQuery.label");
    }

    String getPluralPattern() {
        Object[] args = new String[]{FileSearchQuery.quote(this.fSearchString), "{0}", this.fScope.getDescription()};
        return SearchMessages.getFormattedString((String)"FileSearchQuery.pluralPattern", (Object[])args);
    }

    private String getSearchOptions() {
        return this.fSearchOptions;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new FileSearchResult(this);
            new SearchResultUpdater(this.fResult);
        }
        return this.fResult;
    }

    public String getSearchString() {
        return this.fSearchString;
    }

    String getSingularLabel() {
        Object[] args = new String[]{this.fSearchString, this.fScope.getDescription()};
        return SearchMessages.getFormattedString((String)"FileSearchQuery.singularLabel", (Object[])args);
    }

    static boolean isCaseSensitive(String options) {
        return options.indexOf(105) == -1;
    }

    public boolean isCaseSensitive() {
        return FileSearchQuery.isCaseSensitive(this.getSearchOptions());
    }

    static boolean isRegexSearch(String options) {
        return options.indexOf(114) != -1;
    }

    public boolean isRegexSearch() {
        return FileSearchQuery.isRegexSearch(this.getSearchOptions());
    }

    public static String quote(String searchString) {
        searchString = searchString.replaceAll("\\'", "''");
        return searchString.replaceAll("\\{", "'{'");
    }

    public IStatus run(final IProgressMonitor pm) {
        final AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        textResult.removeAll();
        ITextSearchResultCollector collector = new ITextSearchResultCollector(){

            public void aboutToStart() {
            }

            public void accept(IResourceProxy proxy, String line, int start, int length, int lineNumber) {
                IResource resource = proxy.requestResource();
                if (start < 0) {
                    start = 0;
                }
                if (length < 0) {
                    length = 0;
                }
                textResult.addMatch((Match)FileSearchQuery.this.createMatch((IFile)resource, start, length, lineNumber));
            }

            public void done() {
            }

            public IProgressMonitor getProgressMonitor() {
                return pm;
            }
        };
        return new TextSearchEngine().search(SearchPlugin.getWorkspace(), (ISearchScope)this.fScope, this.fVisitDerived, collector, new MatchLocator(this.fSearchString, this.isCaseSensitive(), this.isRegexSearch()));
    }

    public IStatus searchInFile(final AbstractTextSearchResult result, final IProgressMonitor monitor, IFile file) {
        ITextSearchResultCollector collector = new ITextSearchResultCollector(){

            public void aboutToStart() {
            }

            public void accept(IResourceProxy proxy, String line, int start, int length, int lineNumber) {
                IResource resource = proxy.requestResource();
                if (start < 0) {
                    start = 0;
                }
                if (length < 0) {
                    length = 0;
                }
                result.addMatch((Match)new FileMatch((IFile)resource, start, length));
            }

            public void done() {
            }

            public IProgressMonitor getProgressMonitor() {
                return monitor;
            }
        };
        SearchScope scope = new SearchScope("", new IResource[]{file});
        new TextSearchEngine().search(SearchPlugin.getWorkspace(), (ISearchScope)scope, this.fVisitDerived, collector, new MatchLocator(this.fSearchString, this.isCaseSensitive(), this.isRegexSearch()));
        return Status.OK_STATUS;
    }
}

