/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.action;

import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.PropertiesEditorPlugin;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.MultiPagePropertiesEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.editors.text.TextEditor;

public class ToggleCommentAction
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate {
    private TextEditor textEditor;

    public void dispose() {
        this.textEditor = null;
    }

    public void init(IWorkbenchWindow window) {
        IEditorPart part = window.getActivePage().getActiveEditor();
        if (part != null && part instanceof MultiPagePropertiesEditor) {
            this.textEditor = ((MultiPagePropertiesEditor)part).getEditor();
            this.toggleComment();
        }
    }

    public void run(IAction action) {
        this.toggleComment();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.textEditor = (TextEditor)targetEditor;
    }

    private void toggleComment() {
        IPreferenceStore pStore = PropertiesEditorPlugin.getDefault().getPreferenceStore();
        String commentString = pStore.getString("commentCharacter");
        ITextSelection ts = (ITextSelection)this.textEditor.getSelectionProvider().getSelection();
        int startLineNum = ts.getStartLine();
        int endLineNum = ts.getEndLine();
        IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
        try {
            int startPos = document.getLineOffset(startLineNum);
            StringBuffer strBuf = new StringBuffer();
            int length = 0;
            int comCnt = 0;
            int firstComCnt = 0;
            int lineNum = startLineNum;
            while (lineNum <= endLineNum) {
                int lineLen = document.getLineLength(lineNum);
                length += lineLen;
                String line = document.get(document.getLineOffset(lineNum), document.getLineLength(lineNum));
                if (line != null && line.startsWith(commentString)) {
                    line = line.substring(1, line.length());
                    if (lineNum == startLineNum) {
                        --firstComCnt;
                    } else {
                        --comCnt;
                    }
                } else if (line != null) {
                    line = commentString + line;
                    if (lineNum == startLineNum) {
                        ++firstComCnt;
                    } else {
                        ++comCnt;
                    }
                }
                strBuf.append(line);
                ++lineNum;
            }
            document.replace(startPos, length, strBuf.toString());
            int selectionStartPos = ts.getOffset() + firstComCnt;
            int selectionLength = ts.getLength() + comCnt;
            this.textEditor.getSelectionProvider().setSelection((ISelection)new TextSelection(selectionStartPos, selectionLength));
        }
        catch (BadLocationException e) {
        }
    }
}

