/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.propdev.editors;

import jp.sf.propdev.model.AbstractNode;
import jp.sf.propdev.model.PropertiesNode;
import jp.sf.propdev.model.PropertiesUtils;
import jp.sf.propdev.outline.PropertiesContentOutlinePage;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class EditorSelectionChangedListener
implements ISelectionChangedListener {
    private PropertiesContentOutlinePage outlinePage;
    private PropertiesNode propertiesModel;

    public EditorSelectionChangedListener(PropertiesNode propertiesModel, PropertiesContentOutlinePage outlinePage) {
        this.propertiesModel = propertiesModel;
        this.outlinePage = outlinePage;
    }

    public void install(ISelectionProvider selectionProvider) {
        if (selectionProvider == null) {
            return;
        }
        if (selectionProvider instanceof IPostSelectionProvider) {
            IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
            provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void uninstall(ISelectionProvider selectionProvider) {
        if (selectionProvider == null) {
            return;
        }
        if (selectionProvider instanceof IPostSelectionProvider) {
            IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
            provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            if (this.outlinePage != null && this.outlinePage.isLinkingEnabled()) {
                int offset = textSelection.getOffset();
                AbstractNode curNode = PropertiesUtils.getCurrentNode(this.propertiesModel, offset);
                this.outlinePage.syncedWithEditor(curNode);
            }
        }
    }
}

