/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.miyawaki;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    private static final HashMap<String, String> REF_TITLES = new HashMap();
    private static final Pattern REF;
    private static final Pattern PAGE_REF;

    private LinkedList<Entry> load(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        Entry entry = null;
        LinkedList<Entry> linkedList = new LinkedList<Entry>();
        int n = 0;
        while ((string2 = bufferedReader.readLine()) != null) {
            if ((string2 = string2.trim()).isEmpty()) {
                entry = null;
                continue;
            }
            if (entry == null) {
                entry = new Entry();
                entry.id = n++;
                linkedList.add(entry);
            }
            entry.addLine(string2);
        }
        bufferedReader.close();
        return linkedList;
    }

    private String addref(HashMap<String, Entry> hashMap, String string) {
        Matcher matcher = REF.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = REF_TITLES.get(string2);
            Entry entry = string3 != null ? hashMap.get(string3) : hashMap.get(string2);
            if (entry != null) {
                return String.format("%s<a href=\"#%d\">%s</a>%s", string.substring(0, matcher.start(1)), entry.id, string2, string.substring(matcher.end(1)));
            }
            System.err.println("REF_TITLES.put(\"" + string2 + "\", \"\");");
        }
        return string;
    }

    private String addPageref(String string, boolean bl) {
        if (!bl) {
            return string;
        }
        Matcher matcher = PAGE_REF.matcher(string);
        StringBuilder stringBuilder = null;
        int n = 0;
        while (matcher.find()) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string.substring(n, matcher.start()));
            String string2 = matcher.group(1);
            stringBuilder.append(String.format("<a href=\"#p%s\">p.%s</a>", string2, string2));
            n = matcher.end();
        }
        if (n == 0) {
            return string;
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    private void output(LinkedList<Entry> linkedList, boolean bl) {
        HashMap<String, Entry> hashMap = new HashMap<String, Entry>();
        for (Entry entry : linkedList) {
            if (hashMap.containsKey(entry.title)) {
                System.err.println("*** DUPLICATED *** " + entry.title);
            }
            hashMap.put(entry.title, entry);
            hashMap.put(entry.title.toUpperCase(), entry);
        }
        System.out.println("<html><body>");
        for (Entry entry : linkedList) {
            System.out.print("<dt id=\"" + entry.id + "\">" + entry.title + "</dt><dd>");
            if (entry.page != null) {
                System.out.print("\u3000" + this.addPageref(entry.page, bl));
            }
            System.out.println();
            for (String string : entry.list) {
                System.out.println("<p>" + this.addPageref(this.addref(hashMap, string), bl) + "</p>");
            }
            System.out.println("</dd>");
        }
        if (bl) {
            for (int i = 3; i <= 475; ++i) {
                System.out.println("<dt id=\"p" + i + "\">" + i + "</dt><dd><p><img src=\"p/" + i + ".bmp\"/></p></dd>");
            }
        }
        System.out.println("</body></html>");
    }

    public static void main(String[] stringArray) throws Exception {
        ZephyrUtil.setShiftJisOuput();
        String string = stringArray.length > 0 ? stringArray[0] : "EJBTD_index.txt";
        boolean bl = stringArray.length > 1 ? stringArray[1].equalsIgnoreCase("true") : false;
        MakeBodyHtml makeBodyHtml = new MakeBodyHtml();
        LinkedList<Entry> linkedList = makeBodyHtml.load(string);
        makeBodyHtml.output(linkedList, bl);
    }

    static {
        REF_TITLES.put("1) AS MANY", "as many");
        REF_TITLES.put("1) BAD", "bad");
        REF_TITLES.put("1) GO TO HELL!", "Go to hell!");
        REF_TITLES.put("ABSOLUTE ROSE", "absolute rose, an");
        REF_TITLES.put("BEST BEFORE DATE", "best before date, a");
        REF_TITLES.put("ELECTRIC CAR", "electric car, an");
        REF_TITLES.put("GAP IN REALITY", "gap in reality, a");
        REF_TITLES.put("LEAP OF FAITH", "leap of faith, a");
        REF_TITLES.put("MOP UP THE FLOOR WITH", "mop up the floor with \uff5e");
        REF_TITLES.put("NOT GIVE A FROG JUMP ABOUT", "not give a frog jump about \uff5e");
        REF_TITLES.put("ONE WHO GOT AWAY", "one who got away, the");
        REF_TITLES.put("PUT A BRAVE FACE ON", "put a brave face on \uff5e");
        REF_TITLES.put("SPACE CADET", "space cadet, a");
        REF_TITLES.put("STIFF UPPER LIP", "stiff upper lip, a");
        REF_TITLES.put("TEA SHOP", "tea shop, a");
        REF_TITLES.put("UNMARRIED MOTHER", "unmarried mother, an");
        REF_TITLES.put("WHOLE NINE YARDS", "whole nine yards, the");
        REF_TITLES.put("WHOLE TRUTH AND NOTHING BUT THE TRUTH", "whole truth and nothing but the truth, the");
        REF_TITLES.put("Y0U CAN'T EAT YOUR CAKE AND HAVE IT, TOO.", "You can't eat your cake and have it, too.");
        REF = Pattern.compile("\u21d2 +?(.+) +?\\(p\\.");
        PAGE_REF = Pattern.compile("p\\.([0-9]+)");
    }

    private static class Entry {
        int id;
        String title = null;
        String page = null;
        LinkedList<String> list = new LinkedList();

        private Entry() {
        }

        void addLine(String string) {
            if (this.title == null) {
                this.title = string;
            } else if (this.page == null && string.matches("p\\.[0-9]+")) {
                this.page = string;
            } else {
                this.list.add(string);
            }
        }
    }
}

