/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.encol;

import java.util.LinkedList;
import zephyr.kenkyusha.encol.NextWords;
import zephyr.kenkyusha.encol.POSType;

public class Word
implements Comparable<Word> {
    final String word;
    final String tag;
    final POSType pos;
    final LinkedList<String> list = new LinkedList();
    NextWords nexts = null;
    int num = 1;

    Word(String string) {
        this(string, null, false);
    }

    Word(String string, String string2) {
        this(string, string2, false);
    }

    Word(String string, String string2, boolean bl) {
        this.word = string.toLowerCase();
        this.tag = bl ? string2 : null;
        this.pos = string.equals("sb") ? POSType.PRON : POSType.tag2pos(string2);
    }

    Word(POSType pOSType) {
        this.word = pOSType.abbr;
        this.tag = null;
        this.pos = pOSType;
    }

    String key() {
        return this.word + this.pos.name();
    }

    void addSentence(String string) {
        this.list.add(string);
    }

    Word addNextWord(String string, String string2) {
        if (this.nexts == null) {
            this.nexts = new NextWords();
        }
        Word word = new Word(string, string2);
        if (word.pos != POSType.OTHER) {
            return this.nexts.addWord(word);
        }
        return null;
    }

    Word addNextWordFrom(String string, String string2) {
        Word word = new Word(string, string2);
        if (word.pos != POSType.OTHER) {
            if (this.nexts == null) {
                this.nexts = new NextWords();
            }
            return this.nexts.addWordForm(word);
        }
        return null;
    }

    @Override
    public int compareTo(Word word) {
        int n = word.list.size() - this.list.size();
        if (n != 0) {
            return n;
        }
        n = this.word.compareTo(word.word);
        if (n != 0) {
            return n;
        }
        return this.pos.order - word.pos.order;
    }
}

