/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.petitroyal;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.HashMap;
import javax.imageio.ImageIO;
import zephyr.util.BIMUtil;
import zephyr.util.PDF2Jpeg;

public class PrefacePDF2Jpeg
extends PDF2Jpeg {
    private static final HashMap<String, String[]> DIV_MAP = new HashMap();

    protected PrefacePDF2Jpeg(int n) {
        super(n);
    }

    @Override
    protected void write(BufferedImage bufferedImage, String string, File file) throws Exception {
        String string2 = file.getName();
        String[] stringArray = DIV_MAP.get(string2);
        if (stringArray == null) {
            ImageIO.write((RenderedImage)bufferedImage, this.OUTPUT_TYPE, file);
            System.out.print(file.getName() + " ");
        } else if (stringArray.length == 1) {
            ImageIO.write((RenderedImage)bufferedImage, this.OUTPUT_TYPE, new File(file.getParentFile(), stringArray[0]));
            System.out.print(stringArray[0] + " ");
        } else if (stringArray.length > 1) {
            int n = bufferedImage.getWidth() / stringArray.length;
            int n2 = 0;
            int n3 = 0;
            while (n3 < stringArray.length) {
                int n4 = n;
                if (n2 + n4 > bufferedImage.getWidth()) {
                    n4 = bufferedImage.getWidth() - n2;
                }
                BufferedImage bufferedImage2 = bufferedImage.getSubimage(n2, 0, n4, bufferedImage.getHeight());
                bufferedImage2 = BIMUtil.trim(bufferedImage2);
                ImageIO.write((RenderedImage)bufferedImage2, this.OUTPUT_TYPE, new File(file.getParentFile(), stringArray[n3]));
                System.out.print(stringArray[n3] + " ");
                ++n3;
                n2 += n;
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("Usage: java PrefacePDF2Jpeg sample.pdf outDir [dpi] [startIdx] [outputPrefix]");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : 200;
        int n2 = stringArray.length > 3 ? Integer.parseInt(stringArray[3]) : -1;
        String string3 = stringArray.length > 4 ? stringArray[4] : null;
        PrefacePDF2Jpeg prefacePDF2Jpeg = new PrefacePDF2Jpeg(n);
        prefacePDF2Jpeg.convert(string, string2, string3, n2, n);
    }

    static {
        DIV_MAP.put("preface-1.jpg", new String[]{"preface-1.jpg"});
        DIV_MAP.put("preface-2.jpg", new String[]{"preface-2.jpg", "usage-1.jpg"});
        DIV_MAP.put("preface-3.jpg", new String[]{"usage-2.jpg", "usage-3.jpg"});
        DIV_MAP.put("preface-4.jpg", new String[]{"usage-4.jpg"});
    }
}

