/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.encol;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import zephyr.kenkyusha.encol.POSType;
import zephyr.kenkyusha.encol.Word;

public class NextWords {
    private HashMap<String, Word> wordsMap = null;
    private Word pron = null;
    private Word be = null;
    private static final HashSet<String> pronActs = new HashSet();
    private static final HashSet<String> beVerbs = new HashSet();
    private static final Word[] EMPTY_WORDS;

    Word addWord(Word word) {
        if (this.wordsMap == null) {
            this.wordsMap = new HashMap();
            this.wordsMap.put(word.key(), word);
            return word;
        }
        if (word.pos == POSType.PRON && pronActs.contains(word.word)) {
            if (this.pron != null) {
                ++this.pron.num;
                return this.pron;
            }
            this.pron = new Word("sb", "PRP");
            this.wordsMap.put(this.pron.key(), this.pron);
            return this.pron;
        }
        if (word.pos == POSType.VERB && beVerbs.contains(word.word)) {
            if (this.be != null) {
                ++this.be.num;
                return this.be;
            }
            this.be = new Word("BE", "VB");
            this.wordsMap.put(this.be.key(), this.be);
            return this.be;
        }
        Word word2 = this.wordsMap.get(word.key());
        if (word2 != null) {
            ++word2.num;
            return word2;
        }
        this.wordsMap.put(word.key(), word);
        return word;
    }

    Word addWordForm(Word word) {
        if (this.wordsMap == null) {
            this.wordsMap = new HashMap();
        }
        if (word.pos != POSType.PRE) {
            Word word2 = new Word(word.pos);
            Word word3 = this.wordsMap.get(word2.key());
            if (word3 != null) {
                ++word3.num;
                return word3;
            }
            this.wordsMap.put(word2.key(), word2);
            return word2;
        }
        Word word4 = this.wordsMap.get(word.key());
        if (word4 != null) {
            ++word4.num;
            return word4;
        }
        this.wordsMap.put(word.key(), word);
        return word;
    }

    Word[] getAll() {
        if (this.wordsMap == null) {
            return EMPTY_WORDS;
        }
        Object[] objectArray = this.wordsMap.values().toArray(new Word[0]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    static {
        pronActs.add("me");
        pronActs.add("you");
        pronActs.add("him");
        pronActs.add("her");
        pronActs.add("us");
        pronActs.add("them");
        pronActs.add("sb");
        beVerbs.add("am");
        beVerbs.add("are");
        beVerbs.add("is");
        beVerbs.add("was");
        beVerbs.add("were");
        EMPTY_WORDS = new Word[0];
    }
}

