/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kagakudoujin.kagakueigo;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import zephyr.kagakudoujin.kagakueigo.EntryData;
import zephyr.kagakudoujin.kagakueigo.FileLoader;
import zephyr.kagakudoujin.kagakueigo.KatuyouWriter;
import zephyr.kagakudoujin.kagakueigo.Util;
import zephyr.util.ZephyrUtil;

public class MakeKatuyouHtml {
    private final KatuyouWriter kWriter;
    private final HashMap<String, String> valuesMap = new HashMap();

    MakeKatuyouHtml(String[] stringArray) {
        this.kWriter = new KatuyouWriter(stringArray, 1);
    }

    private String entry2txt(EntryData entryData) {
        return entryData != null ? entryData.txt : null;
    }

    private void parse(byte[] byArray) {
        String string = Util.getString(byArray, 0, 4);
        String string2 = this.valuesMap.remove(string);
        EntryData entryData = Util.getData(byArray, Util.DELIM_02, 0);
        EntryData entryData2 = Util.getData(byArray, Util.DELIM_03, entryData.nextIndex);
        int n = entryData != null ? entryData.nextIndex : 0;
        EntryData entryData3 = Util.getData(byArray, Util.DELIM_ENG_TRANS, n);
        n = entryData3 != null ? entryData3.nextIndex : n;
        String[] stringArray = Util.getDataList(byArray, Util.DELIM_EN_WORDS, n);
        String[] stringArray2 = Util.getDataList(byArray, Util.DELIM_JP_WORDS, n);
        EntryData entryData4 = Util.getData(byArray, Util.DELIM_REL_WORDS, n);
        this.kWriter.addEntry(this.entry2txt(entryData2), this.entry2txt(entryData), this.entry2txt(entryData3), string2, stringArray, stringArray2, this.entry2txt(entryData4));
    }

    private void loadValues(File file) throws Exception {
        byte[] byArray = FileLoader.loadBinary(file);
        if (byArray == null) {
            System.err.println(file.getAbsolutePath() + " \u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            System.exit(1);
        }
        byte[] byArray2 = new byte[]{1, 8};
        int n = 4608;
        while ((n = Util.findData(byArray, n, byArray.length, byArray2)) >= 0) {
            int n2;
            String string;
            int n3 = n + byArray2.length;
            byte by = byArray[n3];
            if (by <= 0 || by > 4) {
                n = n3;
                continue;
            }
            if (!(string = Util.getString(byArray, ++n3, n3 + by)).matches("[0-9]+")) {
                n += byArray2.length;
                continue;
            }
            n3 += by;
            if ((n2 = (byArray[n3 += 6] << 8 & 0xFF00) + (byArray[n3 + 1] & 0xFF)) <= 0) {
                n += byArray2.length;
                continue;
            }
            String string2 = Util.getString(byArray, n3 += 2, n3 + n2);
            String string3 = String.format("%04d", Integer.parseInt(string));
            this.valuesMap.put(string3, string2);
            n = n3 + n2;
        }
    }

    private void load(File file) throws Exception {
        LinkedList<byte[]> linkedList = FileLoader.load(file, Util.DELIM_K_ENTRY);
        for (byte[] byArray : linkedList) {
            this.parse(byArray);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray.length > 0 ? stringArray[0] : "Dict\\katuyou\\DBSite\\DATA\\@f02003.dat";
        String string2 = stringArray.length > 1 ? stringArray[1] : "Dict\\katuyou\\DBSite\\DATA\\@Value.dat";
        File file = new File(string);
        System.err.println(file.getAbsolutePath() + " \u304b\u3089\u53d6\u308a\u8fbc\u307f\u307e\u3059");
        ZephyrUtil.setShiftJisOuput();
        MakeKatuyouHtml makeKatuyouHtml = new MakeKatuyouHtml(stringArray);
        makeKatuyouHtml.loadValues(new File(string2));
        makeKatuyouHtml.load(file);
        makeKatuyouHtml.kWriter.out();
    }
}

