/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.AppendLatinKeys;
import zephyr.util.ZephyrUtil;

public class AppendJPKeys
extends AppendLatinKeys {
    public static final String JPWORD_REGEXP = "(<b>)?([\u3041-\u30fa\u30fc-\u9fff][0-9\u3041-\u30fa\u30fc-\u9fff]*)";
    public static final Pattern JPWORD = Pattern.compile("(<b>)?([\u3041-\u30fa\u30fc-\u9fff][0-9\u3041-\u30fa\u30fc-\u9fff]*)");
    private static final String SENSE_REGEXP = "(<indent val=\"([0-9])\">)?<p>(.+?)</p>";
    private static final Pattern SENSE = Pattern.compile("(<indent val=\"([0-9])\">)?<p>(.+?)</p>");

    public static boolean isKataKana(char c) {
        return '\u30a1' <= c && c <= '\u30f6' || c == '\u30fc';
    }

    public static boolean isKana(char c) {
        return '\u3041' <= c && c <= '\u30fc';
    }

    public static char kata2hira(char c) {
        if (c != '\u30fc') {
            return (char)(c - 12449 + 12353);
        }
        return c;
    }

    public static String makeKana(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (AppendJPKeys.isKataKana(string.charAt(i))) continue;
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(AppendJPKeys.kata2hira(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    protected AppendJPKeys() {
        super(JPWORD, "Japanese");
    }

    public static String dropBracket(String string) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"\u300a(.+?)\u300b", "\u3014(.+?)\u3015", "\\((.+?)\\)", "\\[(.+?)\\]"}) {
            string = string.replaceAll(string2, " $1 ");
        }
        return string;
    }

    @Override
    protected String makePlainText(String string) {
        string = AppendJPKeys.dropBracket(string);
        Matcher matcher = SENSE.matcher(string);
        String string2 = "";
        int n = 1;
        while (matcher.find()) {
            if (matcher.group(2) != null) {
                n = Integer.parseInt(matcher.group(2));
            }
            if (n > true) continue;
            string2 = string2 + matcher.group(3) + " ";
        }
        return string2;
    }

    @Override
    public String makeKeys(String string, String string2, String string3, Set<String> set) {
        String string4 = super.makeKeys(string, string2, string3, set);
        for (String string5 : set) {
            String string6 = AppendJPKeys.makeKana(string5);
            if (string6 == null) continue;
            string4 = string4 + String.format("<key type=\"\u304b\u306a\" title=\"%s\">%s</key>", this.makeKeyTitle(string, string5), string6);
        }
        return string4;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Usage: java AppendJPKeys [body-lajputf8.html|-] [\u8868\u8a18|\u6761\u4ef6]");
            return;
        }
        ZephyrUtil.setUTF8Ouput();
        AppendJPKeys appendJPKeys = new AppendJPKeys();
        try {
            appendJPKeys.appendKeys(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

