/*
 * Decompiled with CFR 0.152.
 */
package zephyr.taishukan.daikanwa;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PDF2BMPPage {
    private void convert(File file, File file2, int n, int n2, int n3) throws Exception {
        if (!file.exists()) {
            System.err.println(file + " \u304c\u3042\u308a\u307e\u305b\u3093");
            return;
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        System.out.println(file.getName() + " \u5909\u63db\u958b\u59cb");
        PDDocument pDDocument = PDDocument.load((File)file);
        PDFRenderer pDFRenderer = new PDFRenderer(pDDocument);
        int n4 = n2 - n + 1;
        for (int i = 1; i <= n4; ++i) {
            BufferedImage bufferedImage = pDFRenderer.renderImageWithDPI(n + i - 1, (float)n3, ImageType.BINARY);
            File file3 = new File(file2, String.format("%04x.bmp", i));
            ImageIO.write((RenderedImage)bufferedImage, "bmp", file3);
            System.out.print(i + " ");
        }
        pDDocument.close();
        System.out.println();
        System.out.println(file.getName() + " \u5909\u63db\u7d42\u4e86");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 4) {
            System.err.println("Usage: java PDF2BMPPage file.pdf outDir startPage endPage [dpi]");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n = Integer.parseInt(stringArray[2]);
        int n2 = Integer.parseInt(stringArray[3]);
        int n3 = stringArray.length >= 5 ? Integer.parseInt(stringArray[4]) : 200;
        PDF2BMPPage pDF2BMPPage = new PDF2BMPPage();
        pDF2BMPPage.convert(new File(string), new File(string2), n, n2, n3);
    }
}

