/*
 * Decompiled with CFR 0.152.
 */
package zephyr.iwanami.jukugohoni;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.util.Matrix;

public class TextStripper
extends PDFTextStripper {
    private static boolean DUMP_TP = false;
    private static final String RET = System.lineSeparator();
    private static final String PRET = "</p>" + RET + "<p>";
    private static final float TOP_MARGIN_UNIT = TextStripper.mm2unit(17.0);
    private static final float LEFT_WIDTH_UNIT = TextStripper.mm2unit(105.0);
    private final String filename;
    private final int pageBias;
    private String metaData = "";
    private float leftWidthUnit = Float.MAX_VALUE;
    private boolean detectBody = true;
    private final LinkedList<TextPosition> leftTP = new LinkedList();
    private final LinkedList<TextPosition> rightTP = new LinkedList();
    private static final HashMap<Double, CharType> size2typeMap = new HashMap();
    private CharType prevType = CharType.Normal;
    private final HashMap<String, String> footnoteMap = new HashMap();
    private boolean inP = false;
    private boolean inDd = false;
    private static final TextPosition EmptyDT = new TextPosition(0, 0.0f, 0.0f, new Matrix(), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, "", null, null, 0.0f, (int)CharType.Dt.size);
    private final LinkedList<String> footnotes = new LinkedList();
    private int inPlen = 0;
    private static final Pattern CREATE_DATE = Pattern.compile("<xmp:CreateDate>([^<>]+)</xmp:CreateDate>");
    private static final Pattern MODIFY_DATE = Pattern.compile("<xmp:ModifyDate>([^<>]+)</xmp:ModifyDate>");

    private static float mm2unit(double d) {
        return (float)(d * 72.0 / 25.4);
    }

    public TextStripper(String string) throws IOException {
        PDDocument pDDocument = PDDocument.load((File)new File(string));
        int n = pDDocument.getNumberOfPages();
        pDDocument.close();
        System.err.println(n + "\u30da\u30fc\u30b8");
        switch (n) {
            case 2015: {
                System.err.println("\u65b0\u7248\u7b2c\uff11\u5237\u3068\u3057\u3066\u51e6\u7406\u3057\u307e\u3059");
                this.pageBias = 1;
                break;
            }
            case 2014: {
                System.err.println("\u65b0\u7248\u7b2c\uff13\u5237\u3068\u3057\u3066\u51e6\u7406\u3057\u307e\u3059");
                this.pageBias = 0;
                break;
            }
            default: {
                System.err.println("\u672a\u77e5\u306e\u30da\u30fc\u30b8\u6570\u3067\u3059");
                System.err.println("https://ja.osdn.net/projects/projectzephyr/forums/28849/ \u307e\u3067\u304a\u77e5\u3089\u305b\u304f\u3060\u3055\u3044");
                this.filename = null;
                this.pageBias = 0;
                return;
            }
        }
        this.filename = string;
    }

    private int pageNo(int n) {
        return n > 4 ? n + this.pageBias : n;
    }

    protected void writeString(String string, List<TextPosition> list) throws IOException {
        super.writeString(string, list);
        for (TextPosition textPosition : list) {
            if (textPosition.getY() < TOP_MARGIN_UNIT) continue;
            if (textPosition.getX() < this.leftWidthUnit) {
                this.leftTP.add(textPosition);
                continue;
            }
            this.rightTP.add(textPosition);
        }
    }

    private CharType detectTypeBody(TextPosition textPosition) {
        double d = textPosition.getFontSizeInPt();
        CharType charType = size2typeMap.get(d);
        if (charType != null) {
            if (!(charType != CharType.FootnoteNo || textPosition.getFont().getName().equals("LSQGKM+Futura-Medium") && textPosition.getUnicode().matches("[0-9]"))) {
                return CharType.Normal;
            }
            return charType;
        }
        String string = textPosition.getFont().getName();
        if (string.endsWith("RyuminPr6-Ultra")) {
            return CharType.BoldEnglish;
        }
        if (string.equals("IYXQRC+RyuminPr6-Light") && textPosition.getUnicode().equals("^")) {
            return CharType.Normal;
        }
        if (string.equals("RIXJLL+RyuminPr6-Light") && textPosition.getUnicode().equals(" ")) {
            return CharType.Normal;
        }
        if (string.equals("JTRVBB+seikoshaRuby-OTF") && textPosition.getUnicode().equals("\u3000")) {
            return CharType.Normal;
        }
        if (string.equals("GAPFBW+RyuminPr6-Light") || string.equals("GAPFBW+OTEditFont")) {
            return CharType.Normal;
        }
        if (d != 7.0) {
            System.err.println(textPosition.getUnicode() + "\t" + textPosition.getFont().getName() + " " + textPosition.getFontSizeInPt());
        }
        return CharType.Normal;
    }

    private CharType detectTypePre(TextPosition textPosition) {
        String string;
        if ((double)textPosition.getFontSizeInPt() >= 10.0 && !textPosition.getUnicode().equals("\u2015")) {
            return CharType.PrePartTile;
        }
        String string2 = textPosition.getFont().getName();
        if (string2.equals("IISACS+GothicMB101Pr6-Regular")) {
            return CharType.PreParaTitle;
        }
        if (this.getCurrentPageNo() == this.pageNo(11) && ((string = textPosition.getUnicode()).equals("\u3010") || string.equals("\u3011"))) {
            return CharType.PreParaTitle;
        }
        if (string2.equals("MWHPJP+RyuminPr6-Ultra") || string2.equals("GNVUPM+RyuminPr6-Ultra")) {
            return CharType.BoldEnglish;
        }
        return CharType.Normal;
    }

    private void loadRight() {
        this.footnoteMap.clear();
        boolean bl = true;
        String string = "";
        StringBuilder stringBuilder = new StringBuilder();
        for (TextPosition textPosition : this.rightTP) {
            double d = textPosition.getFontSizeInPt();
            String string2 = textPosition.getUnicode();
            if (d == 5.0 && string2.matches("[0-9]")) {
                if (!bl) {
                    this.footnoteMap.put(string, stringBuilder.toString());
                    string = "";
                    stringBuilder = new StringBuilder();
                }
                string = string + string2;
                bl = true;
            } else {
                bl = false;
            }
            stringBuilder.append(string2);
        }
        if (string.length() > 0) {
            this.footnoteMap.put(string, stringBuilder.toString());
        }
    }

    private void addFootnotes(StringBuilder stringBuilder) {
        if (!this.footnotes.isEmpty()) {
            for (String string : this.footnotes) {
                stringBuilder.append("</p>");
                stringBuilder.append(RET);
                stringBuilder.append("<p>\u3000\u3000");
                stringBuilder.append(string);
            }
            this.footnotes.clear();
            stringBuilder.append("</p>");
            stringBuilder.append(RET);
            this.inP = false;
        }
    }

    private void outputLeft() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        this.leftTP.add(EmptyDT);
        boolean bl = this.getCurrentPageNo() >= this.pageNo(1952);
        for (TextPosition textPosition : this.leftTP) {
            String string2;
            CharType charType = this.detectTypeBody(textPosition);
            boolean bl2 = false;
            if (charType != this.prevType && this.prevType != null) {
                if (bl && (this.prevType == CharType.Dt || this.prevType == CharType.PartTitle)) {
                    stringBuilder.append(" *");
                }
                stringBuilder.append(this.prevType.close);
                if (charType == CharType.Dt && this.prevType != CharType.PartTitle) {
                    this.addFootnotes(stringBuilder);
                    if (this.inDd && textPosition != EmptyDT) {
                        if (this.inP) {
                            stringBuilder.append("</p>");
                        }
                        stringBuilder.append("</dd>");
                        this.inP = false;
                        this.inDd = false;
                    }
                } else if (charType == CharType.PartTitle && (this.inDd || stringBuilder.length() > 0)) {
                    if (this.inP) {
                        stringBuilder.append("</p>");
                    }
                    stringBuilder.append("</dd>");
                    stringBuilder.append(RET);
                    this.inP = false;
                    this.inDd = false;
                }
                if (textPosition == EmptyDT) break;
                if (charType != CharType.BoldEnglish) {
                    stringBuilder.append(charType.open);
                } else {
                    bl2 = true;
                }
            }
            if (charType == CharType.Dt) {
                this.inP = true;
                this.inDd = true;
            } else if (!(this.inP || charType != CharType.Normal && charType != CharType.BoldEnglish)) {
                stringBuilder.append("<p>[p.");
                stringBuilder.append(this.getCurrentPageNo() - this.pageNo(26));
                stringBuilder.append("]</p>");
                stringBuilder.append(RET);
                stringBuilder.append("<p>");
                this.inP = true;
            }
            if (bl2) {
                stringBuilder.append(charType.open);
            }
            if ((string2 = textPosition.getUnicode()) != null) {
                for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    if (c == '\ufe32' && textPosition.getFont().getName().endsWith("RyuminPr6-Light")) {
                        stringBuilder.append('-');
                        continue;
                    }
                    if (string2.matches("[\u2460-\u2473\u3251-\u32b1]")) {
                        stringBuilder.append("<br>" + RET);
                        stringBuilder.append(string2);
                        continue;
                    }
                    if (c == '\u0000') continue;
                    if (c == '\u0261' && charType == CharType.Dt) {
                        stringBuilder.append('g');
                        continue;
                    }
                    stringBuilder.append(c);
                }
            }
            if (charType == CharType.FootnoteNo) {
                if (string == null) {
                    string = "";
                }
                string = string + string2;
            } else if (string != null) {
                String string3 = this.footnoteMap.get(string);
                if (string3 != null) {
                    this.footnotes.add(string3);
                } else {
                    System.out.println();
                    System.out.println(stringBuilder.toString());
                    System.out.println();
                    System.out.println("cannot find footnote " + string + " at page " + this.getCurrentPageNo());
                    System.out.println();
                }
                string = null;
            }
            this.prevType = charType;
        }
        this.leftTP.removeLast();
        Object object = stringBuilder.toString();
        object = ((String)object).replace("</b> <b>", " ");
        object = ((String)object).replaceAll("[\\\uff08\uff08]\uff1d([^\\(\\)\uff08\uff09<>]+)[\\\uff09\uff09]", "(\uff1d<i>$1</i>)");
        object = ((String)object).replace("</sup>\uff09", "\uff09</sup>");
        object = ((String)object).replace("\uff08<sub>", "<sub>\uff08");
        object = ((String)object).replace("</sub>\uff09", "\uff09</sub>");
        int n = this.getCurrentPageNo();
        if (n == this.pageNo(426)) {
            object = ((String)object).replaceFirst("Louis *.\u4e16\u306e", "Louis XIV\u4e16\u306e");
        } else if (n == this.pageNo(880)) {
            object = ((String)object).replace("<dt>L</dt><dd><p>,</p></dd>" + RET + "<dt> l</dt>", "<dt>L, l</dt>");
        } else if (n == this.pageNo(1814)) {
            object = ((String)object).replace("<dt>V</dt><dd><p>, </p></dd>" + RET + "<dt>v</dt>", "<dt>V, v</dt>");
        } else if (n == this.pageNo(2010)) {
            object = (String)object + "</p></dd>" + RET;
        }
        System.out.print((String)object);
    }

    private boolean isParaStart(TextPosition textPosition, CharType charType, String string) {
        if (charType != CharType.Normal && charType != CharType.BoldEnglish) {
            return false;
        }
        if (string.equals("\u3000") && (double)textPosition.getFontSizeInPt() == 8.0 && (!this.inP || this.inPlen >= 10)) {
            return true;
        }
        return (this.prevType == CharType.PreParaTitle || this.prevType == CharType.PrePartTile) && !this.inP;
    }

    private void outputPre() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TextPosition textPosition : this.leftTP) {
            String string;
            CharType charType = this.detectTypePre(textPosition);
            if (charType != this.prevType && this.prevType != null) {
                stringBuilder.append(this.prevType.close);
                if (charType != CharType.BoldEnglish && this.prevType != CharType.BoldEnglish) {
                    if (this.inP) {
                        stringBuilder.append("</p>");
                        this.inP = false;
                    }
                    stringBuilder.append(RET);
                }
                stringBuilder.append(charType.open);
            }
            if (this.isParaStart(textPosition, charType, string = textPosition.getUnicode())) {
                if (this.inP) {
                    stringBuilder.append("</p>");
                    stringBuilder.append(RET);
                }
                stringBuilder.append("<p>");
                this.inP = true;
                this.inPlen = 0;
            }
            if (string.equals("\ufe32") && textPosition.getFont().getName().endsWith("RyuminPr6-Light")) {
                stringBuilder.append('-');
            } else {
                stringBuilder.append(string);
            }
            if (this.inP) {
                this.inPlen += string.length();
            }
            this.prevType = charType;
        }
        Object object = stringBuilder.toString();
        int n = this.getCurrentPageNo();
        if (n == this.pageNo(3)) {
            object = ((String)object).replace("<h1>SAITO\u2019SIDIOMOLOGICALENGLISH-JAPANESEDICTIONARY\u719f\u8a9e\u672c\u4f4d\u82f1\u548c\u4e2d\u8f9e\u5178\u658e\u85e4\u79c0\u4e09\u90ce\u8457\u8c4a\u7530\u3000\u5b9f\u5897\u88dc\u516b\u6728\u514b\u6b63\u6821\u6ce8NEW EDITION\u65b0\u3000\u7248\u5ca9\u6ce2\u66f8\u5e97", "<h1>\u8868\u7d19</h1>" + RET + "<p>\u3000\u3000\u3000\u3000SAITO\u2019S<br>\u3000IDIOMOLOGICAL<br>ENGLISH-JAPANESE<br>\u3000\u3000DICTIONARY<br><br>\u719f\u8a9e\u672c\u4f4d \u82f1\u548c\u4e2d\u8f9e\u5178<br>\u3000\u3000\u658e\u85e4\u79c0\u4e09\u90ce \u8457<br>\u3000\u3000\u8c4a\u7530\u3000\u5b9f \u5897\u88dc<br>\u3000\u3000\u516b\u6728\u514b\u6b63 \u6821\u6ce8<br>\u3000\u3000NEW EDITION<br>\u3000\u3000\u3000\u3000\u65b0\u3000\u7248<br><br>\u3000\u3000\u3000\u5ca9\u6ce2\u66f8\u5e97</p>");
            if (this.metaData.length() > 0) {
                object = (String)object + RET + "<p><br><br>PDF\u30d7\u30ed\u30d1\u30c6\u30a3</p>" + RET + this.metaData;
            }
            this.prevType = CharType.Normal;
        } else if (n == this.pageNo(9)) {
            object = ((String)object).replace("\u795e</p>" + RET + "<p>\u3000\u5d0e\u3000\u9ad8\u3000\u660e\u4e95\u3000\u4e0a\u3000\u4e9c</p>" + RET + "<p>\u3000\u4f9d\u4f4f\u3000\u5409\u3000\u3000\u3000\u8aa0\u3000\u7279", "</p>" + RET + "<p>\u3000\u3000\u3000\u3000\u795e\u3000\u5d0e\u3000\u9ad8\u3000\u660e</p>" + RET + "<p>\u3000\u3000\u3000\u3000\u4e95\u3000\u4e0a\u3000\u4e9c\u3000\u4f9d</p>" + RET + "<p>\u3000\u3000\u3000\u3000\u4f4f\u3000\u5409\u3000\u3000\u3000\u8aa0</p>" + RET + "<p>\u3000\u7279");
        } else if (n == this.pageNo(10)) {
            object = ((String)object).replace("\u2022", PRET + "\u3000\u2022");
        } else if (n == this.pageNo(11)) {
            object = ((String)object).replace("<h2>\u3010</h2>" + RET + "<p>\u672c\u6587</p>" + RET + "<h2>\u3011</h2>" + RET + "<p>\u767a\u97f3", "<h2>\u3010\u672c\u6587\u3011\u767a\u97f3</h2>" + RET + "<p>");
            object = ((String)object).replace("<h2>\u3010</h2>" + RET + "<p>\u6821\u6ce8</p>" + RET + "<h2>\u3011</h2>", "<h2>\u3010\u6821\u6ce8\u3011</h2>");
            object = ((String)object).replace("\u7528\u4f8b\u306e\u51fa\u5178</p>", "</p>" + RET + "<h2>\u7528\u4f8b\u306e\u51fa\u5178</h2>");
            object = ((String)object).replace("book \u4f4d\u76f8\u8868\u793a", "book</p>" + RET + "<h2>\u4f4d\u76f8\u8868\u793a</h2>" + RET + "<p>");
            object = ((String)object).replace("\u5f15\u7528\u3057\u305f.C. Dickens", "\u5f15\u7528\u3057\u305f.</p>" + RET + "<p>\u3000\u3000C. Dickens");
            object = ((String)object).replace("\u304a\u308a\u307e\u3059\u30b3\u30ea\u30f3\u30c8", "\u304a\u308a\u307e\u3059</p>" + RET + "<p>\u3000\u3000\u30b3\u30ea\u30f3\u30c8");
            object = ((String)object).replace("\u793a\u3057\u305f\uff0ein\uff3b", "\u793a\u3057\u305f\uff0e</p>" + RET + "<p>\u3000\u3000in\uff3b");
        } else if (n == this.pageNo(12)) {
            object = ((String)object).replace("\u5206\u91ce\u8868\u793a</p>", "</p>" + RET + "<h2>\u5206\u91ce\u8868\u793a</h2>");
            object = ((String)object).replace("\u793a\u3057\u305f\uff0e\u305d\u306e\u307b\u304b", "\u793a\u3057\u305f\uff0e" + PRET + "\u305d\u306e\u307b\u304b");
        } else if (n == this.pageNo(15)) {
            object = ((String)object).replace("\u8868\u3059\u308b\uff0e\u662d\u548c", "\u8868\u3059\u308b\uff0e</p>" + RET + "<p>\u3000\u3000\u662d\u548c");
        } else if (n == this.pageNo(19)) {
            object = ((String)object).replace("<p>HE", "<p>THE");
        } else if (n == this.pageNo(22)) {
            object = ((String)object).replace("student.H. SAITO.June", "student.</p>" + RET + "<p>\u3000\u3000\u3000\u3000\u3000H. SAITO.</p>" + RET + "<p>\u3000\u3000June");
        } else if (n == this.pageNo(23)) {
            object = ((String)object).replace("<p>\u898b\u51fa\u3057\u8a9e", "<h2>\u898b\u51fa\u3057\u8a9e</h2>" + RET + "<p>");
            object = ((String)object).replace("\u767a\u97f3\uff08\u5225\u8868\u300c\u97f3\u6a19\u6587\u5b57\u89e3\u8aac\u300d\u53c2\u7167\uff09</p>", "</p>" + RET + "<h2>\u767a\u97f3\uff08\u5225\u8868\u300c\u97f3\u6a19\u6587\u5b57\u89e3\u8aac\u300d\u53c2\u7167\uff09</h2>");
            object = ((String)object).replace("\u8a9e\u306e\u985e\u5225</p>", "</p>" + RET + "<h2>\u8a9e\u306e\u985e\u5225</h2>");
            object = ((String)object).replace("\u8a9e\u5c3e\u5909\u5316</p>", "</p>" + RET + "<h2>\u8a9e\u5c3e\u5909\u5316</h2>");
            object = ((String)object).replace("\u540d\u8a5e\u306e\u8907\u6570</p>", "</p>" + RET + "<h2>\u540d\u8a5e\u306e\u8907\u6570</h2>");
        }
        if (n == this.pageNo(15) || n == this.pageNo(17)) {
            object = ((String)object).replace("<p>\u3000\u8c4a\u3000\u7530", "<p>\u3000\u3000\u3000\u3000\u3000\u8c4a\u3000\u7530");
        }
        object = ((String)object).replace("\uff08</p>" + RET + "<p>\u3000\uff09", "\uff08\u3000\uff09");
        object = ((String)object).replace("\uff3b</p>" + RET + "<p>\u3000\uff3d", "\uff3b\u3000\uff3d");
        object = ((String)object).replace("</p>" + RET + "<p>\u3000\uff5f", "\u3000\uff5f");
        object = ((String)object).replace("\u901a\u308a\uff0e\uff5f\u5ec3", "\u901a\u308a\uff0e</p>" + RET + "<p>\uff5f\u5ec3");
        if (n == this.pageNo(24)) {
            object = ((String)object).replaceFirst("([^\u0000]+)(<h1>\u97f3\u6a19\u6587\u5b57\u89e3\u8aac</h1>)([^\u0000]+\u8a69\u5b66\u306e\u8853\u8a9e)(\u3067\u3042\u308b\uff0e</p>[^\u0000]+<h1>\u7565\u3000\u8a9e\u3000\u89e3\u3000\u8aac</h1>)([^\u0000]+)", "$4$3$1$2$5");
            object = ((String)object).replaceAll("(\u3010[^\u3011]+\u3011[^\u3010\uff3b]+)", "$1</p>" + RET + "<p>");
            object = ((String)object).replaceAll("(\uff3b[^\uff3da-z]+\uff3d[^\u3010\uff3b]+)", "$1</p>" + RET + "<p>");
            object = ((String)object).replaceAll("<p>\u3000+</p>" + RET, "");
            object = ((String)object).replace("<p>1\uff0e\u3000\u6bcd\u97f3\u306e\u7b26\u53f7i\u02d0 see</p>" + RET + "<p>\uff3bsi\u02d0\uff3d", "<h2>1\uff0e\u3000\u6bcd\u97f3\u306e\u7b26\u53f7</h2>" + RET + "<p>i\u02d0 see\uff3bsi\u02d0\uff3d");
            object = ((String)object).replace("i\u02d0 see\uff3bsi\u02d0\uff3di*, i\u0259 it\uff3bit\uff3d, hear\uff3bhi\u0259\uff3de, ei ten\uff3bten\uff3d, face\uff3bfeis\uff3d\u025b\u0259 chair\uff3bt\u0283\u025b\u0259\uff3d\u00e6 man\uff3bm\u00e6n\uff3d", "i\u02d0 see\uff3bsi\u02d0\uff3d" + PRET + "i*, i\u0259 it\uff3bit\uff3d, hear\uff3bhi\u0259\uff3d" + PRET + "e, ei ten\uff3bten\uff3d, face\uff3bfeis\uff3d" + PRET + "\u025b\u0259 chair\uff3bt\u0283\u025b\u0259\uff3d" + PRET + "\u00e6 man\uff3bm\u00e6n\uff3d");
        } else if (n == this.pageNo(25)) {
            object = ((String)object).replaceAll("([\u03c6\u0153y\u0265\u00e7\u0272x\u02dc])</p>" + RET + "<p>", "</p>" + RET + "<p>$1");
            object = ((String)object).replaceFirst("3\uff0e</p>" + RET + "<p>\u3000\u4e3b\u3068\u3057\u3066\u5916\u6765\u8a9e\u306b\u73fe\u308f\u308b\u308b\u97f3\u306e\u7b26\u53f7</p>([^\u0000]+)(ai, au kite[^\u0000]+bird\uff3bb\u0259\u02d0d\uff3d)2\uff0e</p>" + RET + "<p>\u3000\u5b50\u97f3\u306e\u76ee\u65b0\u3089\u3057\u3044\u7b26\u53f7([^\u0000]+\uff3bd\u0292\u028cst\uff3d)", "$2</p>" + RET + "<h2>2\uff0e\u3000\u5b50\u97f3\u306e\u76ee\u65b0\u3089\u3057\u3044\u7b26\u53f7</h2>" + RET + "<p>$3</p>" + RET + "<h2>3\uff0e\u3000\u4e3b\u3068\u3057\u3066\u5916\u6765\u8a9e\u306b\u73fe\u308f\u308b\u308b\u97f3\u306e\u7b26\u53f7</h2>$1");
            object = ((String)object).replaceAll("\u3000([\uff0a\u2020])\u3000", "</p>" + RET + "<p>\u3000\u3000\u3000$1");
            object = ((String)object).replace("ai, au kite\uff3bkait\uff3d, out\uff3baut\uff3d\u0251: father\uff3bf\u1f71\u02d0\u00f0\u0259\uff3d\u0254, \u0254i long\uff3bl\u0254\u014b\uff3d, boy\uff3bb\u0254i\uff3d\u0254\u02d0\u2020 all\uff3b\u0254\u02d0l\uff3do, ou obey\uff3bob\u00e9i\uff3d, go\uff3bgou\uff3du, u\u0259 book\uff3bbuk\uff3d, sure\uff3b\u0283u\u0259\uff3du\u02d0 rule\uff3bru\u02d0l\uff3d\u028c cut\uff3bk\u028ct\uff3d\u0259 about\uff3b\u0259b\u00e1ut\uff3d", PRET + "ai, au kite\uff3bkait\uff3d, out\uff3baut\uff3d" + PRET + "\u0251: father\uff3bf\u1f71\u02d0\u00f0\u0259\uff3d" + PRET + "\u0254, \u0254i long\uff3bl\u0254\u014b\uff3d, boy\uff3bb\u0254i\uff3d" + PRET + "\u0254\u02d0\u2020 all\uff3b\u0254\u02d0l\uff3d" + PRET + "o, ou obey\uff3bob\u00e9i\uff3d, go\uff3bgou\uff3d" + PRET + "u, u\u0259 book\uff3bbuk\uff3d, sure\uff3b\u0283u\u0259\uff3d" + PRET + "u\u02d0 rule\uff3bru\u02d0l\uff3d" + PRET + "\u028c cut\uff3bk\u028ct\uff3d" + PRET + "\u0259 about\uff3b\u0259b\u00e1ut\uff3d" + PRET);
            object = ((String)object).replace("\u014b sing\uff3bsi\u014b\uff3d\u0275 thick\uff3b\u0275ik\uff3d\u00f0 this\uff3b\u00f0is\uff3d\u0283 fish\uff3bfi\u0283\uff3d\u0292 measure\uff3bm\u00e9\u0292\u0259\uff3dj yet\uff3bjet\uff3dt\u0283 cheese\uff3bt\u0283i\u02d0z\uff3d", "\u014b sing\uff3bsi\u014b\uff3d" + PRET + "\u0275 thick\uff3b\u0275ik\uff3d" + PRET + "\u00f0 this\uff3b\u00f0is\uff3d" + PRET + "\u0283 fish\uff3bfi\u0283\uff3d" + PRET + "\u0292 measure\uff3bm\u00e9\u0292\u0259\uff3d" + PRET + "j yet\uff3bjet\uff3d" + PRET + "t\u0283 cheese\uff3bt\u0283i\u02d0z\uff3d" + PRET);
            object = (String)object + "</p>" + RET;
        }
        System.out.print((String)object);
    }

    public void processPage(PDPage pDPage) throws IOException {
        super.processPage(pDPage);
        int n = this.getCurrentPageNo();
        if (n < this.getStartPage() || this.getEndPage() < n) {
            return;
        }
        System.err.print(n + " ");
        if (this.detectBody) {
            this.loadRight();
            this.outputLeft();
        } else {
            this.outputPre();
        }
        if (DUMP_TP) {
            System.out.println();
            System.out.println();
            for (TextPosition textPosition : this.leftTP) {
                System.out.println(textPosition.getUnicode() + "\t" + textPosition.getFont().getName() + " " + textPosition.getFontSizeInPt());
            }
            System.out.println("***** RIGHT ");
            for (TextPosition textPosition : this.rightTP) {
                System.out.println(textPosition.getUnicode() + "\t" + textPosition.getFont().getName() + " " + textPosition.getFontSizeInPt());
            }
        }
        this.leftTP.clear();
        this.rightTP.clear();
    }

    public void load(int n, int n2, boolean bl) throws Exception {
        if (this.filename == null) {
            return;
        }
        n = this.pageNo(n);
        n2 = this.pageNo(n2);
        System.err.println(this.filename);
        this.leftWidthUnit = bl ? LEFT_WIDTH_UNIT : Float.MAX_VALUE;
        this.detectBody = n >= this.pageNo(27);
        this.inP = false;
        this.inDd = false;
        PDDocument pDDocument = PDDocument.load((File)new File(this.filename));
        if (n == this.pageNo(3)) {
            this.dumpMeta(pDDocument);
        }
        this.setStartPage(n);
        this.setEndPage(n2);
        this.getText(pDDocument);
        pDDocument.close();
        System.err.println();
    }

    public void dumpMeta(PDDocument pDDocument) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            PDDocumentCatalog pDDocumentCatalog = pDDocument.getDocumentCatalog();
            PDMetadata pDMetadata = pDDocumentCatalog.getMetadata();
            if (pDMetadata != null) {
                byte[] byArray = new byte[4096];
                BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)pDMetadata.createInputStream());
                while (bufferedInputStream.read(byArray) > 0) {
                    String string = new String(byArray);
                    Matcher matcher = CREATE_DATE.matcher(string);
                    if (matcher.find()) {
                        stringBuilder.append("<p>\u4f5c\u6210\u65e5\uff1a" + matcher.group(1) + "</p>" + RET);
                    }
                    if (!(matcher = MODIFY_DATE.matcher(string)).find()) continue;
                    stringBuilder.append("<p>\u66f4\u65b0\u65e5\uff1a" + matcher.group(1) + "</p>" + RET);
                }
                bufferedInputStream.close();
            }
            this.metaData = stringBuilder.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ String access$000() {
        return RET;
    }

    static enum CharType {
        PartTitle(16.0, "h1"),
        Dt(8.0, TextStripper.access$000() + "<dt>", "</dt><dd><p>"),
        FutoNuri(6.0, "<b>\u300a", "\u300b</b>"),
        FootnoteNo(4.0, "sup"),
        Furigana(3.0, "sub"),
        BoldEnglish(-1.0, "b"),
        Normal(-1.0),
        Dash(14.0),
        PrePartTile(-1.0, "h1"),
        PreParaTitle(-1.0, "h2");

        final double size;
        final String open;
        final String close;

        private CharType(double d, String string2, String string3) {
            this.size = d;
            this.open = string2;
            this.close = string3;
            size2typeMap.put(d, this);
        }

        private CharType(double d, String string2) {
            this(d, "<" + string2 + ">", "</" + string2 + ">");
        }

        private CharType(double d) {
            this(d, "", "");
        }
    }
}

