/*
 * Decompiled with CFR 0.152.
 */
package zephyr.oxford.oed;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import zephyr.util.ZephyrUtil;

public class MakeLemmaList {
    private final TreeMap<String, Integer> lemmas = new TreeMap(new LemmaComp());
    private static final HashSet<Character> ignoreChars = new HashSet();
    private final TreeSet<Character> irregChars = new TreeSet();
    private int[] count = new int[27];
    private final TreeSet<String> headSet = new TreeSet();

    private static String normalize(String string) {
        int n = string.indexOf(44);
        if (n > 0) {
            string = string.substring(0, n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (ignoreChars.contains(Character.valueOf(c))) continue;
            stringBuilder.append(c);
        }
        return ZephyrUtil.dropMarks(stringBuilder.toString()).toLowerCase().trim();
    }

    private static String headword(String string) {
        String string2;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ',' || c == ' ' || c == '(') {
                if (stringBuilder.length() <= 0) continue;
                break;
            }
            if (ignoreChars.contains(Character.valueOf(c))) continue;
            stringBuilder.append(c);
        }
        if (!(string2 = ZephyrUtil.dropMarks(stringBuilder.toString()).toLowerCase().trim()).matches("^[0-9]+$")) {
            return string2.replaceFirst("[0-9]+$", "");
        }
        return string2;
    }

    private void addLemma(String string) {
        String string2 = MakeLemmaList.normalize(string);
        if (string2.length() == 0) {
            return;
        }
        this.lemmas.put(string, 0);
        char c = string2.charAt(0);
        if ('a' <= c && c <= 'z') {
            int n = c - 97;
            this.count[n] = this.count[n] + 1;
        } else {
            int n = this.count.length - 1;
            this.count[n] = this.count[n] + 1;
        }
        if (string2.length() >= 2) {
            this.headSet.add(string2.substring(0, 2));
        } else {
            this.headSet.add(string2);
        }
        for (int i = 0; i < string2.length(); ++i) {
            c = string2.charAt(i);
            if (c >= 'a' && 'z' >= c || c >= '0' && '9' >= c) continue;
            this.irregChars.add(Character.valueOf(c));
        }
    }

    private void loadFile(File file) throws Exception {
        String string;
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        boolean bl = false;
        int n = 0;
        String string2 = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.equals("======")) {
                bl = false;
                this.lemmas.put(string2, n);
                n = 0;
                continue;
            }
            n += string.length();
            if (bl || string.startsWith("Draft entry ") || string.startsWith("Additions ") || string.isEmpty()) continue;
            this.addLemma(string);
            bl = true;
            string2 = string;
        }
        bufferedReader.close();
    }

    private void loadDir(String string) throws Exception {
        System.err.println("check " + string);
        for (int i = 0; i < 50; ++i) {
            File file = new File(string, "oed-" + i + ".txt");
            if (!file.exists()) continue;
            this.loadFile(file);
        }
    }

    private void output() {
        for (Map.Entry<String, Integer> entry : this.lemmas.entrySet()) {
            String string = entry.getKey();
            int n = entry.getValue();
            System.out.println(string + "\t" + MakeLemmaList.headword(string) + "\t" + n);
            if (n <= 100000) continue;
            System.err.println(string + "\t" + n);
        }
        for (int i = 0; i < 26; ++i) {
            char c = (char)(i + 97);
            System.err.println("count[" + c + "]=" + this.count[i]);
            System.err.print("\t");
            for (char c2 = 'a'; c2 <= 'z'; c2 = (char)(c2 + '\u0001')) {
                if (!this.headSet.contains(Character.toString(c) + c2)) continue;
                System.err.print(c2 + " ");
            }
            System.err.println();
        }
        System.err.println("count[0]=" + this.count[this.count.length - 1]);
        System.err.println("irregular chars : " + this.irregChars.toString());
        System.err.println(this.lemmas.size() + " lemmas");
    }

    public static void main(String[] stringArray) throws Exception {
        MakeLemmaList makeLemmaList = new MakeLemmaList();
        if (stringArray.length == 0) {
            File file = new File("data");
            for (String string : file.list()) {
                makeLemmaList.loadDir("data/" + string);
            }
        } else {
            makeLemmaList.loadDir(stringArray[0]);
        }
        makeLemmaList.output();
    }

    static {
        String string = " !\"#$%&'()'-=^~\\|@`[{]};+:*<>,./?_\u2020\u02cc\u02c8\u2016\u2014\u00b6\u2006\u2013\u2018\u2032\u2019";
        for (int i = 0; i < string.length(); ++i) {
            ignoreChars.add(Character.valueOf(string.charAt(i)));
        }
    }

    static class LemmaComp
    implements Comparator<String> {
        LemmaComp() {
        }

        private String tail(String string) {
            int n = string.indexOf(44);
            if (n > 0) {
                return string.substring(n + 1).trim();
            }
            return null;
        }

        @Override
        public int compare(String string, String string2) {
            String string3;
            String string4 = MakeLemmaList.normalize(string);
            int n = string4.compareTo(string3 = MakeLemmaList.normalize(string2));
            if (n != 0) {
                return n;
            }
            string4 = this.tail(string);
            string3 = this.tail(string2);
            if (string4 != null && string3 != null) {
                return string4.compareTo(string3);
            }
            return string.compareTo(string2);
        }
    }
}

