/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.encol;

public class Util {
    static String SENTENCE_HEAD = "- ";

    static String dropHeadMark(String string) {
        char c = string.charAt(0);
        if (c == '\u25c6' || c == '\u00b7') {
            return string.substring(1);
        }
        return string;
    }

    private static String splitSentence(String string, boolean bl) {
        char c = string.charAt(0);
        if (c == '\u25c6' || c == '\u00b7') {
            string = string.substring(1);
        }
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c < '\u0100' || c == '\u201c' || c == '\u201d') continue;
            if (bl) {
                return string.substring(0, i).trim();
            }
            return string.substring(i).trim();
        }
        return string;
    }

    private static String dropTags(String string) {
        string = string.replaceAll("\\(<su[pb]>[^<>]+</su[pb]>\\)", "");
        string = string.replaceAll("</?[a-z]+>", "");
        return string;
    }

    static String getEnglish(String string) {
        String string2 = Util.splitSentence(string, true);
        string2 = Util.dropTags(string2);
        return string2;
    }

    static String getJapanese(String string) {
        String string2 = Util.splitSentence(string, false);
        string2 = Util.dropTags(string2);
        string2 = string2.replaceAll("\\[([^\\[\\]]+)\\]", " $1 ");
        string2 = string2.replaceAll("[\\(\\)]", " ");
        string2 = string2.replace(',', '\u3001');
        string2 = string2.replace('.', '\u3002');
        return string2;
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(Util.getJapanese("\u25c6after a <i>youth</i> <b>of</b> dissipation \u653e\u8569\u4e09\u6627(<sub>\u3056\u3093\u307e\u3044</sub>)\u306e\u9752\u5e74\u671f\u3092\u904e\u304e\u3066"));
    }
}

