/*
 * Decompiled with CFR 0.152.
 */
package zephyr.hachette.bailly.abr;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import zephyr.util.BIMUtil;
import zephyr.util.BMPCleaner;

public class MakePages {
    private final int DPI = 300;
    private final int BAR_WIDTH_DOT = BIMUtil.mm2dot(0.2, 300);
    private final int ONE_MM_DOT = BIMUtil.mm2dot(1.0, 300);
    private final int HALF_BAR_CHECK_DOT = BIMUtil.mm2dot(10.0, 300);
    private final int PART_WIDTH_DOT = BIMUtil.mm2dot(63.0, 300);
    private final BMPCleaner cleaner = new BMPCleaner(300, 10, this.ONE_MM_DOT, 5);

    private void save(BufferedImage bufferedImage, int n, int n2, File file, boolean bl) throws Exception {
        n = Integer.max(0, n);
        n2 = Integer.min(n2, bufferedImage.getWidth() - n);
        BufferedImage bufferedImage2 = bufferedImage.getSubimage(n, 8 * this.ONE_MM_DOT, n2, bufferedImage.getHeight() - 16 * this.ONE_MM_DOT);
        bufferedImage2 = this.cleaner.cleanup(bufferedImage2);
        bufferedImage2 = BIMUtil.trim(bufferedImage2, 1);
        ImageIO.write((RenderedImage)bufferedImage2, "bmp", file);
    }

    private void convert(File file, int n, File file2) throws Exception {
        BufferedImage bufferedImage = ImageIO.read(file);
        int n2 = bufferedImage.getWidth();
        int n3 = n2 / 2 - this.HALF_BAR_CHECK_DOT;
        int n4 = n2 / 2 + this.HALF_BAR_CHECK_DOT;
        int n5 = 0;
        int n6 = 0;
        for (int i = n3; i < n4; ++i) {
            int n7 = BIMUtil.vlineLen(bufferedImage, i);
            if (n7 <= n5) continue;
            n5 = n7;
            n6 = i;
        }
        this.save(bufferedImage, n6 - this.PART_WIDTH_DOT - this.BAR_WIDTH_DOT, this.PART_WIDTH_DOT, new File(file2, Integer.toString(n) + "a.bmp"), false);
        this.save(bufferedImage, n6 + this.BAR_WIDTH_DOT, this.PART_WIDTH_DOT, new File(file2, Integer.toString(n) + "b.bmp"), true);
    }

    private void parse(String string, String string2) throws Exception {
        File file = new File(string2);
        file.mkdirs();
        for (int i = 1; i <= 983; ++i) {
            File file2 = new File(string, String.format("%04d.bmp", i));
            try {
                this.convert(file2, i, file);
                continue;
            }
            catch (Exception exception) {
                System.err.println(file2.getAbsolutePath());
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray.length > 0 ? stringArray[0] : "bmp1";
        String string2 = stringArray.length > 1 ? stringArray[1] : "bmp";
        MakePages makePages = new MakePages();
        makePages.parse(string, string2);
    }
}

