/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.royalfrjp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.obunsha.royalfrjp.MakeBodyHtml;
import zephyr.util.ZephyrUtil;

public class MakeConjuHtml {
    private static final String MIDASI_REGEXP = "<p class=\"midasi\">(.+?)\uff1a(.+?)</p>";
    private static final String TITLE_REGEXP = "<td class=\"title\">(.+?)</td>";
    private static final String TD_REGEXP = "<td>(.*?)(<br>)?</td>";
    private static final Pattern MIDASI = Pattern.compile("<p class=\"midasi\">(.+?)\uff1a(.+?)</p>");
    private static final Pattern TITLE = Pattern.compile("<td class=\"title\">(.+?)</td>");
    private static final Pattern TD = Pattern.compile("<td>(.*?)(<br>)?</td>");
    private int nLoaded = 0;

    private void loadOneConjuFile(File file) throws Exception {
        String string;
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        String string2 = "";
        String string3 = file.getName().replace(".htm", "").toUpperCase();
        LinkedList<String> linkedList = new LinkedList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            Matcher matcher = MIDASI.matcher(string);
            if (matcher.find()) {
                if (!string2.equals(matcher.group(1))) {
                    if (!string2.isEmpty()) {
                        System.out.println("</dd>");
                    }
                    System.out.print("<dt id=\"" + string3 + "\">" + matcher.group(1) + " #</dt><dd>");
                    string2 = matcher.group(1);
                }
                System.out.print("<indent val=\"1\"><p><b>== ");
                System.out.print(matcher.group(2));
                System.out.println(" ==</b></p>");
                if (linkedList.size() == 0) continue;
                System.err.println("ERROR: titles.size() = " + linkedList.size());
                System.err.println(string);
                System.exit(1);
                continue;
            }
            matcher = TITLE.matcher(string);
            if (matcher.find()) {
                linkedList.add(matcher.group(1));
                continue;
            }
            matcher = TD.matcher(string);
            if (!matcher.find()) continue;
            String string4 = (String)linkedList.poll();
            System.out.print("<indent val=\"1\"><p>-- ");
            System.out.print(string4);
            System.out.print(" --</p><indent val=\"2\"><p>");
            String string5 = matcher.group(1);
            string5 = string5.length() > 0 ? string5.replace("<br>", " / ") : "---";
            System.out.print(string5);
            System.out.println("</p>");
        }
        System.out.println("</dd>");
        bufferedReader.close();
        ((InputStream)fileInputStream).close();
    }

    private void loadConjuFiles(String string, File file) throws Exception {
        Object[] objectArray = file.list();
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            File file2 = new File(file.getAbsolutePath(), (String)object);
            this.loadOneConjuFile(file2);
            ++this.nLoaded;
            if (this.nLoaded % 100 != 0) continue;
            System.err.print(".");
        }
    }

    private void loadConjuFiles(String string) throws Exception {
        File file = new File(string);
        MakeBodyHtml.checkDirectory(file);
        String string2 = file.getName();
        System.out.println("<html><body>");
        if (file.isDirectory()) {
            if (string2.length() == 1) {
                this.loadConjuFiles(string2, file);
            } else {
                for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                    System.err.print(c);
                    file = new File(string, Character.toString(c));
                    string2 = file.getName();
                    this.loadConjuFiles(string2, file);
                }
            }
        }
        System.out.println("</body></html>");
        System.err.println();
        System.err.println("done. " + this.nLoaded + " entries");
    }

    public static void main(String[] stringArray) {
        ZephyrUtil.setShiftJisOuput();
        MakeConjuHtml makeConjuHtml = new MakeConjuHtml();
        if (stringArray.length > 0) {
            try {
                makeConjuHtml.loadConjuFiles(stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("Usage: java MakeConjuHtml <SOME_DIR>/royal/contents/fr/conju{/[a-z]}");
        }
    }
}

