/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import zephyr.util.MultiTreeMap;

public class Counter<E> {
    private final HashMap<E, Integer> map = new HashMap();

    public void add(E e) {
        Integer n = this.map.get(e);
        if (n != null) {
            this.map.put(e, n + 1);
        } else {
            this.map.put(e, 1);
        }
    }

    public HashMap<E, Integer> map() {
        return this.map;
    }

    public MultiTreeMap<Integer, E> sort() {
        MultiTreeMap<Integer, E> multiTreeMap = new MultiTreeMap<Integer, E>(new ReverseComp());
        for (Map.Entry<E, Integer> entry : this.map.entrySet()) {
            multiTreeMap.put(entry.getValue(), entry.getKey());
        }
        return multiTreeMap;
    }

    public void dump() {
        this.dump(this.map.size() / 100);
    }

    public void dump(int n) {
        Integer n2;
        MultiTreeMap<Integer, E> multiTreeMap = this.sort();
        int n3 = multiTreeMap.isEmpty() ? 0 : (Integer)multiTreeMap.keySet().iterator().next();
        System.err.println("tags: max=" + n3 + ", size=" + this.map.size());
        Iterator iterator = multiTreeMap.keySet().iterator();
        while (iterator.hasNext() && (n2 = (Integer)iterator.next()) >= n) {
            System.err.print(n2 + "=" + multiTreeMap.getList(n2) + ", ");
        }
        System.err.println();
    }

    private static class ReverseComp
    implements Comparator<Integer> {
        private ReverseComp() {
        }

        @Override
        public int compare(Integer n, Integer n2) {
            return n2 - n;
        }
    }
}

