/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.royalfrjp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.obunsha.royalfrjp.MakeBodyHtml;
import zephyr.util.ZephyrUtil;

public class MakeMorphHtml {
    private static final String CONJU_REGEXP = "<td onClick=\"open_detail\\('([^']+)'.*?title=\"(.+?)\"><a[^>]+>(.+?)</a><span class=\"base_mida\">&rArr;([^<]+)</span>";
    private static final Pattern CONJU = Pattern.compile("<td onClick=\"open_detail\\('([^']+)'.*?title=\"(.+?)\"><a[^>]+>(.+?)</a><span class=\"base_mida\">&rArr;([^<]+)</span>");
    private int nMorph = 0;
    private int nLoaded = 0;

    private void loadOneMorphFile(File file) throws Exception {
        String string;
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        while ((string = bufferedReader.readLine()) != null) {
            Matcher matcher = CONJU.matcher(string);
            if (!matcher.find()) continue;
            System.out.println(String.format("<dt>%s</dt><dd><a href=\"items.html#%s\">\u21d2%s</a> %s</dd>", matcher.group(3), matcher.group(1), matcher.group(4), matcher.group(2).replace("\uff0f", " / ")));
            ++this.nMorph;
            if (this.nMorph % 10000 != 0) continue;
            System.err.print(".");
        }
        bufferedReader.close();
        ((InputStream)fileInputStream).close();
    }

    private void loadMorphFiles(String string, File file) throws Exception {
        int n = 1;
        while (true) {
            String string2 = String.format("i%s%03d.htm", string, n);
            File file2 = new File(file.getAbsolutePath(), string2);
            if (!file2.isFile()) break;
            this.loadOneMorphFile(file2);
            ++this.nLoaded;
            ++n;
        }
    }

    private void loadMorphFiles(String string) throws Exception {
        File file = new File(string);
        MakeBodyHtml.checkDirectory(file);
        String string2 = file.getName();
        System.out.println("<html><body>");
        if (file.isDirectory()) {
            if (string2.length() == 1) {
                this.loadMorphFiles(string2, file);
            } else {
                for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                    System.err.print(c);
                    file = new File(string, Character.toString(c));
                    string2 = file.getName();
                    this.loadMorphFiles(string2, file);
                }
            }
        }
        System.out.println("</body></html>");
        System.err.println();
        System.err.println("done. " + this.nLoaded + " files, " + this.nMorph + " conjugate entries");
    }

    public static void main(String[] stringArray) {
        ZephyrUtil.setShiftJisOuput();
        MakeMorphHtml makeMorphHtml = new MakeMorphHtml();
        if (stringArray.length > 0) {
            try {
                makeMorphHtml.loadMorphFiles(stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("Usage: java MakeMorphHtml <SOME_DIR>/royal/contents/fr/index/conju{/[a-z]}");
        }
    }
}

