/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.royalfrjp;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.AppendJPKeys;
import zephyr.util.AppendLatinKeys;
import zephyr.util.ZephyrUtil;

public class SedBodyHtml {
    private static final String[][] REPLACES = new String[][]{{"&lt;", "<"}, {"&gt;", ">"}, {"&amp;amp;", "&"}, {"&amp;", "&"}, {"<b>\uff3b\u7528\u4f8b\uff3d</b>", "\uff3b\u7528\u4f8b\uff3d"}, {"((", "\u300a"}, {"))", "\u300b"}, {"&hellip;", "..."}, {"&rarr;", "\u2192"}, {"&larr;", "\u2190"}, {"&hArr;", "\u21d4"}, {"&rArr;", "\u21d2"}, {"&dagger;", "\u2020"}, {"&minus;", "-"}, {"&mdash;", "\u2015"}, {"\u2103&deg;C", "\u2103"}, {"&radic;", "\u221a"}};
    private static final String[][] REG_REPLACES = new String[][]{{"(<dt[^>]+>)(.+?)</dt><dd><p> *\\2 *", "$1$2</dt><dd><p>"}, {"<p> +", "<p>"}, {" +</p>", "</p>"}};
    private static final String JUMP_REGEXP = "<jump onClick=\"(.+?)\">(.+?)</jump>";
    private static final Pattern JUMP = Pattern.compile("<jump onClick=\"(.+?)\">(.+?)</jump>");
    private static final String WORDJUMP_REGEXP = "jump\\('([^']+)','[^']*'\\)";
    private static final Pattern WORDJUMP = Pattern.compile("jump\\('([^']+)','[^']*'\\)");
    private static final String PDFJUMP_REGEXP = "openNewWin\\('[\\./]+/([^/]+/(.+?)\\.pdf)','(.+?)'\\)";
    private static final Pattern PDFJUMP = Pattern.compile("openNewWin\\('[\\./]+/([^/]+/(.+?)\\.pdf)','(.+?)'\\)");
    private static final String YAKUGO_REGEXP = "<yakugo>(.+?)</yakugo>";
    private static final Pattern YAKUGO = Pattern.compile("<yakugo>(.+?)</yakugo>");
    private static final AppendLatinKeys LATKEY = new AppendLatinKeys();
    private static int nJPKey = 0;
    private static final String DT_DD_REGEXP = "<dt[^>]+>(.+?)</dt>(.*)";
    private static final Pattern DT_DD = Pattern.compile("<dt[^>]+>(.+?)</dt>(.*)");

    /*
     * Enabled aggressive block sorting
     */
    private static String fixJump(String string, boolean bl) {
        Matcher matcher = JUMP.matcher(string);
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (matcher.find()) {
            Matcher matcher2;
            if (n < matcher.start()) {
                stringBuffer.append(string.substring(n, matcher.start()));
            }
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            if (string2.startsWith("jump")) {
                matcher2 = WORDJUMP.matcher(string2);
                if (matcher2.find()) {
                    stringBuffer.append("<a href=\"#");
                    stringBuffer.append(matcher2.group(1));
                    stringBuffer.append("\">");
                    stringBuffer.append(string3);
                    stringBuffer.append("</a>");
                } else {
                    System.err.println("INVALID JUMP1: " + string2);
                }
            } else {
                matcher2 = PDFJUMP.matcher(string2);
                if (matcher2.find()) {
                    String string4 = matcher2.group(1);
                    String string5 = matcher2.group(2);
                    String string6 = matcher2.group(3);
                    if (bl && string6.equals("ZUHAN")) {
                        stringBuffer.append("\u3010");
                        stringBuffer.append(string3);
                        stringBuffer.append("\u3011");
                        stringBuffer2.append("<p><img src=\"");
                        stringBuffer2.append(string5);
                        stringBuffer2.append(".jpg\"/></p>");
                    } else {
                        stringBuffer.append(string3);
                        stringBuffer.append(" \u3010file:");
                        stringBuffer.append(string4);
                        stringBuffer.append("\u3011");
                    }
                }
            }
            n = matcher.end();
        }
        if (n >= string.length()) return stringBuffer.toString();
        if (stringBuffer2.length() <= 0) {
            stringBuffer.append(string.substring(n));
            return stringBuffer.toString();
        }
        int n2 = string.lastIndexOf("</dd>");
        if (n2 > 0) {
            stringBuffer.append(string.substring(n, n2));
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("</dd>");
            return stringBuffer.toString();
        }
        System.err.println("INVALID LINE without </dd>");
        return string;
    }

    private static String makeJPKeys(String string, String string2, String string3) {
        Matcher matcher;
        Matcher matcher2 = YAKUGO.matcher(string2);
        TreeSet<String> treeSet = new TreeSet<String>();
        while (matcher2.find()) {
            matcher = AppendJPKeys.JPWORD.matcher(matcher2.group(1));
            while (matcher.find()) {
                treeSet.add(matcher.group(2));
            }
        }
        if (!treeSet.isEmpty()) {
            nJPKey += treeSet.size();
            matcher = AppendJPKeys.JPWORD.matcher(string);
            String string4 = matcher.find() ? ZephyrUtil.makeKey(matcher.group(2)) : null;
            return LATKEY.makeKeys(string, string4, string3, treeSet);
        }
        return "";
    }

    private static String appendJPKeys(String string, String string2) {
        Matcher matcher = DT_DD.matcher(string);
        if (!matcher.find()) {
            return string;
        }
        String string3 = matcher.group(1);
        String string4 = matcher.group(2);
        String string5 = SedBodyHtml.makeJPKeys(string3, string4, string2);
        string4 = string4.replace("<yakugo>", "").replace("</yakugo>", "");
        return string.substring(0, matcher.start(2)) + string5 + string4;
    }

    private static String sed(String string, boolean bl) {
        string = ZephyrUtil.sed(string, REPLACES, REG_REPLACES);
        string = SedBodyHtml.fixJump(string, bl);
        return string;
    }

    private static void sed(String[] stringArray) throws Exception {
        String string;
        InputStream inputStream = System.in;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        boolean bl = false;
        String string2 = "\u8868\u8a18";
        for (String string3 : stringArray) {
            if (string3.equals("WithZuhan")) {
                bl = true;
                continue;
            }
            string2 = AppendLatinKeys.getKeyType(string3);
        }
        while ((string = bufferedReader.readLine()) != null) {
            string = SedBodyHtml.sed(string, bl);
            string = SedBodyHtml.appendJPKeys(string, string2);
            System.out.println(string);
        }
        if (nJPKey > 0) {
            System.err.println("append " + nJPKey + " extra Japanese " + string2 + " keys");
        }
    }

    public static void main(String[] stringArray) {
        try {
            ZephyrUtil.setUTF8Ouput();
            SedBodyHtml.sed(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

