/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusha.readers3;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.kenkyusha.readers3.R3Gaiji;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    private static final HashMap<Character, Character> zenhanMap = new HashMap();
    private static final TreeSet<Character> unknownHanSet = new TreeSet();
    private final R3Gaiji gaiji;
    private static final String RET;
    private static final HashMap<String, String> eb2htmlMap;
    private static final String EP_DT_START = "<1F09><0001><1F41><0160>";
    private static final String EP_ANKER = "<1F09><9999>";
    private static final int EPTAG_LEN;
    private final LinkedList<String> closeTags = new LinkedList();
    private String dtId = "";
    private final HashSet<String> posSet = new HashSet();
    public static final String IDIOM_EN = "<idiom/>";
    public static final String IDIOM_JP = "<idiomjp/>";
    private static final Pattern EP_REF;
    private static final Pattern SUBSECTION;
    private static final String DD_START = "<dd>";
    private static final Pattern SMCE_S;

    MakeBodyHtml() throws Exception {
        this.gaiji = new R3Gaiji("GaijiMap.xml");
    }

    private static char zen2han(char c) {
        if ('\uff10' <= c && c <= '\uff19') {
            return (char)(48 + (c - 65296));
        }
        if ('\uff21' <= c && c <= '\uff3a') {
            return (char)(65 + (c - 65313));
        }
        if ('\uff41' <= c && c <= '\uff5a') {
            return (char)(97 + (c - 65345));
        }
        if (c <= '~') {
            return c;
        }
        Character c2 = zenhanMap.get(Character.valueOf(c));
        if (c2 != null) {
            return c2.charValue();
        }
        unknownHanSet.add(Character.valueOf(c));
        return '#';
    }

    private String ep2html(String string, HashSet<String> hashSet) {
        String string2;
        String string3;
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        int n = string.indexOf(93);
        String[] stringArray = string.substring(1, n).replace(" ", "0").split(":");
        if (stringArray[1].equals("800")) {
            stringArray[0] = String.format("%X", Integer.parseInt(stringArray[0], 16) + 1);
            stringArray[1] = "000";
        }
        if (!(bl = hashSet.contains(string3 = stringArray[0] + stringArray[1])) && string.substring(++n).startsWith(EP_ANKER)) {
            return "";
        }
        boolean bl3 = false;
        if (bl) {
            string2 = "</p>" + RET + "<p id=\"" + string3 + "\">";
            this.posSet.add(string3);
        } else {
            string2 = "</p>" + RET + "<p>";
        }
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                String string4;
                switch (string4 = string.substring(n + 1, n + 5)) {
                    case "1FE0": {
                        String string5;
                        switch (string5 = string.substring(n + 7, n + 11)) {
                            case "0001": {
                                stringBuilder.append("<i>");
                                this.closeTags.addFirst("</i>");
                                break;
                            }
                            case "0000": 
                            case "0003": {
                                if (bl3) break;
                                stringBuilder.append("<b>");
                                this.closeTags.addFirst("</b>");
                            }
                        }
                        n += 2 * EPTAG_LEN;
                        break;
                    }
                    case "1F09": {
                        String string5;
                        String string6 = string.substring(n);
                        if (string6.startsWith(EP_DT_START)) {
                            if (!this.closeTags.isEmpty()) {
                                System.err.println("missing closeTags before " + string3);
                            }
                            if (bl) {
                                stringBuilder.append("<dt id=\"" + string3 + "\">");
                                bl = false;
                            } else {
                                stringBuilder.append("<dt>");
                            }
                            this.dtId = string3;
                            bl3 = true;
                            n += EP_DT_START.length();
                            break;
                        }
                        switch (string5 = string.substring(n + 7, n + 11)) {
                            case "0002": {
                                break;
                            }
                            case "0003": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0004": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0005": {
                                stringBuilder.append(string2 + "\u3000");
                                break;
                            }
                            case "0020": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0030": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0103": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0101": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0104": {
                                stringBuilder.append(string2);
                                break;
                            }
                            case "0008": 
                            case "0028": 
                            case "0038": {
                                stringBuilder.append(string2 + "\u3000- ");
                                break;
                            }
                            case "0009": 
                            case "0029": 
                            case "0039": {
                                stringBuilder.append("\u3000");
                                break;
                            }
                            case "0106": {
                                stringBuilder.append(string2 + IDIOM_EN);
                                break;
                            }
                            case "0107": {
                                stringBuilder.append(string2 + IDIOM_JP + "\u3000");
                                break;
                            }
                            case "0010": 
                            case "0013": 
                            case "0014": 
                            case "0015": 
                            case "0018": 
                            case "0019": 
                            case "0023": 
                            case "0024": 
                            case "0025": 
                            case "0033": 
                            case "0034": 
                            case "0035": 
                            case "0040": 
                            case "0100": 
                            case "0105": 
                            case "0109": 
                            case "0113": 
                            case "0115": 
                            case "0117": 
                            case "0119": 
                            case "0120": 
                            case "0127": 
                            case "0129": 
                            case "9999": {
                                break;
                            }
                            default: {
                                System.err.println("Unknown 1F09 " + string5);
                            }
                        }
                        n += 2 * EPTAG_LEN;
                        break;
                    }
                    case "1F61": {
                        if (bl3) {
                            stringBuilder.append("</dt><dd><p>");
                            bl3 = false;
                        }
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F04": {
                        bl2 = false;
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F05": {
                        bl2 = true;
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1FE1": {
                        for (String string7 : this.closeTags) {
                            stringBuilder.append(string7);
                        }
                        this.closeTags.clear();
                        n += EPTAG_LEN;
                        break;
                    }
                    case "1F4A": {
                        stringBuilder.append("\u3000\u97f3\u58f0");
                        n += 3 * EPTAG_LEN;
                        n = string.indexOf(93, n);
                        n = string.indexOf(93, n + 1) + 1;
                        break;
                    }
                    default: {
                        if (string4.compareTo("A121") >= 0 && string4.compareTo("FE7E") <= 0) {
                            stringBuilder.append(this.gaiji.gaiji(string4));
                        } else {
                            String string8 = eb2htmlMap.get(string4);
                            if (string8 != null) {
                                stringBuilder.append(string8);
                            }
                        }
                        n += EPTAG_LEN;
                        break;
                    }
                }
                continue;
            }
            if (bl2) {
                stringBuilder.append(c);
            } else {
                stringBuilder.append(MakeBodyHtml.zen2han(c));
            }
            ++n;
        }
        String string9 = stringBuilder.toString();
        if (bl3) {
            string9 = string9 + "</dt><dd><p>";
        }
        return string9;
    }

    private HashSet<String> findRefs(String string) throws Exception {
        String string2;
        HashSet<String> hashSet = new HashSet<String>();
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        bufferedReader.readLine();
        bufferedReader.readLine();
        while ((string2 = bufferedReader.readLine()) != null) {
            Matcher matcher = EP_REF.matcher(string2);
            while (matcher.find()) {
                hashSet.add(matcher.group(1) + matcher.group(2));
            }
        }
        bufferedReader.close();
        System.err.println("found " + hashSet.size() + " unique refs");
        return hashSet;
    }

    private String fixSMCES(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        Matcher matcher = SMCE_S.matcher(string);
        while (matcher.find()) {
            if (n < matcher.start()) {
                stringBuilder.append(string.substring(n, matcher.start()));
            }
            stringBuilder.append(matcher.group(1).toUpperCase());
            n = matcher.end();
        }
        if (n < string.length()) {
            stringBuilder.append(string.substring(n));
        }
        return stringBuilder.toString();
    }

    private String normalize(String string) {
        string = string.replaceAll("(<p[^>]*>)[\u3000 ]*(\\(<b>[0-9]+</b>\\))", "$1\u3000$2");
        string = string.replace("\u25ba", "</p><p>\u25ba");
        string = string.replaceAll("([^ \u3000])\u25c6", "$1\u3000\u25c6");
        string = string.replaceAll("(<p[^>]*>\u3000*<i>[a-z]+</i>(, *<i>[a-z]+</i>)*) *", "$1\u3000");
        string = this.fixSMCES(string);
        string = string.replaceAll("\\{a\\}([^\\{\\}]+?)\\{/a\\}\\[0*([0-9A-F]+):0([0-9A-F]+)\\]", "<a href=\"#$2$3\">$1</a>");
        string = string.replaceAll("[\u3000 ]+</p>", "</p>");
        if ((string = string.replaceAll("<p[^>]*></p>", "")).length() > 1000) {
            Matcher matcher = SUBSECTION.matcher(string);
            StringBuilder stringBuilder = null;
            StringBuilder stringBuilder2 = null;
            int n = 0;
            int n2 = 0;
            while (matcher.find()) {
                if (stringBuilder2 == null) {
                    stringBuilder = new StringBuilder();
                    stringBuilder2 = new StringBuilder();
                }
                if (n < matcher.start()) {
                    stringBuilder.append(string.substring(n, matcher.start()));
                }
                String string2 = this.dtId + "." + ++n2;
                stringBuilder.append("<p id=\"");
                stringBuilder.append(string2);
                stringBuilder.append("\">");
                stringBuilder.append(matcher.group(1));
                if (n2 >= 2) {
                    stringBuilder2.append("\u3000");
                }
                stringBuilder2.append("\u2192<a href=\"#");
                stringBuilder2.append(string2);
                stringBuilder2.append("\">");
                stringBuilder2.append(matcher.group(2));
                stringBuilder2.append("</a>");
                n = matcher.end();
            }
            if (stringBuilder != null && n2 >= 2) {
                if (n < string.length()) {
                    stringBuilder.append(string.substring(n));
                }
                string = stringBuilder.toString();
                n = string.indexOf(DD_START) + DD_START.length();
                string = string.substring(0, n) + "<p>" + stringBuilder2.toString().trim() + "</p>" + RET + string.substring(n).trim();
            }
        }
        return string;
    }

    private void parse(String string) throws Exception {
        Object object;
        String string2;
        HashSet<String> hashSet = this.findRefs(string);
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        bufferedReader.readLine();
        bufferedReader.readLine();
        StringBuilder stringBuilder = null;
        System.out.println("<html><body>");
        while ((string2 = bufferedReader.readLine()) != null) {
            if ((string2 = string2.trim()).isEmpty() || ((String)(object = this.ep2html(string2, hashSet))).isEmpty()) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            } else if (((String)object).startsWith("<dt") && stringBuilder != null) {
                System.out.println(this.normalize(stringBuilder.toString()) + "</p></dd>");
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append((String)object);
        }
        bufferedReader.close();
        if (stringBuilder != null) {
            System.out.println(this.normalize(stringBuilder.toString()) + "</p></dd>");
        }
        System.out.println("</body></html>");
        if (!unknownHanSet.isEmpty()) {
            System.err.println("WARN: Unknown Hankaku characters");
            System.err.println(unknownHanSet.toString());
        }
        object = new TreeSet();
        for (String string3 : hashSet) {
            if (this.posSet.contains(string3)) continue;
            ((TreeSet)object).add(string3);
        }
        if (!((TreeSet)object).isEmpty()) {
            System.err.println("WARN: Unknown Pos: " + ((TreeSet)object).size());
            System.err.println(((AbstractCollection)object).toString());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            ZephyrUtil.setUTF8Ouput();
            MakeBodyHtml makeBodyHtml = new MakeBodyHtml();
            try {
                makeBodyHtml.parse(stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("Usage: java MakeBodyHtml SOME_DIR/readers3.txt");
        }
    }

    static {
        zenhanMap.put(Character.valueOf('\uff0e'), Character.valueOf('.'));
        zenhanMap.put(Character.valueOf('\uff0c'), Character.valueOf(','));
        zenhanMap.put(Character.valueOf('\u3000'), Character.valueOf(' '));
        zenhanMap.put(Character.valueOf('\uff08'), Character.valueOf('('));
        zenhanMap.put(Character.valueOf('\uff09'), Character.valueOf(')'));
        zenhanMap.put(Character.valueOf('\uff3b'), Character.valueOf('['));
        zenhanMap.put(Character.valueOf('\uff3d'), Character.valueOf(']'));
        zenhanMap.put(Character.valueOf('\uff01'), Character.valueOf('!'));
        zenhanMap.put(Character.valueOf('\uff1f'), Character.valueOf('?'));
        zenhanMap.put(Character.valueOf('\uff0b'), Character.valueOf('+'));
        zenhanMap.put(Character.valueOf('\uff0d'), Character.valueOf('-'));
        zenhanMap.put(Character.valueOf('\uff0a'), Character.valueOf('*'));
        zenhanMap.put(Character.valueOf('\uff0f'), Character.valueOf('/'));
        zenhanMap.put(Character.valueOf('\u2019'), Character.valueOf('\''));
        zenhanMap.put(Character.valueOf('\uff1a'), Character.valueOf(':'));
        zenhanMap.put(Character.valueOf('\uff1b'), Character.valueOf(';'));
        zenhanMap.put(Character.valueOf('\uff06'), Character.valueOf('&'));
        zenhanMap.put(Character.valueOf('\uff3e'), Character.valueOf('^'));
        zenhanMap.put(Character.valueOf('\uff5c'), Character.valueOf('|'));
        zenhanMap.put(Character.valueOf('\uff1d'), Character.valueOf('='));
        zenhanMap.put(Character.valueOf('\u30fb'), Character.valueOf('\u00b7'));
        String string = "\u30fc\u300a\u300b\u2015\u3008\u3009\u25c6\u00b0\u21d2\u00b4\uff40\u2032\u2033\uffe0\u2026\u4e00\uff1c\uff1e\u00a7\u00a8\u00d7\u2191\u2193\u300c\u300d\uff5e\u2018\uffe3]";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            zenhanMap.put(Character.valueOf(c), Character.valueOf(c));
        }
        RET = System.getProperty("line.separator");
        eb2htmlMap = new HashMap();
        eb2htmlMap.put("1F42", "{a}");
        eb2htmlMap.put("1F62", "{/a}");
        eb2htmlMap.put("1F06", "<sub>");
        eb2htmlMap.put("1F07", "</sub>");
        eb2htmlMap.put("1F0E", "<sup>");
        eb2htmlMap.put("1F0F", "</sup>");
        EPTAG_LEN = "<xxxx>".length();
        EP_REF = Pattern.compile("<1F62>\\[0*([0-9A-F]+):0([0-9A-F]+)\\]");
        SUBSECTION = Pattern.compile("<p>[\u3000 ]*(\u25ba(<i>[^<]+?</i>(, <i>[^<]+?</i>)*))");
        SMCE_S = Pattern.compile("\uff33\uff2d\uff23\uff1a\uff25([^\\[\\]]+?)\uff33\uff2d\uff23\uff1a\uff33");
    }
}

