/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.royalfrjp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.ZephyrUtil;

public class MakeBodyHtml {
    private static final HashMap<Character, String> hatuonMap = new HashMap();
    private static final String HATUON_START = "<span class=\"hatuon\">";
    private static final String SPAN_START = "<span ";
    private static final String SPAN_END = "</span>";
    private static final String HATUON_END = "</span>";
    private static final String PHONETIC_START = "<span class=\"phonetic_inLine\">";
    private static final String PHONETIC_END = "</span>";
    private static final HashMap<Character, String> gaijiMap;
    private static final String GAIJI_REGEXP = "<span class=\"gaiji\">(.+?)</span>";
    private static final Pattern GAIJI;
    private static final String CONJU_REGEXP = "onClick=\"openVerbTable\\('([^']+)'\\)\">";
    private static final Pattern CONJU;
    private static final String MIDASI_REGEXP = "<body onLoad=\"init\\('([^']+)'\\)\">.*?<span class=\"midasi\">(.*?)</span>";
    private static final Pattern MIDASI;
    private static Pattern HTM;
    private int nLoaded = 0;

    private String fixItem(String string) {
        String[][] stringArrayArray = new String[][]{{"<hr>", "<hr/>"}, {"<a name=\"info1\">&nbsp;</a><span id=\"arrow_info1\" class=\"arrow\"  onClick=\"Display_block('info1')\">\u25bc</span></a>", "<a name=\"info1\">&nbsp;<span id=\"arrow_info1\" class=\"arrow\"  onClick=\"Display_block('info1')\">\u25bc</span></a>"}, {"<a name=\"yougo1\">&nbsp;</a><span id=\"arrow_yougo1\" class=\"arrow\"  onClick=\"Display_block('yougo1')\">\u25bc</span></a>", "<a name=\"yougo1\">&nbsp;<span id=\"arrow_yougo1\" class=\"arrow\"  onClick=\"Display_block('yougo1')\">\u25bc</span></a>"}, {"<a name=\"inyou1\">&nbsp;</a><span id=\"arrow_inyou1\" class=\"arrow\"  onClick=\"Display_block('inyou1')\">\u25bc</span></a>", "<a name=\"inyou1\">&nbsp;<span id=\"arrow_inyou1\" class=\"arrow\"  onClick=\"Display_block('inyou1')\">\u25bc</span></a>"}, {"<span class=\"gogen\">(<\u30ae\u30ea\u30b7\u30a2\u306e\u5730\u65b9Attique)</span>", "<span class=\"gogen\">(\uff1c\u30ae\u30ea\u30b7\u30a2\u306e\u5730\u65b9Attique)</span>"}, {"\uff1ca name=\"yourei_1\">", "<a name=\"yourei_1\">"}, {"<a name=\"kanren1\">&nbsp;</a><span id=\"arrow_kanren1\" class=\"arrow\"  onClick=\"Display_block('kanren1')\">\u25bc</span></a>", "<a name=\"kanren1\">&nbsp;<span id=\"arrow_kanren1\" class=\"arrow\"  onClick=\"Display_block('kanren1')\">\u25bc</span></a>"}, {"<span class=\"gogen\">(<it.)</span>", "<span class=\"gogen\">(\uff1cit.)</span>"}, {"<span class=\"gogen\">(<angl.)</span>", "<span class=\"gogen\">(\uff1cangl.)</span>"}, {"<span class=\"gogen\">(<\u6570\u5b66\u8005Hermite)</span>", "<span class=\"gogen\">(\uff1c\u6570\u5b66\u8005Hermite)</span>"}, {"<span class=\"gogen\">(<\u30a4\u30bf\u30ea\u30a2\u5317\u90e8\u306e\u5ddeLombardie)</span>", "<span class=\"gogen\">(\uff1c\u30a4\u30bf\u30ea\u30a2\u5317\u90e8\u306e\u5ddeLombardie)</span>"}, {"\uff1cspan ", SPAN_START}, {"\uff3b\u4f8b\uff1ah&eacute;mo\uff1ci>rragie</i>\u300c\u51fa\u8840\u300d\uff3d</span>", "\uff3b\u4f8b\uff1ah&eacute;mo<i>rragie</i>\u300c\u51fa\u8840\u300d\uff3d</span>"}, {"<span class=\"gogen\">(<gr.)</span>", "<span class=\"gogen\">(gr.)</span>"}, {"<tr id=\"sub_kanren1\" class=\"block\"><span class=\"tyuki\">(<span class=\"aster\"><td><table>\uff0a</span>", "<tr id=\"sub_kanren1\" class=\"block\"><td><table><span class=\"tyuki\">(<span class=\"aster\">\uff0a</span>"}, {"<span class=\"gogen\">(<\u30bf\u30a4\u738b\u56fd\u306e\u65e7\u79f0Siam)</span>", "<span class=\"gogen\">(\uff1c\u30bf\u30a4\u738b\u56fd\u306e\u65e7\u79f0Siam)</span>"}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            string = string.replace(stringArrayArray[i][0], stringArrayArray[i][1]);
        }
        String[][] stringArrayArray2 = new String[][]{{"(<input[^/<]+)>", "$1/>"}};
        for (int i = 0; i < stringArrayArray2.length; ++i) {
            string = string.replaceAll(stringArrayArray2[i][0], stringArrayArray2[i][1]);
        }
        return string;
    }

    private String fixHatuonChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            String string2 = hatuonMap.get(Character.valueOf(c));
            if (string2 != null) {
                stringBuffer.append(string2);
                continue;
            }
            if ('a' <= c && c <= 'z') {
                stringBuffer.append(c);
                continue;
            }
            if (c == '<') {
                int n = string.indexOf(62, i);
                if (n > 0) {
                    if (n + 2 < string.length() && string.charAt(n + 2) == '<') {
                        n = string.indexOf(62, n + 2);
                    }
                    stringBuffer.append(string.substring(i, n + 1));
                    i = n;
                    continue;
                }
                System.err.println("invalid hatuon: " + string);
                continue;
            }
            switch (c) {
                case ' ': 
                case '(': 
                case ')': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ';': 
                case '~': {
                    stringBuffer.append(c);
                    continue block3;
                }
                default: {
                    System.err.println("unknown " + c + " in " + string);
                    System.exit(1);
                }
            }
        }
        return stringBuffer.toString();
    }

    private int[] findHatuon(String string, int n) {
        int n2 = string.indexOf(HATUON_START, n);
        if (n2 >= 0) {
            int n3 = string.indexOf("</span>", n2 += HATUON_START.length());
            int n4 = string.indexOf(SPAN_START, n2);
            if (n4 > 0 && n4 < n3) {
                n4 = string.indexOf("</span>", n4);
                n3 = string.indexOf("</span>", n4 + "</span>".length());
            }
            return new int[]{n2, n3};
        }
        n2 = string.indexOf(PHONETIC_START, n);
        if (n2 >= 0) {
            int n5 = string.indexOf("</span>", n2 += PHONETIC_START.length());
            return new int[]{n2, n5};
        }
        return null;
    }

    private String fixHatuon(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            int[] nArray = this.findHatuon(string, n);
            if (nArray != null) {
                String string2 = string.substring(nArray[0], nArray[1]);
                stringBuffer.append(string.substring(n, nArray[0]));
                stringBuffer.append(this.fixHatuonChars(string2));
                n = nArray[1];
                continue;
            }
            stringBuffer.append(string.substring(n));
            break;
        }
        return stringBuffer.toString();
    }

    static void showGaiji() {
        TreeSet<String> treeSet = new TreeSet<String>(gaijiMap.values());
        for (String string : treeSet) {
            System.err.print(String.format("%s\t0x", string));
            for (int i = 0; i < string.length(); ++i) {
                System.err.print(String.format("%04X ", string.charAt(i)));
            }
            System.err.println();
        }
    }

    private String fixGaiji(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = GAIJI.matcher(string);
        int n = 0;
        while (matcher.find()) {
            stringBuffer.append(string.substring(n, matcher.start()));
            String string2 = matcher.group(1);
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                String string3 = gaijiMap.get(Character.valueOf(c));
                if (string3 != null && string3.length() > 0) {
                    if (string3.length() == 1) {
                        stringBuffer.append(String.format("<gaiji>%x</gaiji>", string3.charAt(0)));
                        continue;
                    }
                    stringBuffer.append(string3);
                    continue;
                }
                System.err.println("unknown gaiji: " + c);
                stringBuffer.append("<span class=\"gaiji\">");
                stringBuffer.append(c);
                stringBuffer.append("</span>");
            }
            n = matcher.end();
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private String getConjuId(File file) throws Exception {
        String string;
        String string2 = file.getAbsolutePath().replace(".htm", "_head.htm");
        File file2 = new File(string2);
        if (!file2.isFile()) {
            return "";
        }
        FileInputStream fileInputStream = new FileInputStream(file2);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        String string3 = null;
        while ((string = bufferedReader.readLine()) != null) {
            Matcher matcher = CONJU.matcher(string);
            if (!matcher.find()) continue;
            string3 = matcher.group(1);
            break;
        }
        bufferedReader.close();
        ((InputStream)fileInputStream).close();
        return string3;
    }

    private String appendMidasi(String string, String string2) {
        Matcher matcher = MIDASI.matcher(string);
        if (matcher.find()) {
            String string3 = String.format("<dt id=\"%s\">%s</dt>", matcher.group(1), matcher.group(2));
            if (string2 != null) {
                string3 = string3 + "<conju>" + string2 + "</conju>";
            }
            return string.substring(0, matcher.start()) + string3 + string.substring(matcher.start());
        }
        return string;
    }

    private void loadOneItemPage(File file) throws Exception {
        String string;
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null && !string.startsWith("<body ")) {
        }
        stringBuffer.append(string);
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).isEmpty()) continue;
            stringBuffer.append(string);
            if (!string.startsWith("</body>")) continue;
        }
        String string2 = this.getConjuId(file);
        String string3 = this.fixItem(stringBuffer.toString());
        string3 = this.fixHatuon(string3);
        string3 = this.fixGaiji(string3);
        string3 = this.appendMidasi(string3, string2);
        if (file.getName().equals("r-02616.htm")) {
            string3 = string3.replace("<dt id=\"R-02616\">retraiter</dt><body onLoad=\"init('R-02616')\">", "<dt id=\"R-02615\">retraiter</dt><body onLoad=\"init('R-02615')\">");
            string3 = string3.replace("<span class=\"doui\">(=battre an retraite)</span><a name=\"page_top\"><span class=\"midasi\">retranchement</span></a>", "<span class=\"doui\">(=battre an retraite)</span></td></tr></table><hr/></body>" + System.getProperty("line.separator") + "<dt id=\"R-02616\">retranchement</dt><body onLoad=\"init('R-02616')\"><table><tr><td><a name=\"page_top\"><span class=\"midasi\">retranchement</span></a>");
        }
        System.out.println(string3);
        bufferedReader.close();
        ((InputStream)fileInputStream).close();
    }

    private int maxFileId(File file) throws Exception {
        int n = 0;
        for (String string : file.list()) {
            int n2;
            Matcher matcher = HTM.matcher(string);
            if (!matcher.find() || (n2 = Integer.parseInt(matcher.group(1))) <= n) continue;
            n = n2;
        }
        return n;
    }

    private void loadItemPages(String string, File file) throws Exception {
        int n = this.maxFileId(file);
        for (int i = 1; i <= n; ++i) {
            String string2 = String.format("%s-%05d.htm", string, i);
            File file2 = new File(file.getAbsolutePath(), string2);
            if (file2.isFile()) {
                this.loadOneItemPage(file2);
                ++this.nLoaded;
                if (this.nLoaded % 1000 != 0) continue;
                System.err.print(".");
                continue;
            }
            System.err.println();
            System.err.println("WARN: cannot find " + string2 + ", skip it!");
        }
    }

    private void outHeader() throws Exception {
        System.out.println("<?xml version=\"1.0\"?>");
        System.out.println("<!DOCTYPE Dummy PUBLIC \"Dummy\" \"dtd/Dummy.dtd\" [");
        System.out.println("<!ENTITY % ISOCommon PUBLIC \"-//ISO//ISO Common//EN\" \"dtd/ISOCommon.dtd\" >");
        System.out.println("%ISOCommon;");
        System.out.println("]>");
        System.out.println("<royal>");
    }

    private void outTail() throws Exception {
        System.out.println("</royal>");
    }

    static void checkDirectory(File file) {
        if (!file.isDirectory()) {
            System.err.println("**************************");
            if (file.exists()) {
                System.err.println("ERROR: " + file + " is not a directory.");
            } else {
                System.err.println("ERROR: cannot find " + file);
            }
            System.err.println("**************************");
            System.exit(1);
        }
    }

    private void loadItemPages(String string) throws Exception {
        File file = new File(string);
        MakeBodyHtml.checkDirectory(file);
        String string2 = file.getName();
        this.outHeader();
        if (string2.length() == 1) {
            this.loadItemPages(string2, file);
        } else {
            for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                System.err.print(c);
                file = new File(string, Character.toString(c));
                string2 = file.getName();
                this.loadItemPages(string2, file);
            }
        }
        this.outTail();
        System.err.println();
        System.err.println("done. " + this.nLoaded + " entries");
    }

    public static void main(String[] stringArray) {
        MakeBodyHtml makeBodyHtml = new MakeBodyHtml();
        if (stringArray.length > 0) {
            ZephyrUtil.setUTF8Ouput();
            try {
                makeBodyHtml.loadItemPages(stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("Usage: java MakeBodyHtml <SOME_DIR>/royal/contents/fr/itempages{/[a-z]}");
        }
    }

    static {
        hatuonMap.put(Character.valueOf('+'), "\u0251");
        hatuonMap.put(Character.valueOf('#'), "\u025b");
        hatuonMap.put(Character.valueOf('%'), "\u0153");
        hatuonMap.put(Character.valueOf('?'), "\u0278");
        hatuonMap.put(Character.valueOf('$'), "\u0254");
        hatuonMap.put(Character.valueOf('\''), "\u0259");
        hatuonMap.put(Character.valueOf('M'), "\u0272");
        hatuonMap.put(Character.valueOf('G'), "\u025b\u0300");
        hatuonMap.put(Character.valueOf('_'), "\u0265");
        hatuonMap.put(Character.valueOf('0'), "\u0292");
        hatuonMap.put(Character.valueOf('1'), "a\u0303");
        hatuonMap.put(Character.valueOf('2'), "\u0251\u0303");
        hatuonMap.put(Character.valueOf('3'), "\u025b\u0303");
        hatuonMap.put(Character.valueOf('4'), "\u0254\u0303");
        hatuonMap.put(Character.valueOf('5'), "\u0153\u0303");
        hatuonMap.put(Character.valueOf('6'), "\u0283");
        hatuonMap.put(Character.valueOf('7'), "\u014b");
        hatuonMap.put(Character.valueOf('8'), "\u03b8");
        hatuonMap.put(Character.valueOf('9'), "\u00f0");
        gaijiMap = new HashMap();
        gaijiMap.put(Character.valueOf('\u4e9c'), "\u6798");
        gaijiMap.put(Character.valueOf('\u5516'), "\u75ca");
        gaijiMap.put(Character.valueOf('\u3061'), "\u05d0");
        gaijiMap.put(Character.valueOf('\u978d'), "\u84b4");
        gaijiMap.put(Character.valueOf('\u9022'), "\u7aa9");
        gaijiMap.put(Character.valueOf('\u63e1'), "\u9eac");
        gaijiMap.put(Character.valueOf('\u5a03'), "\u70bb");
        gaijiMap.put(Character.valueOf('\u963f'), "\u57f5");
        gaijiMap.put(Character.valueOf('\u54c0'), "\u7664");
        gaijiMap.put(Character.valueOf('\u611b'), "\u579c");
        gaijiMap.put(Character.valueOf('\u674f'), "\u7146");
        gaijiMap.put(Character.valueOf('\u6328'), "\u8484");
        gaijiMap.put(Character.valueOf('\u59f6'), "\u766d");
        gaijiMap.put(Character.valueOf('\u8475'), "\u7350");
        gaijiMap.put(Character.valueOf('\u831c'), "\u6410");
        gaijiMap.put(Character.valueOf('\u7a50'), "\u9ab6");
        gaijiMap.put(Character.valueOf('\u60aa'), "\u79b1");
        gaijiMap.put(Character.valueOf('\u3053'), "\u00a9");
        gaijiMap.put(Character.valueOf('\u6e25'), "\u76b6");
        gaijiMap.put(Character.valueOf('\u65ed'), "\u7c0e");
        gaijiMap.put(Character.valueOf('\u306f'), "<sup>1</sup>/<sub>2</sub>");
        gaijiMap.put(Character.valueOf('\u4ee5'), "\u9127");
        gaijiMap.put(Character.valueOf('\u8466'), "\u685b");
        gaijiMap.put(Character.valueOf('\u82a6'), "\u9846");
        gaijiMap.put(Character.valueOf('\u9bf5'), "\u8e70");
        gaijiMap.put(Character.valueOf('\u65a1'), "\u9c5d");
        gaijiMap.put(Character.valueOf('\u6271'), "(\u91d1+\u901a)");
        gaijiMap.put(Character.valueOf('\u6893'), "\u7cdd");
        gaijiMap.put(Character.valueOf('\u5b9b'), "\u9b10");
        gaijiMap.put(Character.valueOf('\u59d0'), "\u6677");
        gaijiMap.put(Character.valueOf('\u867b'), "\u55c9");
        gaijiMap.put(Character.valueOf('\u98f4'), "\u6a45");
        gaijiMap.put(Character.valueOf('\u7d62'), "\u9a38");
        gaijiMap.put(Character.valueOf('\u5727'), "\u9f95");
        gaijiMap.put(Character.valueOf('\u306e'), "<sup>1</sup>/<sub>3</sub>");
        gaijiMap.put(Character.valueOf('\u7dbe'), "\u6963");
        gaijiMap.put(Character.valueOf('\u9b8e'), "\u598d");
        gaijiMap.put(Character.valueOf('\u3042'), "\u261e");
        gaijiMap.put(Character.valueOf('\u6216'), "\u762d");
        gaijiMap.put(Character.valueOf('\u4f0a'), "\u9239");
        gaijiMap.put(Character.valueOf('\u7c9f'), "\u8dd7");
        gaijiMap.put(Character.valueOf('\u6697'), "\u58a9");
        gaijiMap.put(Character.valueOf('\u6848'), "\u7646");
        gaijiMap.put(Character.valueOf('\u5b89'), "\u7619");
        gaijiMap.put(Character.valueOf('\u5eb5'), "\u5608");
        gaijiMap.put(Character.valueOf('\u305b'), "\u03b9");
        gaijiMap.put(Character.valueOf('\u4f4d'), "\u82c6");
        gaijiMap.put(Character.valueOf('\u305d'), "\u5350");
        gaijiMap.put(Character.valueOf('\u95c7'), "\u8dd1");
        gaijiMap.put(Character.valueOf('\u305f'), "\u2123");
        gaijiMap.put(Character.valueOf('\u304f'), "\ue200");
        gaijiMap.put(Character.valueOf('\u304a'), "\ue201");
        gaijiMap.put(Character.valueOf('\u304b'), "\ue202");
        gaijiMap.put(Character.valueOf('\u304d'), "\ue203");
        gaijiMap.put(Character.valueOf('\u88b7'), "\ue204");
        gaijiMap.put(Character.valueOf('\u3044'), "\u221a3");
        gaijiMap.put(Character.valueOf('\u3046'), "<sup>3</sup>\u221a9");
        gaijiMap.put(Character.valueOf('\u3048'), "<sup>4</sup>\u221a10");
        GAIJI = Pattern.compile(GAIJI_REGEXP);
        CONJU = Pattern.compile(CONJU_REGEXP);
        MIDASI = Pattern.compile(MIDASI_REGEXP);
        HTM = Pattern.compile(".-([0-9]+)\\.htm");
    }
}

