/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusya.lajp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.ZephyrUtil;

public class CheckLatinWords {
    private final HashSet<String> heads = new HashSet();
    private final HashSet<String> morphs = new HashSet();
    private static final String DT_ID_REGEXP = "<dt id=\"([^ \"\\[]+)";
    private static final Pattern DT_ID = Pattern.compile("<dt id=\"([^ \"\\[]+)");
    private static final String WORD_REGEXP = "([a-zA-Z]+)";
    private static final Pattern WORD = Pattern.compile("([a-zA-Z]+)");

    CheckLatinWords() {
        this.morphs.add("I");
        this.morphs.add("II");
        this.morphs.add("III");
        this.morphs.add("Gk");
        this.morphs.add("adj");
        this.morphs.add("adv");
        this.morphs.add("sc");
        this.morphs.add("dim");
        this.morphs.add("alqm");
        this.morphs.add("alqo");
        this.morphs.add("alqd");
        this.morphs.add("neut");
        this.morphs.add("pref");
        this.morphs.add("pref");
        this.morphs.add("pp");
        this.morphs.add("intr");
        this.morphs.add("dep");
        this.morphs.add("pf");
        this.morphs.add("inf");
        this.morphs.add("acc");
        this.morphs.add("cf");
        this.morphs.add("con");
        this.morphs.add("abl");
        this.morphs.add("freq");
        this.morphs.add("prp");
        this.morphs.add("inch");
        this.morphs.add("pass");
        this.morphs.add("indecl");
        this.morphs.add("sg");
        this.morphs.add("refl");
        this.morphs.add("prep");
        this.morphs.add("semi");
        this.morphs.add("conj");
        this.morphs.add("impers");
        this.morphs.add("subj");
        this.morphs.add("comp");
        this.morphs.add("int");
        this.morphs.add("pron");
        this.morphs.add("fut");
        this.morphs.add("superl");
        this.morphs.add("bi");
        this.morphs.add("tri");
        this.morphs.add("card");
        this.morphs.add("interrog");
        this.morphs.add("relat");
        this.morphs.add("ord");
        this.morphs.add("distrib");
        this.morphs.add("nom");
        this.morphs.add("impr");
        this.morphs.add("gerundiv");
        this.morphs.add("intens");
        this.morphs.add("indef");
        this.morphs.add("us");
        this.morphs.add("pers");
        this.morphs.add("idem");
        this.morphs.add("quisque");
        this.morphs.add("lacio");
        this.morphs.add("amb");
        this.morphs.add("cu");
        this.morphs.add("ejus");
        this.morphs.add("pleo");
        this.morphs.add("impf");
        this.morphs.add("alqos");
        this.morphs.add("trav");
        this.morphs.add("paul");
        this.morphs.add("deos");
        this.morphs.add("um");
        this.morphs.add("sup");
        this.morphs.add("loc");
        this.morphs.add("voc");
        this.morphs.add("uterque");
        this.morphs.add("tral");
        this.morphs.add("quisquam");
        this.morphs.add("Cic");
        this.morphs.add("Ov");
    }

    private void loadMorph(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "ASCII"));
        while ((string2 = bufferedReader.readLine()) != null) {
            int n = string2.indexOf(44);
            int n2 = string2.indexOf(32, n + 1);
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1, n2);
            this.heads.add(string4);
            this.morphs.add(string3);
        }
        System.err.println("head=" + this.heads.size() + " entries, morphs=" + this.morphs.size() + " entries");
    }

    private void loadGeorgesLaDe(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "Windows-31J"));
        int n = this.heads.size();
        while ((string2 = bufferedReader.readLine()) != null) {
            Matcher matcher = DT_ID.matcher(string2);
            if (!matcher.find()) continue;
            this.heads.add(matcher.group(1));
        }
        System.err.println("head=" + this.heads.size() + " entries, added " + (this.heads.size() - n) + " entries");
    }

    private void loadBody(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        TreeSet<String> treeSet = new TreeSet<String>();
        String string3 = "";
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.trim().isEmpty()) continue;
            String string4 = ZephyrUtil.dropMarks(string2);
            Matcher object = WORD.matcher(string4);
            boolean bl = true;
            while (object.find()) {
                String string5 = object.group(1);
                if (string2.charAt(0) != ' ' && bl) {
                    if (string5.compareToIgnoreCase(string3) < 0) {
                        System.out.println("###\tprev=" + string3 + ", cur=" + string5);
                    }
                    string3 = string5;
                    bl = false;
                }
                if (string5.length() <= 1 || object.start(1) > 0 && string4.charAt(object.start(1) - 1) == '-' || this.heads.contains(string5) || this.morphs.contains(string5)) continue;
                treeSet.add(string5);
            }
        }
        for (String string6 : treeSet) {
            System.out.println(string6);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length >= 3) {
            CheckLatinWords checkLatinWords = new CheckLatinWords();
            try {
                checkLatinWords.loadMorph(stringArray[1]);
                checkLatinWords.loadGeorgesLaDe(stringArray[2]);
                checkLatinWords.loadBody(stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("Usage: java CheckLatinWords kenkyusya-lajp.txt whitaker.morph.txt georges-ldhd-body.html");
        }
    }
}

