/*
 * Decompiled with CFR 0.152.
 */
package zephyr.sanshusha.accessdejp;

import java.util.HashMap;
import java.util.TreeSet;
import zephyr.sanshusha.accessdejp.Buffer;
import zephyr.sanshusha.accessdejp.Util;

public class TagDecoder {
    private static final HashMap<Integer, String> tagMap = new HashMap();
    private static final int ZENKAKU_START = -515491792;
    private static final int HANKAKU_START = -515493840;
    private static final int EXTCHAR_START = -515493838;
    private static final int YOUREI_START = -515099638;
    private static final int WAKU_START = 14767692;
    static final String WAKU_START_TAG = "<WAKU_START/>";
    static final String WAKU_END_TAG = "<WAKU_END/>";
    static final String SECTION_TAG = "<SECTION/>";
    static final String SUBSECTION_TAG = "<SUBSECTION/>";
    private static final HashMap<Integer, String> uniMap;
    private static final HashMap<Integer, String> extChMap;
    private static final TreeSet<Character> unknownExChar;
    private static byte BYTE_E1;

    private static int bytes2int(byte by, byte by2) {
        return (Util.sbyte2int(by) << 8) + Util.sbyte2int(by2);
    }

    private static int str2int(String string) {
        byte[] byArray = string.getBytes();
        if (byArray.length == 2) {
            return TagDecoder.bytes2int(byArray[0], byArray[1]);
        }
        System.err.println("PROGRAM ERROR: " + string);
        return -1;
    }

    private static int outExtChars(StringBuffer stringBuffer, byte[] byArray, int n) {
        int n2 = n;
        while (byArray[n2] != BYTE_E1) {
            int n3 = Util.sbyte2int(byArray[n2]);
            int n4 = (n3 << 8) + Util.sbyte2int(byArray[n2 + 1]);
            String string = extChMap.get(n4);
            if (string != null) {
                stringBuffer.append(string);
                n2 += 2;
                continue;
            }
            string = extChMap.get(n3);
            if (string != null) {
                stringBuffer.append(string);
                ++n2;
                continue;
            }
            char c = (char)n3;
            stringBuffer.append(c);
            if (!unknownExChar.contains(Character.valueOf(c))) {
                unknownExChar.add(Character.valueOf(c));
                System.err.println("unknown extChar: " + c + String.format("\t%x %x %x", byArray[n2 - 1], byArray[n2], byArray[n2 + 1]));
                System.err.println("\t" + stringBuffer.toString().replace("\n", " "));
            }
            ++n2;
        }
        return n2;
    }

    String decode(byte[] byArray, int n) {
        int n2 = -515493840;
        Buffer buffer = new Buffer();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        block6: while (n3 < n) {
            byte by = byArray[n3];
            int n4 = Util.sbyte2int(by);
            if (by != BYTE_E1) {
                if (n2 == -515493840) {
                    String string = uniMap.get(n4);
                    if (string != null) {
                        stringBuffer.append(buffer.toString(false));
                        buffer.clear();
                        stringBuffer.append(string);
                    } else if (n4 == 183) {
                        stringBuffer.append(buffer.toString(false));
                        buffer.clear();
                        stringBuffer.append("\u00b7");
                    } else {
                        buffer.add(by);
                    }
                } else {
                    buffer.add(by);
                }
                ++n3;
                continue;
            }
            int n5 = Util.sbyte2int(byArray[n3]) << 16;
            n5 += Util.sbyte2int(byArray[n3 + 1]) << 8;
            int n6 = ((n5 += Util.sbyte2int(byArray[n3 + 2])) << 8) + Util.sbyte2int(byArray[n3 + 3]);
            switch (n6) {
                case -515493840: {
                    stringBuffer.append(buffer.toString(true));
                    buffer.clear();
                    n2 = n6;
                    n3 += 4;
                    continue block6;
                }
                case -515491792: {
                    stringBuffer.append(buffer.toString(false));
                    buffer.clear();
                    n2 = n6;
                    n3 += 4;
                    continue block6;
                }
                case -515493838: {
                    stringBuffer.append(buffer.toString(n2 == -515491792));
                    buffer.clear();
                    n3 = TagDecoder.outExtChars(stringBuffer, byArray, n3 + 4);
                    continue block6;
                }
                case -515099638: {
                    stringBuffer.append(buffer.toString(n2 == -515491792));
                    buffer.clear();
                    stringBuffer.append("\u25b7\n");
                    n3 += 4;
                    continue block6;
                }
            }
            String string = tagMap.get(n5);
            if (string != null) {
                stringBuffer.append(buffer.toString(n2 == -515491792));
                buffer.clear();
                n3 += 3;
                if (n5 == 14767692) {
                    while (byArray[n3] != BYTE_E1) {
                        ++n3;
                    }
                }
                buffer.add(string);
                continue;
            }
            buffer.add(by);
            ++n3;
        }
        stringBuffer.append(buffer.toString(n2 == -515491792));
        return stringBuffer.toString();
    }

    static void dumpUnknown() {
        for (char c : unknownExChar) {
            System.err.print(c);
        }
        if (!unknownExChar.isEmpty()) {
            System.err.println();
        }
    }

    static {
        tagMap.put(-515491792, "");
        tagMap.put(-515493840, "");
        tagMap.put(-515493838, "");
        tagMap.put(14762545, "<b>");
        tagMap.put(14762544, "</b>");
        tagMap.put(14764337, "<i>");
        tagMap.put(14764336, "</i>");
        tagMap.put(14765105, SECTION_TAG);
        tagMap.put(14765106, SUBSECTION_TAG);
        tagMap.put(14765107, "");
        tagMap.put(14766898, "");
        tagMap.put(14766899, "");
        tagMap.put(14767692, WAKU_START_TAG);
        tagMap.put(14767724, WAKU_END_TAG);
        tagMap.put(14775089, "<sub>");
        tagMap.put(14775088, "</sub>");
        uniMap = new HashMap();
        for (char c = '\u00c0'; c <= '\u00ff'; c = (char)(c + '\u0001')) {
            uniMap.put(Integer.valueOf(c), Character.toString(c));
        }
        extChMap = new HashMap();
        extChMap.put(33, "\u0301");
        extChMap.put(TagDecoder.str2int("A~"), "\u00e0");
        extChMap.put(TagDecoder.str2int("a!"), "\u00e1");
        extChMap.put(TagDecoder.str2int("e!"), "\u00e9");
        extChMap.put(TagDecoder.str2int("I!"), "\u026a\u0301");
        extChMap.put(37409, "\u026a\u0301");
        extChMap.put(TagDecoder.str2int("i!"), "\u00ed");
        extChMap.put(TagDecoder.str2int("o!"), "\u00f3");
        extChMap.put(TagDecoder.str2int("u!"), "\u00fa");
        extChMap.put(58158, "\u00f8\u0301");
        extChMap.put(165, "\u035c");
        extChMap.put(67, "\u00e7");
        extChMap.put(69, "\u0259");
        extChMap.put(103, "\u0261");
        extChMap.put(73, "\u026a");
        extChMap.put(78, "\u014b");
        extChMap.put(79, "\u0254");
        extChMap.put(83, "\u0283");
        extChMap.put(89, "\u028f");
        extChMap.put(123, "\u0153");
        extChMap.put(201, "\u02d0");
        extChMap.put(211, "\u025b");
        extChMap.put(54142, "\u025b\u0300");
        extChMap.put(227, "\u00f8");
        extChMap.put(231, "\u028a");
        extChMap.put(218, "\u0301");
        extChMap.put(90, "\u0292");
        extChMap.put(97, "a");
        extChMap.put(102, "f");
        extChMap.put(112, "p");
        extChMap.put(114, "r");
        extChMap.put(115, "s");
        extChMap.put(116, "t");
        extChMap.put(121, "y");
        unknownExChar = new TreeSet();
        BYTE_E1 = Util.int2sbyte(225);
    }
}

