/*
 * Decompiled with CFR 0.152.
 */
package zephyr.obunsha.petitroyal;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.obunsha.petitroyal.MakeBodyHtml;
import zephyr.util.ZephyrUtil;

public class MakeConjuHtml {
    private static final String CONJU_BODY_REGEXP = "<tr class=\"title_bar\">((<td class=\"title\">[^<]+</td> )+)</tr><tr class=\"data\">((<td>.*?</td> )+?)</tr>";
    private static final String CONJU_TABLES_REGEXP = "<table id='tbl?[1-5]'><caption>([^<]+)</caption>((<tr class=\"title_bar\">((<td class=\"title\">[^<]+</td> )+)</tr><tr class=\"data\">((<td>.*?</td> )+?)</tr>)+)";
    private static final String CONJU_TITLE_REGEXP = "<td class=\"title\">([^<]+)</td>";
    private static final String CONJU_DATA_REGEXP = "<td>(.*?)</td>";
    private static final Pattern CONJU_TABLES = Pattern.compile("<table id='tbl?[1-5]'><caption>([^<]+)</caption>((<tr class=\"title_bar\">((<td class=\"title\">[^<]+</td> )+)</tr><tr class=\"data\">((<td>.*?</td> )+?)</tr>)+)");
    private static final Pattern CONJU_BODY = Pattern.compile("<tr class=\"title_bar\">((<td class=\"title\">[^<]+</td> )+)</tr><tr class=\"data\">((<td>.*?</td> )+?)</tr>");
    private static final Pattern CONJU_TITLE = Pattern.compile("<td class=\"title\">([^<]+)</td>");
    private static final Pattern CONJU_DATA = Pattern.compile("<td>(.*?)</td>");

    private String[] getTexts(String string, Pattern pattern) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            linkedList.add(matcher.group(1));
        }
        return linkedList.toArray(new String[0]);
    }

    private void conjuBodies(StringBuffer stringBuffer, String string) {
        Matcher matcher = CONJU_BODY.matcher(string);
        while (matcher.find()) {
            String[] stringArray;
            String[] stringArray2 = this.getTexts(matcher.group(1), CONJU_TITLE);
            if (stringArray2.length != (stringArray = this.getTexts(matcher.group(3), CONJU_DATA)).length) {
                System.err.println("titles.lenght=" + stringArray2.length + ", data.length=" + stringArray.length);
                System.err.println(string);
                System.exit(1);
            }
            for (int i = 0; i < stringArray2.length; ++i) {
                stringBuffer.append("<indent val=\"1\"><p>-- ");
                stringBuffer.append(stringArray2[i]);
                stringBuffer.append(" --</p><indent val=\"2\"><p>");
                String string2 = stringArray[i].endsWith("<br>") ? stringArray[i].substring(0, stringArray[i].length() - 4) : stringArray[i];
                string2 = string2.replace("<br>", " / ");
                stringBuffer.append(string2);
                stringBuffer.append("</p>");
            }
        }
    }

    private String conjuHtml(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = CONJU_TABLES.matcher(string);
        stringBuffer.append("<p> </p>");
        while (matcher.find()) {
            stringBuffer.append("<indent val=\"1\"><p><b>== ");
            stringBuffer.append(matcher.group(1));
            stringBuffer.append(" ==</b></p>");
            this.conjuBodies(stringBuffer, matcher.group(2));
        }
        return stringBuffer.toString();
    }

    public void loadConju(String string) throws Exception {
        Class.forName("org.sqlite.JDBC");
        Connection connection = DriverManager.getConnection("jdbc:sqlite:" + string);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select conju_id,midasi,html from conju_items;");
        System.out.println("<html><body>");
        int n = 0;
        while (resultSet.next()) {
            String string2 = resultSet.getString("conju_id");
            String string3 = resultSet.getString("midasi");
            String string4 = resultSet.getString("html");
            System.out.print("<dt id=\"");
            System.out.print(string2);
            System.out.print("\">");
            System.out.print(string3);
            System.out.print(" #</dt><dd>");
            System.out.print(this.conjuHtml(string4));
            System.out.println("</dd>");
            if (++n % 1000 != 0) continue;
            System.err.print(".");
        }
        System.out.println("</body></html>");
        resultSet.close();
        connection.close();
        System.err.println();
        System.err.println("done. " + n + " entries");
    }

    public static void main(String[] stringArray) {
        String string = stringArray.length == 0 ? "petit.sql" : stringArray[0];
        MakeBodyHtml.checkDBFile(string);
        MakeConjuHtml makeConjuHtml = new MakeConjuHtml();
        try {
            ZephyrUtil.setUTF8Ouput();
            makeConjuHtml.loadConju(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

