/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusya.lajp;

import estraier.Database;
import estraier.Document;
import java.util.List;
import zephyr.util.ZephyrUtil;

public class EstraierLoader {
    static final String ENTRY_DELIM = "======";

    private void load(String string) throws Exception {
        Database database = new Database();
        if (!database.open(string, 1)) {
            throw new Exception(database.err_msg(database.error()));
        }
        int n = database.doc_num();
        System.err.print("loading Latin-Japanese entries ");
        boolean bl = true;
        int n2 = 0;
        for (int i = 1; i <= n; ++i) {
            Document document = database.get_doc(i, 0);
            if (document == null) {
                System.err.println("cannot get id=" + i);
                continue;
            }
            List list = document.texts();
            if (bl) {
                char c = list.get(0).toString().charAt(0);
                if (c != 'A') continue;
                bl = false;
            }
            for (Object e : list) {
                System.out.println(e.toString());
            }
            System.out.println(ENTRY_DELIM);
            if (++n2 % 1000 != 0) continue;
            System.err.print('.');
        }
        database.close();
        System.err.println();
        System.err.println("done. " + n2 + " entries");
    }

    public static void main(String[] stringArray) {
        ZephyrUtil.setUTF8Ouput();
        EstraierLoader estraierLoader = new EstraierLoader();
        if (stringArray.length > 0) {
            try {
                estraierLoader.load(stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("Usage: java EstraierLoader SOME_DIR/index_E");
        }
    }
}

