/*
 * Decompiled with CFR 0.152.
 */
package zephyr.util;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnescapeChars {
    private static HashMap<String, Character> escMap = new HashMap();
    private static HashMap<Integer, String> codeMap = new HashMap();
    private static final String ESCAPE_REGEXP = "&[a-zA-Z]+;";
    private static final Pattern ESCAPE;
    private static final String CODE_REGEXP = "&#x([0-9a-zA-Z]+);";
    private static final Pattern CODE;

    private static void addEscChar(String string, char c) {
        if (c < '\u017e') {
            escMap.put(string, Character.valueOf(c));
            codeMap.put(Integer.valueOf(c), string);
        }
    }

    public static String unescape(String string) {
        Matcher matcher = ESCAPE.matcher(string);
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2;
            Character c;
            if (n < matcher.start()) {
                stringBuffer.append(string.substring(n, matcher.start()));
            }
            if ((c = escMap.get(string2 = matcher.group())) != null) {
                stringBuffer.append(c);
            } else {
                stringBuffer.append(string2);
            }
            n = matcher.end();
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    public static String unescapeCode(String string) {
        Matcher matcher = CODE.matcher(string);
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            int n2;
            String string2;
            if (n < matcher.start()) {
                stringBuffer.append(string.substring(n, matcher.start()));
            }
            if ((string2 = codeMap.get(n2 = Integer.parseInt(matcher.group(1), 16))) != null) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(matcher.group());
            }
            n = matcher.end();
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    static {
        UnescapeChars.addEscChar("&Aacgr;", '\u0386');
        UnescapeChars.addEscChar("&aacgr;", '\u03ac');
        UnescapeChars.addEscChar("&Aacute;", '\u00c1');
        UnescapeChars.addEscChar("&aacute;", '\u00e1');
        UnescapeChars.addEscChar("&Abreve;", '\u0102');
        UnescapeChars.addEscChar("&abreve;", '\u0103');
        UnescapeChars.addEscChar("&Acirc;", '\u00c2');
        UnescapeChars.addEscChar("&acirc;", '\u00e2');
        UnescapeChars.addEscChar("&acute;", '\u00b4');
        UnescapeChars.addEscChar("&Acy;", '\u0410');
        UnescapeChars.addEscChar("&acy;", '\u0430');
        UnescapeChars.addEscChar("&AElig;", '\u00c6');
        UnescapeChars.addEscChar("&aelig;", '\u00e6');
        UnescapeChars.addEscChar("&Agr;", '\u0391');
        UnescapeChars.addEscChar("&agr;", '\u03b1');
        UnescapeChars.addEscChar("&Agrave;", '\u00c0');
        UnescapeChars.addEscChar("&agrave;", '\u00e0');
        UnescapeChars.addEscChar("&alefsym;", '\u2135');
        UnescapeChars.addEscChar("&aleph;", '\u2135');
        UnescapeChars.addEscChar("&Alpha;", '\u0391');
        UnescapeChars.addEscChar("&alpha;", '\u03b1');
        UnescapeChars.addEscChar("&Amacr;", '\u0100');
        UnescapeChars.addEscChar("&amacr;", '\u0101');
        UnescapeChars.addEscChar("&amalg;", '\u2210');
        UnescapeChars.addEscChar("&amp;", '&');
        UnescapeChars.addEscChar("&and;", '\u2227');
        UnescapeChars.addEscChar("&ang;", '\u2220');
        UnescapeChars.addEscChar("&ang90;", '\u221f');
        UnescapeChars.addEscChar("&angmsd;", '\u2221');
        UnescapeChars.addEscChar("&angsph;", '\u2222');
        UnescapeChars.addEscChar("&angst;", '\u212b');
        UnescapeChars.addEscChar("&Aogon;", '\u0104');
        UnescapeChars.addEscChar("&aogon;", '\u0105');
        UnescapeChars.addEscChar("&ap;", '\u2248');
        UnescapeChars.addEscChar("&ape;", '\u224a');
        UnescapeChars.addEscChar("&apos;", '\u02bc');
        UnescapeChars.addEscChar("&Aring;", '\u00c5');
        UnescapeChars.addEscChar("&aring;", '\u00e5');
        UnescapeChars.addEscChar("&ast;", '*');
        UnescapeChars.addEscChar("&asymp;", '\u2248');
        UnescapeChars.addEscChar("&Atilde;", '\u00c3');
        UnescapeChars.addEscChar("&atilde;", '\u00e3');
        UnescapeChars.addEscChar("&Auml;", '\u00c4');
        UnescapeChars.addEscChar("&auml;", '\u00e4');
        UnescapeChars.addEscChar("&b.alpha;", '\u03b1');
        UnescapeChars.addEscChar("&barwed;", '\u22bc');
        UnescapeChars.addEscChar("&Barwed;", '\u2306');
        UnescapeChars.addEscChar("&b.beta;", '\u03b2');
        UnescapeChars.addEscChar("&b.chi;", '\u03c7');
        UnescapeChars.addEscChar("&bcong;", '\u224c');
        UnescapeChars.addEscChar("&Bcy;", '\u0411');
        UnescapeChars.addEscChar("&bcy;", '\u0431');
        UnescapeChars.addEscChar("&b.Delta;", '\u0394');
        UnescapeChars.addEscChar("&b.delta;", '\u03b4');
        UnescapeChars.addEscChar("&bdquo;", '\u201e');
        UnescapeChars.addEscChar("&becaus;", '\u2235');
        UnescapeChars.addEscChar("&bepsi;", '\u220d');
        UnescapeChars.addEscChar("&b.epsi;", '\u03b5');
        UnescapeChars.addEscChar("&b.epsis;", '\u03b5');
        UnescapeChars.addEscChar("&b.epsiv;", '\u03b5');
        UnescapeChars.addEscChar("&bernou;", '\u212c');
        UnescapeChars.addEscChar("&Beta;", '\u0392');
        UnescapeChars.addEscChar("&beta;", '\u03b2');
        UnescapeChars.addEscChar("&b.eta;", '\u03b7');
        UnescapeChars.addEscChar("&beth;", '\u2136');
        UnescapeChars.addEscChar("&b.Gamma;", '\u0393');
        UnescapeChars.addEscChar("&b.gamma;", '\u03b3');
        UnescapeChars.addEscChar("&b.gammad;", '\u03dc');
        UnescapeChars.addEscChar("&Bgr;", '\u0392');
        UnescapeChars.addEscChar("&bgr;", '\u03b2');
        UnescapeChars.addEscChar("&b.iota;", '\u03b9');
        UnescapeChars.addEscChar("&b.kappa;", '\u03ba');
        UnescapeChars.addEscChar("&b.kappav;", '\u03f0');
        UnescapeChars.addEscChar("&b.Lambda;", '\u039b');
        UnescapeChars.addEscChar("&b.lambda;", '\u03bb');
        UnescapeChars.addEscChar("&blank;", '\u2423');
        UnescapeChars.addEscChar("&blk12;", '\u2592');
        UnescapeChars.addEscChar("&blk14;", '\u2591');
        UnescapeChars.addEscChar("&blk34;", '\u2593');
        UnescapeChars.addEscChar("&block;", '\u2588');
        UnescapeChars.addEscChar("&b.mu;", '\u03bc');
        UnescapeChars.addEscChar("&b.nu;", '\u03bd');
        UnescapeChars.addEscChar("&b.Omega;", '\u03a9');
        UnescapeChars.addEscChar("&b.omega;", '\u03ce');
        UnescapeChars.addEscChar("&bottom;", '\u22a5');
        UnescapeChars.addEscChar("&bowtie;", '\u22c8');
        UnescapeChars.addEscChar("&boxdl;", '\u2510');
        UnescapeChars.addEscChar("&boxdL;", '\u2555');
        UnescapeChars.addEscChar("&boxDl;", '\u2556');
        UnescapeChars.addEscChar("&boxDL;", '\u2557');
        UnescapeChars.addEscChar("&boxdr;", '\u250c');
        UnescapeChars.addEscChar("&boxdR;", '\u2552');
        UnescapeChars.addEscChar("&boxDr;", '\u2553');
        UnescapeChars.addEscChar("&boxDR;", '\u2554');
        UnescapeChars.addEscChar("&boxh;", '\u2500');
        UnescapeChars.addEscChar("&boxH;", '\u2550');
        UnescapeChars.addEscChar("&boxhd;", '\u252c');
        UnescapeChars.addEscChar("&boxHd;", '\u2564');
        UnescapeChars.addEscChar("&boxhD;", '\u2565');
        UnescapeChars.addEscChar("&boxHD;", '\u2566');
        UnescapeChars.addEscChar("&boxhu;", '\u2534');
        UnescapeChars.addEscChar("&boxHu;", '\u2567');
        UnescapeChars.addEscChar("&boxhU;", '\u2568');
        UnescapeChars.addEscChar("&boxHU;", '\u2569');
        UnescapeChars.addEscChar("&boxul;", '\u2518');
        UnescapeChars.addEscChar("&boxuL;", '\u255b');
        UnescapeChars.addEscChar("&boxUl;", '\u255c');
        UnescapeChars.addEscChar("&boxUL;", '\u255d');
        UnescapeChars.addEscChar("&boxur;", '\u2514');
        UnescapeChars.addEscChar("&boxuR;", '\u2558');
        UnescapeChars.addEscChar("&boxUr;", '\u2559');
        UnescapeChars.addEscChar("&boxUR;", '\u255a');
        UnescapeChars.addEscChar("&boxv;", '\u2502');
        UnescapeChars.addEscChar("&boxV;", '\u2551');
        UnescapeChars.addEscChar("&boxvh;", '\u253c');
        UnescapeChars.addEscChar("&boxvH;", '\u256a');
        UnescapeChars.addEscChar("&boxVh;", '\u256b');
        UnescapeChars.addEscChar("&boxVH;", '\u256c');
        UnescapeChars.addEscChar("&boxvl;", '\u2524');
        UnescapeChars.addEscChar("&boxvL;", '\u2561');
        UnescapeChars.addEscChar("&boxVl;", '\u2562');
        UnescapeChars.addEscChar("&boxVL;", '\u2563');
        UnescapeChars.addEscChar("&boxvr;", '\u251c');
        UnescapeChars.addEscChar("&boxvR;", '\u255e');
        UnescapeChars.addEscChar("&boxVr;", '\u255f');
        UnescapeChars.addEscChar("&boxVR;", '\u2560');
        UnescapeChars.addEscChar("&b.Phi;", '\u03a6');
        UnescapeChars.addEscChar("&b.phis;", '\u03c6');
        UnescapeChars.addEscChar("&b.phiv;", '\u03d5');
        UnescapeChars.addEscChar("&b.Pi;", '\u03a0');
        UnescapeChars.addEscChar("&b.pi;", '\u03c0');
        UnescapeChars.addEscChar("&b.piv;", '\u03d6');
        UnescapeChars.addEscChar("&bprime;", '\u2035');
        UnescapeChars.addEscChar("&b.Psi;", '\u03a8');
        UnescapeChars.addEscChar("&b.psi;", '\u03c8');
        UnescapeChars.addEscChar("&breve;", '\u02d8');
        UnescapeChars.addEscChar("&b.rho;", '\u03c1');
        UnescapeChars.addEscChar("&b.rhov;", '\u03f1');
        UnescapeChars.addEscChar("&brvbar;", '\u00a6');
        UnescapeChars.addEscChar("&b.Sigma;", '\u03a3');
        UnescapeChars.addEscChar("&b.sigma;", '\u03c3');
        UnescapeChars.addEscChar("&b.sigmav;", '\u03c2');
        UnescapeChars.addEscChar("&bsim;", '\u223d');
        UnescapeChars.addEscChar("&bsime;", '\u22cd');
        UnescapeChars.addEscChar("&b.tau;", '\u03c4');
        UnescapeChars.addEscChar("&b.Theta;", '\u0398');
        UnescapeChars.addEscChar("&b.thetas;", '\u03b8');
        UnescapeChars.addEscChar("&b.thetav;", '\u03d1');
        UnescapeChars.addEscChar("&bull;", '\u2022');
        UnescapeChars.addEscChar("&bump;", '\u224e');
        UnescapeChars.addEscChar("&bumpe;", '\u224f');
        UnescapeChars.addEscChar("&b.Upsi;", '\u03a5');
        UnescapeChars.addEscChar("&b.upsi;", '\u03c5');
        UnescapeChars.addEscChar("&b.Xi;", '\u039e');
        UnescapeChars.addEscChar("&b.xi;", '\u03be');
        UnescapeChars.addEscChar("&b.zeta;", '\u03b6');
        UnescapeChars.addEscChar("&Cacute;", '\u0106');
        UnescapeChars.addEscChar("&cacute;", '\u0107');
        UnescapeChars.addEscChar("&Cap;", '\u22d2');
        UnescapeChars.addEscChar("&cap;", '\u2229');
        UnescapeChars.addEscChar("&caret;", '\u2041');
        UnescapeChars.addEscChar("&caron;", '\u02c7');
        UnescapeChars.addEscChar("&Ccaron;", '\u010c');
        UnescapeChars.addEscChar("&ccaron;", '\u010d');
        UnescapeChars.addEscChar("&Ccedil;", '\u00c7');
        UnescapeChars.addEscChar("&ccedil;", '\u00e7');
        UnescapeChars.addEscChar("&Ccirc;", '\u0108');
        UnescapeChars.addEscChar("&ccirc;", '\u0109');
        UnescapeChars.addEscChar("&Cdot;", '\u010a');
        UnescapeChars.addEscChar("&cdot;", '\u010b');
        UnescapeChars.addEscChar("&cedil;", '\u00b8');
        UnescapeChars.addEscChar("&cent;", '\u00a2');
        UnescapeChars.addEscChar("&CHcy;", '\u0427');
        UnescapeChars.addEscChar("&chcy;", '\u0447');
        UnescapeChars.addEscChar("&check;", '\u2713');
        UnescapeChars.addEscChar("&Chi;", '\u03a7');
        UnescapeChars.addEscChar("&chi;", '\u03c7');
        UnescapeChars.addEscChar("&cir;", '\u25cb');
        UnescapeChars.addEscChar("&circ;", '\u02c6');
        UnescapeChars.addEscChar("&cire;", '\u2257');
        UnescapeChars.addEscChar("&clubs;", '\u2663');
        UnescapeChars.addEscChar("&colon;", ':');
        UnescapeChars.addEscChar("&colone;", '\u2254');
        UnescapeChars.addEscChar("&comma;", ',');
        UnescapeChars.addEscChar("&commat;", '@');
        UnescapeChars.addEscChar("&comp;", '\u2201');
        UnescapeChars.addEscChar("&compfn;", '\u2218');
        UnescapeChars.addEscChar("&cong;", '\u2245');
        UnescapeChars.addEscChar("&conint;", '\u222e');
        UnescapeChars.addEscChar("&coprod;", '\u2210');
        UnescapeChars.addEscChar("&copy;", '\u00a9');
        UnescapeChars.addEscChar("&copysr;", '\u2117');
        UnescapeChars.addEscChar("&crarr;", '\u21b5');
        UnescapeChars.addEscChar("&cross;", '\u2717');
        UnescapeChars.addEscChar("&cuepr;", '\u22de');
        UnescapeChars.addEscChar("&cuesc;", '\u22df');
        UnescapeChars.addEscChar("&cularr;", '\u21b6');
        UnescapeChars.addEscChar("&Cup;", '\u22d3');
        UnescapeChars.addEscChar("&cup;", '\u222a');
        UnescapeChars.addEscChar("&cupre;", '\u227c');
        UnescapeChars.addEscChar("&curarr;", '\u21b7');
        UnescapeChars.addEscChar("&curren;", '\u00a4');
        UnescapeChars.addEscChar("&cuvee;", '\u22ce');
        UnescapeChars.addEscChar("&cuwed;", '\u22cf');
        UnescapeChars.addEscChar("&dagger;", '\u2020');
        UnescapeChars.addEscChar("&Dagger;", '\u2021');
        UnescapeChars.addEscChar("&daleth;", '\u2138');
        UnescapeChars.addEscChar("&dArr;", '\u21d3');
        UnescapeChars.addEscChar("&darr;", '\u2193');
        UnescapeChars.addEscChar("&darr2;", '\u21ca');
        UnescapeChars.addEscChar("&dash;", '\u2010');
        UnescapeChars.addEscChar("&dashv;", '\u22a3');
        UnescapeChars.addEscChar("&dblac;", '\u02dd');
        UnescapeChars.addEscChar("&Dcaron;", '\u010e');
        UnescapeChars.addEscChar("&dcaron;", '\u010f');
        UnescapeChars.addEscChar("&Dcy;", '\u0414');
        UnescapeChars.addEscChar("&dcy;", '\u0434');
        UnescapeChars.addEscChar("&deg;", '\u00b0');
        UnescapeChars.addEscChar("&Delta;", '\u0394');
        UnescapeChars.addEscChar("&delta;", '\u03b4');
        UnescapeChars.addEscChar("&Dgr;", '\u0394');
        UnescapeChars.addEscChar("&dgr;", '\u03b4');
        UnescapeChars.addEscChar("&dharl;", '\u21c3');
        UnescapeChars.addEscChar("&dharr;", '\u21c2');
        UnescapeChars.addEscChar("&diam;", '\u22c4');
        UnescapeChars.addEscChar("&diams;", '\u2666');
        UnescapeChars.addEscChar("&die;", '\u00a8');
        UnescapeChars.addEscChar("&divide;", '\u00f7');
        UnescapeChars.addEscChar("&divonx;", '\u22c7');
        UnescapeChars.addEscChar("&DJcy;", '\u0402');
        UnescapeChars.addEscChar("&djcy;", '\u0452');
        UnescapeChars.addEscChar("&dlarr;", '\u2199');
        UnescapeChars.addEscChar("&dlcorn;", '\u231e');
        UnescapeChars.addEscChar("&dlcrop;", '\u230d');
        UnescapeChars.addEscChar("&dollar;", '$');
        UnescapeChars.addEscChar("&dot;", '\u02d9');
        UnescapeChars.addEscChar("&Dot;", '\u00a8');
        UnescapeChars.addEscChar("&DotDot;", '\u20dc');
        UnescapeChars.addEscChar("&drarr;", '\u2198');
        UnescapeChars.addEscChar("&drcorn;", '\u231f');
        UnescapeChars.addEscChar("&drcrop;", '\u230c');
        UnescapeChars.addEscChar("&DScy;", '\u0405');
        UnescapeChars.addEscChar("&dscy;", '\u0455');
        UnescapeChars.addEscChar("&Dstrok;", '\u0110');
        UnescapeChars.addEscChar("&dstrok;", '\u0111');
        UnescapeChars.addEscChar("&dtri;", '\u25bf');
        UnescapeChars.addEscChar("&dtrif;", '\u25be');
        UnescapeChars.addEscChar("&DZcy;", '\u040f');
        UnescapeChars.addEscChar("&dzcy;", '\u045f');
        UnescapeChars.addEscChar("&Eacgr;", '\u0388');
        UnescapeChars.addEscChar("&eacgr;", '\u03ad');
        UnescapeChars.addEscChar("&Eacute;", '\u00c9');
        UnescapeChars.addEscChar("&eacute;", '\u00e9');
        UnescapeChars.addEscChar("&Ecaron;", '\u011a');
        UnescapeChars.addEscChar("&ecaron;", '\u011b');
        UnescapeChars.addEscChar("&ecir;", '\u2256');
        UnescapeChars.addEscChar("&Ecirc;", '\u00ca');
        UnescapeChars.addEscChar("&ecirc;", '\u00ea');
        UnescapeChars.addEscChar("&ecolon;", '\u2255');
        UnescapeChars.addEscChar("&Ecy;", '\u042d');
        UnescapeChars.addEscChar("&ecy;", '\u044d');
        UnescapeChars.addEscChar("&eDot;", '\u2251');
        UnescapeChars.addEscChar("&Edot;", '\u0116');
        UnescapeChars.addEscChar("&edot;", '\u0117');
        UnescapeChars.addEscChar("&EEacgr;", '\u0389');
        UnescapeChars.addEscChar("&eeacgr;", '\u03ae');
        UnescapeChars.addEscChar("&EEgr;", '\u0397');
        UnescapeChars.addEscChar("&eegr;", '\u03b7');
        UnescapeChars.addEscChar("&efDot;", '\u2252');
        UnescapeChars.addEscChar("&Egr;", '\u0395');
        UnescapeChars.addEscChar("&egr;", '\u03b5');
        UnescapeChars.addEscChar("&Egrave;", '\u00c8');
        UnescapeChars.addEscChar("&egrave;", '\u00e8');
        UnescapeChars.addEscChar("&egs;", '\u22dd');
        UnescapeChars.addEscChar("&ell;", '\u2113');
        UnescapeChars.addEscChar("&els;", '\u22dc');
        UnescapeChars.addEscChar("&Emacr;", '\u0112');
        UnescapeChars.addEscChar("&emacr;", '\u0113');
        UnescapeChars.addEscChar("&empty;", '\u2205');
        UnescapeChars.addEscChar("&emsp;", '\u2003');
        UnescapeChars.addEscChar("&emsp13;", '\u2004');
        UnescapeChars.addEscChar("&emsp14;", '\u2005');
        UnescapeChars.addEscChar("&ENG;", '\u014a');
        UnescapeChars.addEscChar("&eng;", '\u014b');
        UnescapeChars.addEscChar("&ensp;", '\u2002');
        UnescapeChars.addEscChar("&Eogon;", '\u0118');
        UnescapeChars.addEscChar("&eogon;", '\u0119');
        UnescapeChars.addEscChar("&epsi;", '\u03b5');
        UnescapeChars.addEscChar("&Epsilon;", '\u0395');
        UnescapeChars.addEscChar("&epsilon;", '\u03b5');
        UnescapeChars.addEscChar("&epsis;", '\u220a');
        UnescapeChars.addEscChar("&equals;", '=');
        UnescapeChars.addEscChar("&equiv;", '\u2261');
        UnescapeChars.addEscChar("&erDot;", '\u2253');
        UnescapeChars.addEscChar("&esdot;", '\u2250');
        UnescapeChars.addEscChar("&Eta;", '\u0397');
        UnescapeChars.addEscChar("&eta;", '\u03b7');
        UnescapeChars.addEscChar("&ETH;", '\u00d0');
        UnescapeChars.addEscChar("&eth;", '\u00f0');
        UnescapeChars.addEscChar("&Euml;", '\u00cb');
        UnescapeChars.addEscChar("&euml;", '\u00eb');
        UnescapeChars.addEscChar("&excl;", '!');
        UnescapeChars.addEscChar("&exist;", '\u2203');
        UnescapeChars.addEscChar("&Fcy;", '\u0424');
        UnescapeChars.addEscChar("&fcy;", '\u0444');
        UnescapeChars.addEscChar("&female;", '\u2640');
        UnescapeChars.addEscChar("&ffilig;", '\ufb03');
        UnescapeChars.addEscChar("&fflig;", '\ufb00');
        UnescapeChars.addEscChar("&ffllig;", '\ufb04');
        UnescapeChars.addEscChar("&filig;", '\ufb01');
        UnescapeChars.addEscChar("&flat;", '\u266d');
        UnescapeChars.addEscChar("&fllig;", '\ufb02');
        UnescapeChars.addEscChar("&fnof;", '\u0192');
        UnescapeChars.addEscChar("&forall;", '\u2200');
        UnescapeChars.addEscChar("&fork;", '\u22d4');
        UnescapeChars.addEscChar("&frac12;", '\u00bd');
        UnescapeChars.addEscChar("&frac13;", '\u2153');
        UnescapeChars.addEscChar("&frac14;", '\u00bc');
        UnescapeChars.addEscChar("&frac15;", '\u2155');
        UnescapeChars.addEscChar("&frac16;", '\u2159');
        UnescapeChars.addEscChar("&frac18;", '\u215b');
        UnescapeChars.addEscChar("&frac23;", '\u2154');
        UnescapeChars.addEscChar("&frac25;", '\u2156');
        UnescapeChars.addEscChar("&frac34;", '\u00be');
        UnescapeChars.addEscChar("&frac35;", '\u2157');
        UnescapeChars.addEscChar("&frac38;", '\u215c');
        UnescapeChars.addEscChar("&frac45;", '\u2158');
        UnescapeChars.addEscChar("&frac56;", '\u215a');
        UnescapeChars.addEscChar("&frac58;", '\u215d');
        UnescapeChars.addEscChar("&frac78;", '\u215e');
        UnescapeChars.addEscChar("&frasl;", '\u2044');
        UnescapeChars.addEscChar("&frown;", '\u2322');
        UnescapeChars.addEscChar("&gacute;", '\u01f5');
        UnescapeChars.addEscChar("&Gamma;", '\u0393');
        UnescapeChars.addEscChar("&gamma;", '\u03b3');
        UnescapeChars.addEscChar("&gammad;", '\u03dc');
        UnescapeChars.addEscChar("&Gbreve;", '\u011e');
        UnescapeChars.addEscChar("&gbreve;", '\u011f');
        UnescapeChars.addEscChar("&Gcedil;", '\u0122');
        UnescapeChars.addEscChar("&gcedil;", '\u0123');
        UnescapeChars.addEscChar("&Gcirc;", '\u011c');
        UnescapeChars.addEscChar("&gcirc;", '\u011d');
        UnescapeChars.addEscChar("&Gcy;", '\u0413');
        UnescapeChars.addEscChar("&gcy;", '\u0433');
        UnescapeChars.addEscChar("&Gdot;", '\u0120');
        UnescapeChars.addEscChar("&gdot;", '\u0121');
        UnescapeChars.addEscChar("&gE;", '\u2267');
        UnescapeChars.addEscChar("&ge;", '\u2265');
        UnescapeChars.addEscChar("&gel;", '\u22db');
        UnescapeChars.addEscChar("&ges;", '\u2265');
        UnescapeChars.addEscChar("&Gg;", '\u22d9');
        UnescapeChars.addEscChar("&Ggr;", '\u0393');
        UnescapeChars.addEscChar("&ggr;", '\u03b3');
        UnescapeChars.addEscChar("&gimel;", '\u2137');
        UnescapeChars.addEscChar("&GJcy;", '\u0403');
        UnescapeChars.addEscChar("&gjcy;", '\u0453');
        UnescapeChars.addEscChar("&gl;", '\u2277');
        UnescapeChars.addEscChar("&gne;", '\u2269');
        UnescapeChars.addEscChar("&gnE;", '\u2269');
        UnescapeChars.addEscChar("&gnsim;", '\u22e7');
        UnescapeChars.addEscChar("&grave;", '`');
        UnescapeChars.addEscChar("&gsdot;", '\u22d7');
        UnescapeChars.addEscChar("&gsim;", '\u2273');
        UnescapeChars.addEscChar("&Gt;", '\u226b');
        UnescapeChars.addEscChar("&gt;", '>');
        UnescapeChars.addEscChar("&gvnE;", '\u2269');
        UnescapeChars.addEscChar("&hairsp;", '\u200a');
        UnescapeChars.addEscChar("&half;", '\u00bd');
        UnescapeChars.addEscChar("&hamilt;", '\u210b');
        UnescapeChars.addEscChar("&HARDcy;", '\u042a');
        UnescapeChars.addEscChar("&hardcy;", '\u044a');
        UnescapeChars.addEscChar("&harr;", '\u2194');
        UnescapeChars.addEscChar("&hArr;", '\u21d4');
        UnescapeChars.addEscChar("&harrw;", '\u21ad');
        UnescapeChars.addEscChar("&Hcirc;", '\u0124');
        UnescapeChars.addEscChar("&hcirc;", '\u0125');
        UnescapeChars.addEscChar("&hearts;", '\u2665');
        UnescapeChars.addEscChar("&hellip;", '\u2026');
        UnescapeChars.addEscChar("&horbar;", '\u2015');
        UnescapeChars.addEscChar("&Hstrok;", '\u0126');
        UnescapeChars.addEscChar("&hstrok;", '\u0127');
        UnescapeChars.addEscChar("&hybull;", '\u2043');
        UnescapeChars.addEscChar("&hyphen;", '-');
        UnescapeChars.addEscChar("&Iacgr;", '\u038a');
        UnescapeChars.addEscChar("&iacgr;", '\u03af');
        UnescapeChars.addEscChar("&Iacute;", '\u00cd');
        UnescapeChars.addEscChar("&iacute;", '\u00ed');
        UnescapeChars.addEscChar("&Icirc;", '\u00ce');
        UnescapeChars.addEscChar("&icirc;", '\u00ee');
        UnescapeChars.addEscChar("&Icy;", '\u0418');
        UnescapeChars.addEscChar("&icy;", '\u0438');
        UnescapeChars.addEscChar("&idiagr;", '\u0390');
        UnescapeChars.addEscChar("&Idigr;", '\u03aa');
        UnescapeChars.addEscChar("&idigr;", '\u03ca');
        UnescapeChars.addEscChar("&Idot;", '\u0130');
        UnescapeChars.addEscChar("&IEcy;", '\u0415');
        UnescapeChars.addEscChar("&iecy;", '\u0435');
        UnescapeChars.addEscChar("&iexcl;", '\u00a1');
        UnescapeChars.addEscChar("&iff;", '\u21d4');
        UnescapeChars.addEscChar("&Igr;", '\u0399');
        UnescapeChars.addEscChar("&igr;", '\u03b9');
        UnescapeChars.addEscChar("&Igrave;", '\u00cc');
        UnescapeChars.addEscChar("&igrave;", '\u00ec');
        UnescapeChars.addEscChar("&IJlig;", '\u0132');
        UnescapeChars.addEscChar("&ijlig;", '\u0133');
        UnescapeChars.addEscChar("&Imacr;", '\u012a');
        UnescapeChars.addEscChar("&imacr;", '\u012b');
        UnescapeChars.addEscChar("&image;", '\u2111');
        UnescapeChars.addEscChar("&incare;", '\u2105');
        UnescapeChars.addEscChar("&infin;", '\u221e');
        UnescapeChars.addEscChar("&inodot;", '\u0131');
        UnescapeChars.addEscChar("&inodot;", '\u0131');
        UnescapeChars.addEscChar("&int;", '\u222b');
        UnescapeChars.addEscChar("&intcal;", '\u22ba');
        UnescapeChars.addEscChar("&IOcy;", '\u0401');
        UnescapeChars.addEscChar("&iocy;", '\u0451');
        UnescapeChars.addEscChar("&Iogon;", '\u012e');
        UnescapeChars.addEscChar("&iogon;", '\u012f');
        UnescapeChars.addEscChar("&Iota;", '\u0399');
        UnescapeChars.addEscChar("&iota;", '\u03b9');
        UnescapeChars.addEscChar("&iquest;", '\u00bf');
        UnescapeChars.addEscChar("&isin;", '\u2208');
        UnescapeChars.addEscChar("&Itilde;", '\u0128');
        UnescapeChars.addEscChar("&itilde;", '\u0129');
        UnescapeChars.addEscChar("&Iukcy;", '\u0406');
        UnescapeChars.addEscChar("&iukcy;", '\u0456');
        UnescapeChars.addEscChar("&Iuml;", '\u00cf');
        UnescapeChars.addEscChar("&iuml;", '\u00ef');
        UnescapeChars.addEscChar("&Jcirc;", '\u0134');
        UnescapeChars.addEscChar("&jcirc;", '\u0135');
        UnescapeChars.addEscChar("&Jcy;", '\u0419');
        UnescapeChars.addEscChar("&jcy;", '\u0439');
        UnescapeChars.addEscChar("&Jsercy;", '\u0408');
        UnescapeChars.addEscChar("&jsercy;", '\u0458');
        UnescapeChars.addEscChar("&Jukcy;", '\u0404');
        UnescapeChars.addEscChar("&jukcy;", '\u0454');
        UnescapeChars.addEscChar("&Kappa;", '\u039a');
        UnescapeChars.addEscChar("&kappa;", '\u03ba');
        UnescapeChars.addEscChar("&kappav;", '\u03f0');
        UnescapeChars.addEscChar("&Kcedil;", '\u0136');
        UnescapeChars.addEscChar("&kcedil;", '\u0137');
        UnescapeChars.addEscChar("&Kcy;", '\u041a');
        UnescapeChars.addEscChar("&kcy;", '\u043a');
        UnescapeChars.addEscChar("&Kgr;", '\u039a');
        UnescapeChars.addEscChar("&kgr;", '\u03ba');
        UnescapeChars.addEscChar("&kgreen;", '\u0138');
        UnescapeChars.addEscChar("&KHcy;", '\u0425');
        UnescapeChars.addEscChar("&khcy;", '\u0445');
        UnescapeChars.addEscChar("&KHgr;", '\u03a7');
        UnescapeChars.addEscChar("&khgr;", '\u03c7');
        UnescapeChars.addEscChar("&KJcy;", '\u040c');
        UnescapeChars.addEscChar("&kjcy;", '\u045c');
        UnescapeChars.addEscChar("&lAarr;", '\u21da');
        UnescapeChars.addEscChar("&Lacute;", '\u0139');
        UnescapeChars.addEscChar("&lacute;", '\u013a');
        UnescapeChars.addEscChar("&lagran;", '\u2112');
        UnescapeChars.addEscChar("&Lambda;", '\u039b');
        UnescapeChars.addEscChar("&lambda;", '\u03bb');
        UnescapeChars.addEscChar("&lang;", '\u2329');
        UnescapeChars.addEscChar("&laquo;", '\u00ab');
        UnescapeChars.addEscChar("&Larr;", '\u219e');
        UnescapeChars.addEscChar("&larr;", '\u2190');
        UnescapeChars.addEscChar("&lArr;", '\u21d0');
        UnescapeChars.addEscChar("&larr2;", '\u21c7');
        UnescapeChars.addEscChar("&larrhk;", '\u21a9');
        UnescapeChars.addEscChar("&larrlp;", '\u21ab');
        UnescapeChars.addEscChar("&larrtl;", '\u21a2');
        UnescapeChars.addEscChar("&Lcaron;", '\u013d');
        UnescapeChars.addEscChar("&lcaron;", '\u013e');
        UnescapeChars.addEscChar("&Lcedil;", '\u013b');
        UnescapeChars.addEscChar("&lcedil;", '\u013c');
        UnescapeChars.addEscChar("&lceil;", '\u2308');
        UnescapeChars.addEscChar("&lcub;", '{');
        UnescapeChars.addEscChar("&Lcy;", '\u041b');
        UnescapeChars.addEscChar("&lcy;", '\u043b');
        UnescapeChars.addEscChar("&ldot;", '\u22d6');
        UnescapeChars.addEscChar("&ldquo;", '\u201c');
        UnescapeChars.addEscChar("&ldquor;", '\u201e');
        UnescapeChars.addEscChar("&lE;", '\u2266');
        UnescapeChars.addEscChar("&le;", '\u2264');
        UnescapeChars.addEscChar("&leg;", '\u22da');
        UnescapeChars.addEscChar("&les;", '\u2264');
        UnescapeChars.addEscChar("&lfloor;", '\u230a');
        UnescapeChars.addEscChar("&lg;", '\u2276');
        UnescapeChars.addEscChar("&Lgr;", '\u039b');
        UnescapeChars.addEscChar("&lgr;", '\u03bb');
        UnescapeChars.addEscChar("&lhard;", '\u21bd');
        UnescapeChars.addEscChar("&lharu;", '\u21bc');
        UnescapeChars.addEscChar("&lhblk;", '\u2584');
        UnescapeChars.addEscChar("&LJcy;", '\u0409');
        UnescapeChars.addEscChar("&ljcy;", '\u0459');
        UnescapeChars.addEscChar("&Ll;", '\u22d8');
        UnescapeChars.addEscChar("&Lmidot;", '\u013f');
        UnescapeChars.addEscChar("&lmidot;", '\u0140');
        UnescapeChars.addEscChar("&lnE;", '\u2268');
        UnescapeChars.addEscChar("&lne;", '\u2268');
        UnescapeChars.addEscChar("&lnsim;", '\u22e6');
        UnescapeChars.addEscChar("&lowast;", '\u2217');
        UnescapeChars.addEscChar("&lowbar;", '_');
        UnescapeChars.addEscChar("&loz;", '\u25ca');
        UnescapeChars.addEscChar("&loz;", '\u2727');
        UnescapeChars.addEscChar("&lozf;", '\u2726');
        UnescapeChars.addEscChar("&lpar;", '(');
        UnescapeChars.addEscChar("&lrarr2;", '\u21c6');
        UnescapeChars.addEscChar("&lrhar2;", '\u21cb');
        UnescapeChars.addEscChar("&lrm;", '\u200e');
        UnescapeChars.addEscChar("&lsaquo;", '\u2039');
        UnescapeChars.addEscChar("&lsh;", '\u21b0');
        UnescapeChars.addEscChar("&lsim;", '\u2272');
        UnescapeChars.addEscChar("&lsqb;", '[');
        UnescapeChars.addEscChar("&lsquo;", '\u2018');
        UnescapeChars.addEscChar("&lsquor;", '\u201a');
        UnescapeChars.addEscChar("&Lstrok;", '\u0141');
        UnescapeChars.addEscChar("&lstrok;", '\u0142');
        UnescapeChars.addEscChar("&Lt;", '\u226a');
        UnescapeChars.addEscChar("&lt;", '<');
        UnescapeChars.addEscChar("&lthree;", '\u22cb');
        UnescapeChars.addEscChar("&ltimes;", '\u22c9');
        UnescapeChars.addEscChar("&ltri;", '\u25c3');
        UnescapeChars.addEscChar("&ltrie;", '\u22b4');
        UnescapeChars.addEscChar("&ltrif;", '\u25c2');
        UnescapeChars.addEscChar("&lvnE;", '\u2268');
        UnescapeChars.addEscChar("&macr;", '\u00af');
        UnescapeChars.addEscChar("&male;", '\u2642');
        UnescapeChars.addEscChar("&malt;", '\u2720');
        UnescapeChars.addEscChar("&map;", '\u21a6');
        UnescapeChars.addEscChar("&marker;", '\u25ae');
        UnescapeChars.addEscChar("&Mcy;", '\u041c');
        UnescapeChars.addEscChar("&mcy;", '\u043c');
        UnescapeChars.addEscChar("&mdash;", '\u2014');
        UnescapeChars.addEscChar("&Mgr;", '\u039c');
        UnescapeChars.addEscChar("&mgr;", '\u03bc');
        UnescapeChars.addEscChar("&micro;", '\u00b5');
        UnescapeChars.addEscChar("&mid;", '\u2223');
        UnescapeChars.addEscChar("&middot;", '\u00b7');
        UnescapeChars.addEscChar("&minus;", '\u2212');
        UnescapeChars.addEscChar("&minusb;", '\u229f');
        UnescapeChars.addEscChar("&mldr;", '\u2026');
        UnescapeChars.addEscChar("&mnplus;", '\u2213');
        UnescapeChars.addEscChar("&models;", '\u22a7');
        UnescapeChars.addEscChar("&Mu;", '\u039c');
        UnescapeChars.addEscChar("&mu;", '\u03bc');
        UnescapeChars.addEscChar("&mumap;", '\u22b8');
        UnescapeChars.addEscChar("&nabla;", '\u2207');
        UnescapeChars.addEscChar("&Nacute;", '\u0143');
        UnescapeChars.addEscChar("&nacute;", '\u0144');
        UnescapeChars.addEscChar("&nap;", '\u2249');
        UnescapeChars.addEscChar("&napos;", '\u0149');
        UnescapeChars.addEscChar("&natur;", '\u266e');
        UnescapeChars.addEscChar("&nbsp;", '\u00a0');
        UnescapeChars.addEscChar("&Ncaron;", '\u0147');
        UnescapeChars.addEscChar("&ncaron;", '\u0148');
        UnescapeChars.addEscChar("&Ncedil;", '\u0145');
        UnescapeChars.addEscChar("&ncedil;", '\u0146');
        UnescapeChars.addEscChar("&ncong;", '\u2247');
        UnescapeChars.addEscChar("&Ncy;", '\u041d');
        UnescapeChars.addEscChar("&ncy;", '\u043d');
        UnescapeChars.addEscChar("&ndash;", '\u2013');
        UnescapeChars.addEscChar("&ne;", '\u2260');
        UnescapeChars.addEscChar("&nearr;", '\u2197');
        UnescapeChars.addEscChar("&nequiv;", '\u2262');
        UnescapeChars.addEscChar("&nexist;", '\u2204');
        UnescapeChars.addEscChar("&nge;", '\u2271');
        UnescapeChars.addEscChar("&nges;", '\u2271');
        UnescapeChars.addEscChar("&Ngr;", '\u039d');
        UnescapeChars.addEscChar("&ngr;", '\u03bd');
        UnescapeChars.addEscChar("&ngt;", '\u226f');
        UnescapeChars.addEscChar("&nharr;", '\u21ae');
        UnescapeChars.addEscChar("&nhArr;", '\u21ce');
        UnescapeChars.addEscChar("&ni;", '\u220b');
        UnescapeChars.addEscChar("&NJcy;", '\u040a');
        UnescapeChars.addEscChar("&njcy;", '\u045a');
        UnescapeChars.addEscChar("&nlarr;", '\u219a');
        UnescapeChars.addEscChar("&nlArr;", '\u21cd');
        UnescapeChars.addEscChar("&nldr;", '\u2025');
        UnescapeChars.addEscChar("&nle;", '\u2270');
        UnescapeChars.addEscChar("&nles;", '\u2270');
        UnescapeChars.addEscChar("&nlt;", '\u226e');
        UnescapeChars.addEscChar("&nltri;", '\u22ea');
        UnescapeChars.addEscChar("&nltrie;", '\u22ec');
        UnescapeChars.addEscChar("&nmid;", '\u2224');
        UnescapeChars.addEscChar("&not;", '\u00ac');
        UnescapeChars.addEscChar("&notin;", '\u2209');
        UnescapeChars.addEscChar("&npar;", '\u2226');
        UnescapeChars.addEscChar("&npr;", '\u2280');
        UnescapeChars.addEscChar("&npre;", '\u22e0');
        UnescapeChars.addEscChar("&nrarr;", '\u219b');
        UnescapeChars.addEscChar("&nrArr;", '\u21cf');
        UnescapeChars.addEscChar("&nrtri;", '\u22eb');
        UnescapeChars.addEscChar("&nrtrie;", '\u22ed');
        UnescapeChars.addEscChar("&nsc;", '\u2281');
        UnescapeChars.addEscChar("&nsce;", '\u22e1');
        UnescapeChars.addEscChar("&nsim;", '\u2241');
        UnescapeChars.addEscChar("&nsime;", '\u2244');
        UnescapeChars.addEscChar("&nspar;", '\u2226');
        UnescapeChars.addEscChar("&nsub;", '\u2284');
        UnescapeChars.addEscChar("&nsubE;", '\u2288');
        UnescapeChars.addEscChar("&nsube;", '\u2288');
        UnescapeChars.addEscChar("&nsup;", '\u2285');
        UnescapeChars.addEscChar("&nsupE;", '\u2289');
        UnescapeChars.addEscChar("&nsupe;", '\u2289');
        UnescapeChars.addEscChar("&Ntilde;", '\u00d1');
        UnescapeChars.addEscChar("&ntilde;", '\u00f1');
        UnescapeChars.addEscChar("&Nu;", '\u039d');
        UnescapeChars.addEscChar("&nu;", '\u03bd');
        UnescapeChars.addEscChar("&num;", '#');
        UnescapeChars.addEscChar("&numero;", '\u2116');
        UnescapeChars.addEscChar("&numsp;", '\u2007');
        UnescapeChars.addEscChar("&nvdash;", '\u22ac');
        UnescapeChars.addEscChar("&nvDash;", '\u22ad');
        UnescapeChars.addEscChar("&nVdash;", '\u22ae');
        UnescapeChars.addEscChar("&nVDash;", '\u22af');
        UnescapeChars.addEscChar("&nwarr;", '\u2196');
        UnescapeChars.addEscChar("&Oacgr;", '\u038c');
        UnescapeChars.addEscChar("&oacgr;", '\u03cc');
        UnescapeChars.addEscChar("&Oacute;", '\u00d3');
        UnescapeChars.addEscChar("&oacute;", '\u00f3');
        UnescapeChars.addEscChar("&oast;", '\u229b');
        UnescapeChars.addEscChar("&ocir;", '\u229a');
        UnescapeChars.addEscChar("&Ocirc;", '\u00d4');
        UnescapeChars.addEscChar("&ocirc;", '\u00f4');
        UnescapeChars.addEscChar("&Ocy;", '\u041e');
        UnescapeChars.addEscChar("&ocy;", '\u043e');
        UnescapeChars.addEscChar("&odash;", '\u229d');
        UnescapeChars.addEscChar("&Odblac;", '\u0150');
        UnescapeChars.addEscChar("&odblac;", '\u0151');
        UnescapeChars.addEscChar("&odot;", '\u2299');
        UnescapeChars.addEscChar("&OElig;", '\u0152');
        UnescapeChars.addEscChar("&oelig;", '\u0153');
        UnescapeChars.addEscChar("&ogon;", '\u02db');
        UnescapeChars.addEscChar("&Ogr;", '\u039f');
        UnescapeChars.addEscChar("&ogr;", '\u03bf');
        UnescapeChars.addEscChar("&Ograve;", '\u00d2');
        UnescapeChars.addEscChar("&ograve;", '\u00f2');
        UnescapeChars.addEscChar("&OHacgr;", '\u038f');
        UnescapeChars.addEscChar("&ohacgr;", '\u03ce');
        UnescapeChars.addEscChar("&OHgr;", '\u03a9');
        UnescapeChars.addEscChar("&ohgr;", '\u03c9');
        UnescapeChars.addEscChar("&ohm;", '\u2126');
        UnescapeChars.addEscChar("&olarr;", '\u21ba');
        UnescapeChars.addEscChar("&oline;", '\u203e');
        UnescapeChars.addEscChar("&Omacr;", '\u014c');
        UnescapeChars.addEscChar("&omacr;", '\u014d');
        UnescapeChars.addEscChar("&Omega;", '\u03a9');
        UnescapeChars.addEscChar("&omega;", '\u03c9');
        UnescapeChars.addEscChar("&Omicron;", '\u039f');
        UnescapeChars.addEscChar("&omicron;", '\u03bf');
        UnescapeChars.addEscChar("&ominus;", '\u2296');
        UnescapeChars.addEscChar("&oplus;", '\u2295');
        UnescapeChars.addEscChar("&or;", '\u2228');
        UnescapeChars.addEscChar("&orarr;", '\u21bb');
        UnescapeChars.addEscChar("&order;", '\u2134');
        UnescapeChars.addEscChar("&ordf;", '\u00aa');
        UnescapeChars.addEscChar("&ordm;", '\u00ba');
        UnescapeChars.addEscChar("&oS;", '\u24c8');
        UnescapeChars.addEscChar("&Oslash;", '\u00d8');
        UnescapeChars.addEscChar("&oslash;", '\u00f8');
        UnescapeChars.addEscChar("&osol;", '\u2298');
        UnescapeChars.addEscChar("&Otilde;", '\u00d5');
        UnescapeChars.addEscChar("&otilde;", '\u00f5');
        UnescapeChars.addEscChar("&otimes;", '\u2297');
        UnescapeChars.addEscChar("&Ouml;", '\u00d6');
        UnescapeChars.addEscChar("&ouml;", '\u00f6');
        UnescapeChars.addEscChar("&par;", '\u2225');
        UnescapeChars.addEscChar("&para;", '\u00b6');
        UnescapeChars.addEscChar("&part;", '\u2202');
        UnescapeChars.addEscChar("&Pcy;", '\u041f');
        UnescapeChars.addEscChar("&pcy;", '\u043f');
        UnescapeChars.addEscChar("&percnt;", '%');
        UnescapeChars.addEscChar("&period;", '.');
        UnescapeChars.addEscChar("&permil;", '\u2030');
        UnescapeChars.addEscChar("&perp;", '\u22a5');
        UnescapeChars.addEscChar("&Pgr;", '\u03a0');
        UnescapeChars.addEscChar("&pgr;", '\u03c0');
        UnescapeChars.addEscChar("&PHgr;", '\u03a6');
        UnescapeChars.addEscChar("&phgr;", '\u03c6');
        UnescapeChars.addEscChar("&phi;", '\u03c6');
        UnescapeChars.addEscChar("&Phi;", '\u03a6');
        UnescapeChars.addEscChar("&phis;", '\u03c6');
        UnescapeChars.addEscChar("&phiv;", '\u03d5');
        UnescapeChars.addEscChar("&phmmat;", '\u2133');
        UnescapeChars.addEscChar("&phone;", '\u260e');
        UnescapeChars.addEscChar("&Pi;", '\u03a0');
        UnescapeChars.addEscChar("&pi;", '\u03c0');
        UnescapeChars.addEscChar("&piv;", '\u03d6');
        UnescapeChars.addEscChar("&planck;", '\u210f');
        UnescapeChars.addEscChar("&plus;", '+');
        UnescapeChars.addEscChar("&plusb;", '\u229e');
        UnescapeChars.addEscChar("&plusdo;", '\u2214');
        UnescapeChars.addEscChar("&plusmn;", '\u00b1');
        UnescapeChars.addEscChar("&pound;", '\u00a3');
        UnescapeChars.addEscChar("&pr;", '\u227a');
        UnescapeChars.addEscChar("&pre;", '\u227c');
        UnescapeChars.addEscChar("&prime;", '\u2032');
        UnescapeChars.addEscChar("&Prime;", '\u2033');
        UnescapeChars.addEscChar("&prnsim;", '\u22e8');
        UnescapeChars.addEscChar("&prod;", '\u220f');
        UnescapeChars.addEscChar("&prop;", '\u221d');
        UnescapeChars.addEscChar("&prsim;", '\u227e');
        UnescapeChars.addEscChar("&PSgr;", '\u03a8');
        UnescapeChars.addEscChar("&psgr;", '\u03c8');
        UnescapeChars.addEscChar("&Psi;", '\u03a8');
        UnescapeChars.addEscChar("&psi;", '\u03c8');
        UnescapeChars.addEscChar("&puncsp;", '\u2008');
        UnescapeChars.addEscChar("&quest;", '?');
        UnescapeChars.addEscChar("&quot;", '\"');
        UnescapeChars.addEscChar("&rAarr;", '\u21db');
        UnescapeChars.addEscChar("&Racute;", '\u0154');
        UnescapeChars.addEscChar("&racute;", '\u0155');
        UnescapeChars.addEscChar("&radic;", '\u221a');
        UnescapeChars.addEscChar("&rang;", '\u232a');
        UnescapeChars.addEscChar("&raquo;", '\u00bb');
        UnescapeChars.addEscChar("&Rarr;", '\u21a0');
        UnescapeChars.addEscChar("&rarr;", '\u2192');
        UnescapeChars.addEscChar("&rArr;", '\u21d2');
        UnescapeChars.addEscChar("&rarr2;", '\u21c9');
        UnescapeChars.addEscChar("&rarrhk;", '\u21aa');
        UnescapeChars.addEscChar("&rarrlp;", '\u21ac');
        UnescapeChars.addEscChar("&rarrtl;", '\u21a3');
        UnescapeChars.addEscChar("&rarrw;", '\u219d');
        UnescapeChars.addEscChar("&Rcaron;", '\u0158');
        UnescapeChars.addEscChar("&rcaron;", '\u0159');
        UnescapeChars.addEscChar("&Rcedil;", '\u0156');
        UnescapeChars.addEscChar("&rcedil;", '\u0157');
        UnescapeChars.addEscChar("&rceil;", '\u2309');
        UnescapeChars.addEscChar("&rcub;", '}');
        UnescapeChars.addEscChar("&Rcy;", '\u0420');
        UnescapeChars.addEscChar("&rcy;", '\u0440');
        UnescapeChars.addEscChar("&rdquo;", '\u201d');
        UnescapeChars.addEscChar("&rdquor;", '\u201c');
        UnescapeChars.addEscChar("&real;", '\u211c');
        UnescapeChars.addEscChar("&rect;", '\u25ad');
        UnescapeChars.addEscChar("&reg;", '\u00ae');
        UnescapeChars.addEscChar("&rfloor;", '\u230b');
        UnescapeChars.addEscChar("&Rgr;", '\u03a1');
        UnescapeChars.addEscChar("&rgr;", '\u03c1');
        UnescapeChars.addEscChar("&rhard;", '\u21c1');
        UnescapeChars.addEscChar("&rharu;", '\u21c0');
        UnescapeChars.addEscChar("&Rho;", '\u03a1');
        UnescapeChars.addEscChar("&rho;", '\u03c1');
        UnescapeChars.addEscChar("&rhov;", '\u03f1');
        UnescapeChars.addEscChar("&ring;", '\u02da');
        UnescapeChars.addEscChar("&rlarr2;", '\u21c4');
        UnescapeChars.addEscChar("&rlhar2;", '\u21cc');
        UnescapeChars.addEscChar("&rlm;", '\u200f');
        UnescapeChars.addEscChar("&rpar;", ')');
        UnescapeChars.addEscChar("&rsaquo;", '\u203a');
        UnescapeChars.addEscChar("&rsh;", '\u21b1');
        UnescapeChars.addEscChar("&rsqb;", ']');
        UnescapeChars.addEscChar("&rsquo;", '\u2019');
        UnescapeChars.addEscChar("&rsquor;", '\u2018');
        UnescapeChars.addEscChar("&rthree;", '\u22cc');
        UnescapeChars.addEscChar("&rtimes;", '\u22ca');
        UnescapeChars.addEscChar("&rtri;", '\u25b9');
        UnescapeChars.addEscChar("&rtrie;", '\u22b5');
        UnescapeChars.addEscChar("&rtrif;", '\u25b8');
        UnescapeChars.addEscChar("&rx;", '\u211e');
        UnescapeChars.addEscChar("&Sacute;", '\u015a');
        UnescapeChars.addEscChar("&sacute;", '\u015b');
        UnescapeChars.addEscChar("&samalg;", '\u2210');
        UnescapeChars.addEscChar("&sbquo;", '\u201a');
        UnescapeChars.addEscChar("&sc;", '\u227b');
        UnescapeChars.addEscChar("&Scaron;", '\u0160');
        UnescapeChars.addEscChar("&scaron;", '\u0161');
        UnescapeChars.addEscChar("&sccue;", '\u227d');
        UnescapeChars.addEscChar("&sce;", '\u227d');
        UnescapeChars.addEscChar("&Scedil;", '\u015e');
        UnescapeChars.addEscChar("&scedil;", '\u015f');
        UnescapeChars.addEscChar("&Scirc;", '\u015c');
        UnescapeChars.addEscChar("&scirc;", '\u015d');
        UnescapeChars.addEscChar("&scnsim;", '\u22e9');
        UnescapeChars.addEscChar("&scsim;", '\u227f');
        UnescapeChars.addEscChar("&Scy;", '\u0421');
        UnescapeChars.addEscChar("&scy;", '\u0441');
        UnescapeChars.addEscChar("&sdot;", '\u22c5');
        UnescapeChars.addEscChar("&sdotb;", '\u22a1');
        UnescapeChars.addEscChar("&sect;", '\u00a7');
        UnescapeChars.addEscChar("&semi;", ';');
        UnescapeChars.addEscChar("&setmn;", '\u2216');
        UnescapeChars.addEscChar("&sext;", '\u2736');
        UnescapeChars.addEscChar("&sfgr;", '\u03c2');
        UnescapeChars.addEscChar("&sfrown;", '\u2322');
        UnescapeChars.addEscChar("&Sgr;", '\u03a3');
        UnescapeChars.addEscChar("&sgr;", '\u03c3');
        UnescapeChars.addEscChar("&sharp;", '\u266f');
        UnescapeChars.addEscChar("&SHCHcy;", '\u0429');
        UnescapeChars.addEscChar("&shchcy;", '\u0449');
        UnescapeChars.addEscChar("&SHcy;", '\u0428');
        UnescapeChars.addEscChar("&shcy;", '\u0448');
        UnescapeChars.addEscChar("&shy;", '\u00ad');
        UnescapeChars.addEscChar("&Sigma;", '\u03a3');
        UnescapeChars.addEscChar("&sigma;", '\u03c3');
        UnescapeChars.addEscChar("&sigmaf;", '\u03c2');
        UnescapeChars.addEscChar("&sigmav;", '\u03c2');
        UnescapeChars.addEscChar("&sim;", '\u223c');
        UnescapeChars.addEscChar("&sime;", '\u2243');
        UnescapeChars.addEscChar("&smile;", '\u2323');
        UnescapeChars.addEscChar("&SOFTcy;", '\u042c');
        UnescapeChars.addEscChar("&softcy;", '\u044c');
        UnescapeChars.addEscChar("&sol;", '/');
        UnescapeChars.addEscChar("&spades;", '\u2660');
        UnescapeChars.addEscChar("&spar;", '\u2225');
        UnescapeChars.addEscChar("&sqcap;", '\u2293');
        UnescapeChars.addEscChar("&sqcup;", '\u2294');
        UnescapeChars.addEscChar("&sqsub;", '\u228f');
        UnescapeChars.addEscChar("&sqsube;", '\u2291');
        UnescapeChars.addEscChar("&sqsup;", '\u2290');
        UnescapeChars.addEscChar("&sqsupe;", '\u2292');
        UnescapeChars.addEscChar("&squ;", '\u25a1');
        UnescapeChars.addEscChar("&square;", '\u25a1');
        UnescapeChars.addEscChar("&squf;", '\u25aa');
        UnescapeChars.addEscChar("&ssetmn;", '\u2216');
        UnescapeChars.addEscChar("&ssmile;", '\u2323');
        UnescapeChars.addEscChar("&sstarf;", '\u22c6');
        UnescapeChars.addEscChar("&star;", '\u2606');
        UnescapeChars.addEscChar("&starf;", '\u2605');
        UnescapeChars.addEscChar("&Sub;", '\u22d0');
        UnescapeChars.addEscChar("&sub;", '\u2282');
        UnescapeChars.addEscChar("&subE;", '\u2286');
        UnescapeChars.addEscChar("&sube;", '\u2286');
        UnescapeChars.addEscChar("&subnE;", '\u228a');
        UnescapeChars.addEscChar("&subne;", '\u228a');
        UnescapeChars.addEscChar("&sum;", '\u2211');
        UnescapeChars.addEscChar("&sung;", '\u266a');
        UnescapeChars.addEscChar("&Sup;", '\u22d1');
        UnescapeChars.addEscChar("&sup;", '\u2283');
        UnescapeChars.addEscChar("&sup1;", '\u00b9');
        UnescapeChars.addEscChar("&sup2;", '\u00b2');
        UnescapeChars.addEscChar("&sup3;", '\u00b3');
        UnescapeChars.addEscChar("&supE;", '\u2287');
        UnescapeChars.addEscChar("&supe;", '\u2287');
        UnescapeChars.addEscChar("&supnE;", '\u228b');
        UnescapeChars.addEscChar("&supne;", '\u228b');
        UnescapeChars.addEscChar("&szlig;", '\u00df');
        UnescapeChars.addEscChar("&target;", '\u2316');
        UnescapeChars.addEscChar("&Tau;", '\u03a4');
        UnescapeChars.addEscChar("&tau;", '\u03c4');
        UnescapeChars.addEscChar("&Tcaron;", '\u0164');
        UnescapeChars.addEscChar("&tcaron;", '\u0165');
        UnescapeChars.addEscChar("&Tcedil;", '\u0162');
        UnescapeChars.addEscChar("&tcedil;", '\u0163');
        UnescapeChars.addEscChar("&Tcy;", '\u0422');
        UnescapeChars.addEscChar("&tcy;", '\u0442');
        UnescapeChars.addEscChar("&tdot;", '\u20db');
        UnescapeChars.addEscChar("&telrec;", '\u2315');
        UnescapeChars.addEscChar("&Tgr;", '\u03a4');
        UnescapeChars.addEscChar("&tgr;", '\u03c4');
        UnescapeChars.addEscChar("&there4;", '\u2234');
        UnescapeChars.addEscChar("&theta;", '\u03b8');
        UnescapeChars.addEscChar("&Theta;", '\u0398');
        UnescapeChars.addEscChar("&thetas;", '\u03b8');
        UnescapeChars.addEscChar("&thetasym;", '\u03d1');
        UnescapeChars.addEscChar("&thetav;", '\u03d1');
        UnescapeChars.addEscChar("&THgr;", '\u0398');
        UnescapeChars.addEscChar("&thgr;", '\u03b8');
        UnescapeChars.addEscChar("&thinsp;", '\u2009');
        UnescapeChars.addEscChar("&thkap;", '\u2248');
        UnescapeChars.addEscChar("&thksim;", '\u223c');
        UnescapeChars.addEscChar("&THORN;", '\u00de');
        UnescapeChars.addEscChar("&thorn;", '\u00fe');
        UnescapeChars.addEscChar("&tilde;", '\u02dc');
        UnescapeChars.addEscChar("&times;", '\u00d7');
        UnescapeChars.addEscChar("&timesb;", '\u22a0');
        UnescapeChars.addEscChar("&top;", '\u22a4');
        UnescapeChars.addEscChar("&tprime;", '\u2034');
        UnescapeChars.addEscChar("&trade;", '\u2122');
        UnescapeChars.addEscChar("&trie;", '\u225c');
        UnescapeChars.addEscChar("&TScy;", '\u0426');
        UnescapeChars.addEscChar("&tscy;", '\u0446');
        UnescapeChars.addEscChar("&TSHcy;", '\u040b');
        UnescapeChars.addEscChar("&tshcy;", '\u045b');
        UnescapeChars.addEscChar("&Tstrok;", '\u0166');
        UnescapeChars.addEscChar("&tstrok;", '\u0167');
        UnescapeChars.addEscChar("&twixt;", '\u226c');
        UnescapeChars.addEscChar("&Uacgr;", '\u038e');
        UnescapeChars.addEscChar("&uacgr;", '\u03cd');
        UnescapeChars.addEscChar("&Uacute;", '\u00da');
        UnescapeChars.addEscChar("&uacute;", '\u00fa');
        UnescapeChars.addEscChar("&uArr;", '\u21d1');
        UnescapeChars.addEscChar("&uarr;", '\u2191');
        UnescapeChars.addEscChar("&uarr2;", '\u21c8');
        UnescapeChars.addEscChar("&Ubrcy;", '\u040e');
        UnescapeChars.addEscChar("&ubrcy;", '\u045e');
        UnescapeChars.addEscChar("&Ubreve;", '\u016c');
        UnescapeChars.addEscChar("&ubreve;", '\u016d');
        UnescapeChars.addEscChar("&Ucirc;", '\u00db');
        UnescapeChars.addEscChar("&ucirc;", '\u00fb');
        UnescapeChars.addEscChar("&Ucy;", '\u0423');
        UnescapeChars.addEscChar("&ucy;", '\u0443');
        UnescapeChars.addEscChar("&Udblac;", '\u0170');
        UnescapeChars.addEscChar("&udblac;", '\u0171');
        UnescapeChars.addEscChar("&udiagr;", '\u03b0');
        UnescapeChars.addEscChar("&Udigr;", '\u03ab');
        UnescapeChars.addEscChar("&udigr;", '\u03cb');
        UnescapeChars.addEscChar("&Ugr;", '\u03a5');
        UnescapeChars.addEscChar("&ugr;", '\u03c5');
        UnescapeChars.addEscChar("&Ugrave;", '\u00d9');
        UnescapeChars.addEscChar("&ugrave;", '\u00f9');
        UnescapeChars.addEscChar("&uharl;", '\u21bf');
        UnescapeChars.addEscChar("&uharr;", '\u21be');
        UnescapeChars.addEscChar("&uhblk;", '\u2580');
        UnescapeChars.addEscChar("&ulcorn;", '\u231c');
        UnescapeChars.addEscChar("&ulcrop;", '\u230f');
        UnescapeChars.addEscChar("&Umacr;", '\u016a');
        UnescapeChars.addEscChar("&umacr;", '\u016b');
        UnescapeChars.addEscChar("&uml;", '\u00a8');
        UnescapeChars.addEscChar("&Uogon;", '\u0172');
        UnescapeChars.addEscChar("&uogon;", '\u0173');
        UnescapeChars.addEscChar("&uplus;", '\u228e');
        UnescapeChars.addEscChar("&Upsi;", '\u03a5');
        UnescapeChars.addEscChar("&upsi;", '\u03c5');
        UnescapeChars.addEscChar("&upsih;", '\u03d2');
        UnescapeChars.addEscChar("&Upsilon;", '\u03a5');
        UnescapeChars.addEscChar("&upsilon;", '\u03c5');
        UnescapeChars.addEscChar("&urcorn;", '\u231d');
        UnescapeChars.addEscChar("&urcrop;", '\u230e');
        UnescapeChars.addEscChar("&Uring;", '\u016e');
        UnescapeChars.addEscChar("&uring;", '\u016f');
        UnescapeChars.addEscChar("&Utilde;", '\u0168');
        UnescapeChars.addEscChar("&utilde;", '\u0169');
        UnescapeChars.addEscChar("&utri;", '\u25b5');
        UnescapeChars.addEscChar("&utrif;", '\u25b4');
        UnescapeChars.addEscChar("&Uuml;", '\u00dc');
        UnescapeChars.addEscChar("&uuml;", '\u00fc');
        UnescapeChars.addEscChar("&varr;", '\u2195');
        UnescapeChars.addEscChar("&vArr;", '\u21d5');
        UnescapeChars.addEscChar("&Vcy;", '\u0412');
        UnescapeChars.addEscChar("&vcy;", '\u0432');
        UnescapeChars.addEscChar("&vdash;", '\u22a2');
        UnescapeChars.addEscChar("&vDash;", '\u22a8');
        UnescapeChars.addEscChar("&Vdash;", '\u22a9');
        UnescapeChars.addEscChar("&veebar;", '\u22bb');
        UnescapeChars.addEscChar("&vellip;", '\u22ee');
        UnescapeChars.addEscChar("&verbar;", '|');
        UnescapeChars.addEscChar("&Verbar;", '\u2016');
        UnescapeChars.addEscChar("&vltri;", '\u22b2');
        UnescapeChars.addEscChar("&vprime;", '\u2032');
        UnescapeChars.addEscChar("&vprop;", '\u221d');
        UnescapeChars.addEscChar("&vrtri;", '\u22b3');
        UnescapeChars.addEscChar("&vsubnE;", '\u228a');
        UnescapeChars.addEscChar("&vsubne;", '\u228a');
        UnescapeChars.addEscChar("&vsupne;", '\u228b');
        UnescapeChars.addEscChar("&vsupnE;", '\u228b');
        UnescapeChars.addEscChar("&Vvdash;", '\u22aa');
        UnescapeChars.addEscChar("&Wcirc;", '\u0174');
        UnescapeChars.addEscChar("&wcirc;", '\u0175');
        UnescapeChars.addEscChar("&wedgeq;", '\u2259');
        UnescapeChars.addEscChar("&weierp;", '\u2118');
        UnescapeChars.addEscChar("&wreath;", '\u2240');
        UnescapeChars.addEscChar("&xcirc;", '\u25cb');
        UnescapeChars.addEscChar("&xdtri;", '\u25bd');
        UnescapeChars.addEscChar("&Xgr;", '\u039e');
        UnescapeChars.addEscChar("&xgr;", '\u03be');
        UnescapeChars.addEscChar("&xhArr;", '\u2194');
        UnescapeChars.addEscChar("&xharr;", '\u2194');
        UnescapeChars.addEscChar("&Xi;", '\u039e');
        UnescapeChars.addEscChar("&xi;", '\u03be');
        UnescapeChars.addEscChar("&xlArr;", '\u21d0');
        UnescapeChars.addEscChar("&xrArr;", '\u21d2');
        UnescapeChars.addEscChar("&xutri;", '\u25b3');
        UnescapeChars.addEscChar("&Yacute;", '\u00dd');
        UnescapeChars.addEscChar("&yacute;", '\u00fd');
        UnescapeChars.addEscChar("&YAcy;", '\u042f');
        UnescapeChars.addEscChar("&yacy;", '\u044f');
        UnescapeChars.addEscChar("&Ycirc;", '\u0176');
        UnescapeChars.addEscChar("&ycirc;", '\u0177');
        UnescapeChars.addEscChar("&Ycy;", '\u042b');
        UnescapeChars.addEscChar("&ycy;", '\u044b');
        UnescapeChars.addEscChar("&yen;", '\u00a5');
        UnescapeChars.addEscChar("&YIcy;", '\u0407');
        UnescapeChars.addEscChar("&yicy;", '\u0457');
        UnescapeChars.addEscChar("&YUcy;", '\u042e');
        UnescapeChars.addEscChar("&yucy;", '\u044e');
        UnescapeChars.addEscChar("&yuml;", '\u00ff');
        UnescapeChars.addEscChar("&Yuml;", '\u0178');
        UnescapeChars.addEscChar("&Zacute;", '\u0179');
        UnescapeChars.addEscChar("&zacute;", '\u017a');
        UnescapeChars.addEscChar("&Zcaron;", '\u017d');
        UnescapeChars.addEscChar("&zcaron;", '\u017e');
        UnescapeChars.addEscChar("&Zcy;", '\u0417');
        UnescapeChars.addEscChar("&zcy;", '\u0437');
        UnescapeChars.addEscChar("&Zdot;", '\u017b');
        UnescapeChars.addEscChar("&zdot;", '\u017c');
        UnescapeChars.addEscChar("&Zeta;", '\u0396');
        UnescapeChars.addEscChar("&zeta;", '\u03b6');
        UnescapeChars.addEscChar("&Zgr;", '\u0396');
        UnescapeChars.addEscChar("&zgr;", '\u03b6');
        UnescapeChars.addEscChar("&ZHcy;", '\u0416');
        UnescapeChars.addEscChar("&zhcy;", '\u0436');
        UnescapeChars.addEscChar("&zwj;", '\u200d');
        UnescapeChars.addEscChar("&zwnj;", '\u200c');
        ESCAPE = Pattern.compile(ESCAPE_REGEXP);
        CODE = Pattern.compile(CODE_REGEXP);
    }
}

