/*
 * Decompiled with CFR 0.152.
 */
package zephyr.kenkyusya.lajp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import zephyr.util.UTF8toSJIS;
import zephyr.util.UnescapeChars;
import zephyr.util.ZephyrUtil;

public class CheckLaJpBody {
    private final HashMap<String, FixEntry> fixMap = new HashMap();
    private final LinkedList<EsEntry> esEntries = new LinkedList();
    private static final String HEXCODE_REGEXP = "(0[0-9A-F]{3}|762D)";
    private static final Pattern HEXCODE = Pattern.compile("(0[0-9A-F]{3}|762D)");
    private static final String WORD_REGEXP = "([a-zA-Z\u0100\u0112\u012a\u014c\u016a]+)";
    private static final Pattern WORD = Pattern.compile("([a-zA-Z\u0100\u0112\u012a\u014c\u016a]+)");
    private int nFixed = 0;
    private static final HashMap<Character, String> extCharsMap = new HashMap();

    private void loadLaJpFix(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = string2.split("\t");
            if (stringArray.length == 3) {
                this.fixMap.put(stringArray[0], new FixEntry(stringArray[1], stringArray[2]));
                continue;
            }
            if (stringArray.length == 2) {
                this.fixMap.put(stringArray[0], new FixEntry(stringArray[0], stringArray[1]));
                continue;
            }
            System.err.println("invalid lajpfix line: " + string2);
        }
        System.err.println("loaded " + this.fixMap.size() + " fix entries");
    }

    private String toUnicode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Matcher matcher = HEXCODE.matcher(string);
        while (matcher.find()) {
            if (n < matcher.start()) {
                stringBuffer.append(string.substring(n, matcher.start()));
            }
            int n2 = Integer.parseInt(matcher.group(1), 16);
            char c = Character.toUpperCase((char)n2);
            stringBuffer.append(c);
            n = matcher.end();
        }
        if (n < string.length()) {
            stringBuffer.append(string.substring(n));
        }
        return stringBuffer.toString();
    }

    private void loadEsbody(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        boolean bl = true;
        EsEntry esEntry = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            if (string2.equals("======")) {
                bl = true;
                continue;
            }
            string2 = this.toUnicode(string2);
            if (bl) {
                esEntry = new EsEntry(string2);
                this.esEntries.add(esEntry);
                bl = false;
                continue;
            }
            esEntry.lines.add(string2);
        }
        System.err.println("loaded " + this.esEntries.size() + " entries");
    }

    private String compare(String string, String string2, String string3) {
        String string4 = string2.toUpperCase();
        if (string4.equals(string3)) {
            return string2;
        }
        for (int i = 0; i < "\uff08\uff09\uff3b\uff3d\u300a\u300b\u3008\u3009\uff0b\uff5e\u2019\u300c\u300d".length(); ++i) {
            string4 = string4.replace("\uff08\uff09\uff3b\uff3d\u300a\u300b\u3008\u3009\uff0b\uff5e\u2019\u300c\u300d".substring(i, i + 1), "");
        }
        String[][] stringArrayArray = new String[][]{{"\u00c1", "AACUTE"}, {"\u00c2", "ACIRC"}, {"\u00c7", "CCEDIL"}, {"\u00c9", "EACUTE"}, {"\u00c8", "EGRAVE"}, {"\u00cb", "EUML"}, {"\u00cd", "IACUTE"}, {"\u00ce", "ICIRC"}, {"\u00d1", "NTILDE"}, {"\u00d3", "OACUTE"}, {"\u00d6", "OUML"}, {"\u00d4", "OCIRC"}, {"\u00da", "UACUTE"}, {"\u00dc", "UUML"}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            string4 = string4.replace(stringArrayArray[i][0], stringArrayArray[i][1]);
        }
        Matcher matcher = WORD.matcher(string4);
        Matcher matcher2 = WORD.matcher(string3);
        String string5 = null;
        int n = 0;
        while (matcher.find()) {
            String string6;
            if (!matcher2.find()) {
                System.err.println("ERR: dt=" + string + "\n\tkline=" + string2 + "\n\teline=" + string3);
                this.invalidEntry(string);
                break;
            }
            String string7 = matcher.group(1);
            if (string7.equals(string6 = matcher2.group(1))) continue;
            String string8 = this.makeFixedWord(string2, string7, string6);
            if (string8 == null) {
                System.err.println("WARN: dt=" + string + "\n\tkline=" + string2 + "\n\teline=" + string3);
                this.invalidEntry(string);
            } else if (n == 0) {
                string5 = string8;
            }
            ++n;
        }
        if (n == 1) {
            return string5;
        }
        return null;
    }

    private String keyForEstraier(String string) {
        String[][] stringArrayArray = new String[][]{{"\uff0e", "."}, {"\u300a", ""}, {"\u300b", ""}, {"\uff0a", "*"}, {"\u00cf", "IUML"}, {"\uff3b", ""}, {"\uff3d", ""}};
        string = string.toUpperCase();
        for (int i = 0; i < stringArrayArray.length; ++i) {
            string = string.replace(stringArrayArray[i][0], stringArrayArray[i][1]);
        }
        return string;
    }

    private String fixedKeyByEs(String string, String string2) {
        if (string.length() == string2.length() - 1) {
            int n = 0;
            int n2 = -1;
            char c = '\u0000';
            block3: for (int i = 0; i < string.length(); ++i) {
                char c2;
                char c3 = string.charAt(i - n);
                if (c3 == (c2 = string2.charAt(i))) continue;
                switch (c2) {
                    case 'E': 
                    case 'I': 
                    case 'O': 
                    case 'U': 
                    case 'Y': {
                        if (n2 < 0) {
                            n2 = i;
                            n = 1;
                            c = c2;
                            continue block3;
                        }
                        return string;
                    }
                    default: {
                        return string;
                    }
                }
            }
            if (n2 >= 0) {
                ++this.nFixed;
                return string.substring(0, n2) + c + string.substring(n2);
            }
            return string2;
        }
        return string;
    }

    private String makeFixedWord(String string, String string2, String string3) {
        char c;
        char c2;
        int n;
        if (string2.length() != string3.length() - 1) {
            return null;
        }
        for (n = 0; n < string2.length() && (c2 = string2.charAt(n)) == (c = string3.charAt(n)); ++n) {
        }
        String string4 = extCharsMap.get(Character.valueOf(string3.charAt(n)));
        if (string4 == null) {
            return null;
        }
        String string5 = string.toUpperCase();
        int n2 = string5.indexOf(string2);
        if (n2 >= 0) {
            ++this.nFixed;
            int n3 = n2 + n;
            if (n3 < string.length()) {
                return string.substring(0, n3) + string4 + string.substring(n3);
            }
            return string.substring(0, n3) + string4;
        }
        return null;
    }

    private void invalidEntry(String string) {
        System.err.println();
        System.err.println("*********************");
        String string2 = UnescapeChars.unescapeCode(UTF8toSJIS.convert(string));
        System.err.println("ERROR: headword=" + string + "\t" + string2);
        System.exit(1);
    }

    private void loadLaJpBody(String string) throws Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        int n = 0;
        EsEntry esEntry = null;
        String string3 = "";
        FixEntry fixEntry = null;
        System.err.print("fixing Latin-Japanese entries ");
        while ((string2 = bufferedReader.readLine()) != null) {
            String string4;
            String string5;
            boolean bl;
            if (string2.equals("======")) {
                System.out.println(string2);
                continue;
            }
            String string6 = string2.trim();
            if (string6.isEmpty()) continue;
            if (string6.equals("\uff3b\u2191\uff3d") || string6.equals("\uff3b\u2193\uff3d")) {
                System.out.println(string2);
                continue;
            }
            if (string2.charAt(0) != ' ') {
                fixEntry = this.fixMap.get(string6);
                bl = false;
                if (fixEntry != null && !(string5 = string6.replace(fixEntry.before, fixEntry.after)).equals(string6)) {
                    System.out.println(string5);
                    bl = true;
                }
                string3 = string6;
                esEntry = this.esEntries.get(n);
                if (!bl) {
                    string5 = this.keyForEstraier(string6);
                    if (!string5.equals(esEntry.dt)) {
                        string4 = this.fixedKeyByEs(string5, esEntry.dt);
                        if (!string4.equals(esEntry.dt)) {
                            this.invalidEntry(string3);
                        } else {
                            string3 = this.makeFixedWord(string3, string5, esEntry.dt);
                        }
                    }
                    System.out.println(string3);
                }
                if (++n % 1000 != 0) continue;
                System.err.print(".");
                continue;
            }
            bl = false;
            if (fixEntry != null && !(string5 = string2.replace(fixEntry.before, fixEntry.after)).equals(string2)) {
                System.out.println(string5);
                bl = true;
            }
            string5 = esEntry.lines.poll();
            if (bl) continue;
            if (string5 != null) {
                string4 = this.compare(string3, string2, string5);
                if (string4 != null && string4 != string2) {
                    string2 = string4;
                }
            } else {
                System.err.println("ERROR: cannot get esBodyLines for " + esEntry.dt);
                System.err.println("\t" + string2);
            }
            System.out.println(string2);
        }
        System.err.println();
        System.err.println("done. " + n + " entries. " + this.nFixed + " fixed.");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length >= 3) {
            ZephyrUtil.setUTF8Ouput();
            CheckLaJpBody checkLaJpBody = new CheckLaJpBody();
            try {
                checkLaJpBody.loadLaJpFix(stringArray[2]);
                checkLaJpBody.loadEsbody(stringArray[1]);
                checkLaJpBody.loadLaJpBody(stringArray[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("Usage: java CheckLaJpBody kenkyusya-lajp.txt esloader.txt lajpfix.txt");
        }
    }

    static {
        extCharsMap.put(Character.valueOf('Y'), "\u0233");
        extCharsMap.put(Character.valueOf('I'), "\u012b\u02d8");
        extCharsMap.put(Character.valueOf('E'), "\u0113\u02d8");
        extCharsMap.put(Character.valueOf('O'), "\u014d\u02d8");
        extCharsMap.put(Character.valueOf('U'), "\u016b\u02d8");
    }

    private static class EsEntry {
        final String dt;
        final LinkedList<String> lines = new LinkedList();

        EsEntry(String string) {
            this.dt = string;
        }
    }

    private static class FixEntry {
        final String before;
        final String after;

        FixEntry(String string, String string2) {
            this.before = string;
            this.after = string2;
        }
    }
}

