/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.wizard;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletResponse;
import org.primefaces.component.tabview.Tab;
import org.primefaces.component.wizard.Wizard;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.RendererUtils;

public class WizardRenderer
extends CoreRenderer
implements PartialRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Wizard wizard = (Wizard)component;
        this.encodeScript(facesContext, wizard);
        this.encodeMarkup(facesContext, wizard);
    }

    private boolean isStepValid(FacesContext facesContext, Wizard wizard) {
        String wizardClientId = wizard.getClientId(facesContext);
        boolean valid = true;
        Iterator iterator = facesContext.getClientIdsWithMessages();
        while (iterator.hasNext()) {
            String clientId = (String)iterator.next();
            if (clientId.indexOf(wizardClientId) == -1) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public void encodePartially(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Wizard wizard = (Wizard)component;
        boolean success = this.isStepValid(facesContext, wizard);
        int stepToGo = Integer.valueOf((String)facesContext.getExternalContext().getRequestParameterMap().get("stepToGo"));
        int currentStep = Integer.valueOf((String)facesContext.getExternalContext().getRequestParameterMap().get("currentStep"));
        int tabIndexToDisplay = success ? stepToGo : currentStep;
        wizard.setStep(tabIndexToDisplay);
        Tab tabToDisplay = (Tab)((Object)wizard.getChildren().get(tabIndexToDisplay));
        ServletResponse response = (ServletResponse)facesContext.getExternalContext().getResponse();
        response.setContentType("text/xml");
        writer.write("<wizardresponse>");
        writer.write("<wizardtab>");
        writer.write("<success>");
        writer.write(String.valueOf(success));
        writer.write("</success>");
        writer.write("<content>");
        RendererUtils.startCDATA(facesContext);
        this.renderChild(facesContext, (UIComponent)tabToDisplay);
        RendererUtils.endCDATA(facesContext);
        writer.write("</content>");
        writer.write("</wizardtab>");
        writer.write("<state>");
        RendererUtils.startCDATA(facesContext);
        StateManager stateManager = facesContext.getApplication().getStateManager();
        stateManager.writeState(facesContext, stateManager.saveView(facesContext));
        RendererUtils.endCDATA(facesContext);
        writer.write("</state>");
        writer.write("</wizardresponse>");
    }

    private void encodeScript(FacesContext facesContext, Wizard wizard) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = wizard.getClientId(facesContext);
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)wizard);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(widgetVar + " = new PrimeFaces.widget.Wizard('" + clientId + "',{");
        writer.write("type:'" + wizard.getEffect() + "'");
        writer.write(",actionURL:'" + this.getActionURL(facesContext) + "'");
        writer.write(",size:" + wizard.getChildCount());
        writer.write(",formId:'" + ComponentUtils.findParentForm(facesContext, (UIComponent)wizard).getClientId(facesContext) + "'");
        writer.write(",viewportClass:'pf-wizard-viewport'");
        if (wizard.getStep() != 0) {
            writer.write(",index:" + wizard.getStep() + "");
        }
        if (wizard.getSpeed() != 500) {
            writer.write(",speed:" + wizard.getSpeed());
        }
        if (wizard.getWidth() != 400) {
            writer.write(",width:" + wizard.getWidth());
        }
        if (wizard.getHeight() != 400) {
            writer.write(",height:" + wizard.getHeight());
        }
        writer.write("});\n});\n");
        writer.endElement("script");
    }

    private void encodeMarkup(FacesContext facesContext, Wizard wizard) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = wizard.getClientId(facesContext);
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)wizard);
        writer.startElement("div", (UIComponent)wizard);
        writer.writeAttribute("id", (Object)clientId, "id");
        String dim = "height:" + wizard.getHeight() + "px;width:" + wizard.getWidth() + "px";
        String style = wizard.getStyle() == null ? dim : dim + ";" + wizard.getStyle();
        writer.writeAttribute("style", (Object)style, "style");
        if (wizard.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)wizard.getStyleClass(), "styleClass");
        }
        if (!wizard.isCustomUI()) {
            this.encodeNavigators(facesContext, wizard, widgetVar);
        }
        this.encodeTabs(facesContext, wizard);
        writer.endElement("div");
    }

    private void encodeNavigators(FacesContext facesContext, Wizard wizard, String widgetVar) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = wizard.getClientId(facesContext);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"pf-wizard-nav", null);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_prev"), null);
        writer.writeAttribute("class", (Object)"pf-wizard-prev", null);
        if (wizard.getStep() == 0) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        writer.writeAttribute("onclick", (Object)(widgetVar + ".previous();"), null);
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_next"), null);
        writer.writeAttribute("onclick", (Object)(widgetVar + ".next();"), null);
        writer.writeAttribute("class", (Object)"pf-wizard-next", null);
        if (wizard.getStep() == wizard.getChildCount() - 1) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    private void encodeTabs(FacesContext facesContext, Wizard wizard) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = wizard.getClientId(facesContext);
        for (int i = 0; i < wizard.getChildren().size(); ++i) {
            UIComponent kid = (UIComponent)wizard.getChildren().get(i);
            if (!kid.isRendered()) continue;
            Tab tab = (Tab)kid;
            writer.startElement("div", (UIComponent)wizard);
            writer.writeAttribute("id", (Object)(clientId + "_tab" + i), null);
            writer.writeAttribute("class", (Object)"pf-wizard-tab", null);
            if (i == wizard.getStep()) {
                this.renderChild(facesContext, (UIComponent)tab);
            }
            writer.endElement("div");
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

