/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.remotecommand;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.remotecommand.RemoteCommand;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class RemoteCommandRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        String param = component.getClientId(facesContext);
        if (facesContext.getExternalContext().getRequestParameterMap().containsKey(param)) {
            component.queueEvent((FacesEvent)new ActionEvent(component));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        RemoteCommand command = (RemoteCommand)component;
        String clientId = command.getClientId(facesContext);
        UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)command);
        if (form == null) {
            throw new FacesException("Remote Command '" + command.getName() + "' must be enclosed inside a form component.");
        }
        String formClientId = form.getClientId(facesContext);
        writer.startElement("script", (UIComponent)command);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(command.getName() + " = function() {");
        writer.write("PrimeFaces.ajax.AjaxRequest('");
        writer.write(this.getActionURL(facesContext));
        writer.write("',{");
        writer.write("formId:'" + formClientId + "'");
        if (command.isAsync()) {
            writer.write(",async:true");
        }
        if (command.getOnstart() != null) {
            writer.write(",onstart:function(xhr){" + command.getOnstart() + ";}");
        }
        if (command.getOnerror() != null) {
            writer.write(",onerror:function(xhr, status, error){" + command.getOnerror() + ";}");
        }
        if (command.getOnsuccess() != null) {
            writer.write(",onsuccess:function(data, status, xhr, args){" + command.getOnsuccess() + ";}");
        }
        if (command.getOncomplete() != null) {
            writer.write(",oncomplete:function(xhr, status, args){" + command.getOncomplete() + ";}");
        }
        writer.write(",global:" + command.isGlobal());
        writer.write("},{");
        writer.write("'" + clientId + "':'" + clientId + "'");
        if (command.getUpdate() != null) {
            writer.write(",'primefacesPartialUpdate':");
            writer.write("'" + ComponentUtils.findClientIds(facesContext, (UIComponent)command, command.getUpdate()) + "'");
        }
        if (command.getProcess() != null) {
            writer.write(",'primefacesPartialProcess':");
            writer.write("'" + ComponentUtils.findClientIds(facesContext, (UIComponent)command, command.getProcess()) + "'");
        }
        for (UIComponent kid : command.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)component;
            writer.write(",");
            writer.write("'" + parameter.getName() + "'");
            writer.write(":");
            writer.write("'" + (String)parameter.getValue() + "'");
        }
        writer.write("});}");
        writer.endElement("script");
    }
}

