/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.panel;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.panel.Panel;
import org.primefaces.renderkit.CoreRenderer;

public class PanelRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Panel panel = (Panel)component;
        String clientId = panel.getClientId(facesContext);
        String collapsedParam = (String)facesContext.getExternalContext().getRequestParameterMap().get(clientId + "_state");
        if (collapsedParam != null) {
            panel.setCollapsed(collapsedParam.equals("1"));
        }
        this.encodeScript(facesContext, panel);
        this.encodeMarkup(facesContext, panel);
    }

    private void encodeScript(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = panel.getClientId(facesContext);
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)panel);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(var + " = new PrimeFaces.widget.Panel('" + clientId + "', {");
        if (panel.isToggleable()) {
            writer.write("toggleSpeed:" + panel.getToggleSpeed());
            writer.write(",collapsed:" + panel.isCollapsed());
        }
        writer.write("});});");
        writer.endElement("script");
    }

    private void encodeMarkup(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)panel.getClientId(facesContext), null);
        String styleClass = panel.getStyleClass() != null ? "pf-panel " + panel.getStyleClass() : "pf-panel";
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (panel.getStyle() != null) {
            writer.writeAttribute("style", (Object)panel.getStyle(), "style");
        }
        this.encodeHeader(facesContext, panel);
        this.encodeContent(facesContext, panel);
        this.encodeFooter(facesContext, panel);
        if (panel.isToggleable()) {
            this.encodeToggler(facesContext, panel);
            this.encodeStateHolder(facesContext, panel);
        }
        writer.endElement("div");
    }

    private void encodeHeader(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)panel);
        String headerClass = panel.isToggleable() ? "pf-panel-hd pf-panel-hd-toggleable" : "pf-panel-hd";
        UIComponent header = panel.getFacet("header");
        String headerText = panel.getHeader();
        if (headerText == null && header == null) {
            return;
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(panel.getClientId(facesContext) + "_hd"), null);
        writer.writeAttribute("class", (Object)headerClass, null);
        if (panel.isToggleable()) {
            writer.writeAttribute("onclick", (Object)(var + ".toggle();"), null);
        }
        if (header != null) {
            this.renderChild(facesContext, header);
        } else if (headerText != null) {
            writer.write(headerText);
        }
        writer.endElement("div");
    }

    private void encodeContent(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(panel.getClientId(facesContext) + "_bd"), null);
        writer.writeAttribute("class", (Object)"pf-panel-bd", null);
        if (panel.isCollapsed()) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        this.renderChildren(facesContext, (UIComponent)panel);
        writer.endElement("div");
    }

    private void encodeFooter(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        UIComponent footer = panel.getFacet("footer");
        String footerText = panel.getFooter();
        if (footerText == null && footer == null) {
            return;
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(panel.getClientId(facesContext) + "_ft"), null);
        writer.writeAttribute("class", (Object)"pf-panel-ft", null);
        if (footer != null) {
            this.renderChild(facesContext, footer);
        }
        if (footerText != null) {
            writer.write(footerText);
        }
        writer.endElement("div");
    }

    private void encodeToggler(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = panel.getClientId(facesContext);
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)panel);
        String styleClass = panel.isCollapsed() ? "pf-panel-toggler-collapsed" : "pf-panel-toggler-expanded";
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(clientId + "_toggler"), null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("onclick", (Object)(var + ".toggle();"), null);
        writer.endElement("span");
    }

    private void encodeStateHolder(FacesContext facesContext, Panel panel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = panel.getClientId(facesContext);
        String stateHolderId = clientId + "_state";
        int state = panel.isCollapsed() ? 1 : 0;
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)stateHolderId, null);
        writer.writeAttribute("name", (Object)stateHolderId, null);
        writer.writeAttribute("value", (Object)state, null);
        writer.endElement("input");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

