/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.imageswitch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.graphicimage.GraphicImage;
import org.primefaces.component.imageswitch.ImageSwitch;
import org.primefaces.model.StreamedContent;
import org.primefaces.renderkit.CoreRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageSwitchRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ImageSwitch imageSwitch = (ImageSwitch)component;
        this.encodeScript(facesContext, imageSwitch);
        this.encodeMarkup(facesContext, imageSwitch);
    }

    private void encodeScript(FacesContext facesContext, ImageSwitch imageSwitch) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = imageSwitch.getClientId(facesContext);
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)imageSwitch);
        String imageClientId = ((UIComponent)imageSwitch.getChildren().get(0)).getClientId(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(widgetVar + " = new PrimeFaces.widget.ImageSwitch('" + imageClientId + "',{");
        writer.write("effect:'" + imageSwitch.getEffect() + "'");
        writer.write(",speed:" + imageSwitch.getSpeed());
        writer.write(",slideshowSpeed:" + imageSwitch.getSlideshowSpeed());
        writer.write(",slideshowAuto:" + imageSwitch.isSlideshowAuto());
        writer.write("},");
        writer.write(this.getImagesAsJSArray(facesContext, imageSwitch));
        writer.write(");\n");
        writer.write("});");
        writer.endElement("script");
    }

    private List<String> getImages(FacesContext facesContext, ImageSwitch imageSwitch) {
        ArrayList<String> images = new ArrayList<String>();
        for (UIComponent child : imageSwitch.getChildren()) {
            GraphicImage image;
            if (!(child instanceof GraphicImage) || !(image = (GraphicImage)child).isRendered()) continue;
            images.add(this.getImageSrc(facesContext, image));
        }
        return images;
    }

    private void encodeMarkup(FacesContext facesContext, ImageSwitch imageSwitch) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = imageSwitch.getClientId(facesContext);
        writer.startElement("div", (UIComponent)imageSwitch);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (imageSwitch.getStyle() != null) {
            writer.writeAttribute("style", (Object)imageSwitch.getStyle(), null);
        }
        if (imageSwitch.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)imageSwitch.getStyleClass(), null);
        }
        UIComponent firstChild = (UIComponent)imageSwitch.getChildren().get(0);
        this.renderChild(facesContext, firstChild);
        writer.endElement("div");
    }

    private String getImagesAsJSArray(FacesContext facesContext, ImageSwitch imageSwitch) {
        List<String> images = this.getImages(facesContext, imageSwitch);
        StringBuilder array = new StringBuilder();
        array.append("[");
        Iterator<String> iterator = images.iterator();
        while (iterator.hasNext()) {
            array.append("'");
            array.append(iterator.next());
            array.append("'");
            if (!iterator.hasNext()) continue;
            array.append(",");
        }
        array.append("]");
        return array.toString();
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    private String getImageSrc(FacesContext facesContext, GraphicImage image) {
        Object value = image.getValue();
        if (value == null) {
            return "";
        }
        if (value instanceof StreamedContent) {
            ValueExpression valueVE = image.getValueExpression("value");
            String veString = valueVE.getExpressionString();
            String expressionParamValue = veString.substring(2, veString.length() - 1);
            String url = this.getActionURL(facesContext);
            url = url.contains("?") ? url + "&" : url + "?";
            StringBuilder builder = new StringBuilder(url);
            builder.append("primefacesDynamicContent").append("=").append(expressionParamValue);
            for (UIComponent kid : image.getChildren()) {
                if (!(kid instanceof UIParameter)) continue;
                UIParameter param = (UIParameter)kid;
                builder.append("&").append(param.getName()).append("=").append(param.getValue());
            }
            return builder.toString();
        }
        return this.getResourceURL(facesContext, value.toString());
    }
}

