require 'prb/prb'
require 'prb/opt'

class Item < PRb::PRbObject
  def init(nm)
    self.name = nm
  end
  prb_attr :name, :ary
end

def transaction(&block)
  PRb.primary.transaction(&block)
end

def main
  pool = DBIPool.new(*DBIPool.check_options(ARGV))
  prb = PRb::Store.new(pool)
  root = prb.root


50.times do
  x = nil
  root.transaction do
    x = Item.knew('seki')
    root.add(x)
    x.ary = []
  end

  p x.name

  transaction do
    p x.ary
    p x.ary.to_a
  end

  ary = nil
  transaction do
    ary = x.ary
    ary.push(1)
    ary.push("2")
    ary.push(3.to_s.intern)
    ary.push(x)
  end

  ary.each do |v|
    p v
  end

  root.transaction do
    root.delete(x)
  end

  PRb.primary.gc
end
end

main
 
