/**
 * PowerDBJ
 * create date 2006/09/26
 * amonden
 */
package jp.co.powerbeans.eclipse.plugin.powerdbj.export.java;

import java.io.Serializable;

import jp.co.powerbeans.eclipse.plugin.powerdbj.export.java.util.JavaExpUtil;
import jp.co.powerbeans.powerql.ColumnProperty;

/**
 * PropProperty
 * @author amonden
 * @create date 2006/09/26
 */
public class PropProperty implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 8476805179671941705L;
  private ColumnProperty columnProperty;
  private String property;
  private String readMethod;
  private String writeMethod;

  /**
   * @param columnProperty
   */
  public PropProperty(ColumnProperty columnProperty) {
    this.columnProperty = columnProperty;
    
    // プロパティ名,メソッド名作成
    this.property = JavaExpUtil.columnNameToProperty(this.columnProperty.getName());
    this.readMethod = JavaExpUtil.propertyToReadMethod(this.property, columnProperty.getType());
    this.writeMethod = JavaExpUtil.propertyToWriteMethod(this.property);
  }
  
  public String getTypeName() {
    return (this.columnProperty != null && this.columnProperty.getType() != null) ?
        this.columnProperty.getType().getName() : "";
  }

  /**
   * @return
   * @see jp.co.powerbeans.powerql.ColumnProperty#getComment()
   */
  public String getComment() {
    return columnProperty.getComment();
  }

  /**
   * @return
   * @see jp.co.powerbeans.powerql.ColumnProperty#getDefaultValue()
   */
  public Object getDefaultValue() {
    return columnProperty.getDefaultValue();
  }

  /**
   * @return
   * @see jp.co.powerbeans.powerql.ColumnProperty#getName()
   */
  public String getName() {
    return columnProperty.getName();
  }

  /**
   * @return
   * @see jp.co.powerbeans.powerql.ColumnProperty#getPrimaryKeyName()
   */
  public String getPrimaryKeyName() {
    return columnProperty.getPrimaryKeyName();
  }

  /**
   * @return
   * @see jp.co.powerbeans.powerql.ColumnProperty#getSize()
   */
  public int getSize() {
    return columnProperty.getSize();
  }

  /**
   * @return
   * @see jp.co.powerbeans.powerql.ColumnProperty#getType()
   */
  public Class getType() {
    return columnProperty.getType();
  }

  /**
   * @return
   * @see jp.co.powerbeans.powerql.ColumnProperty#getTypeAsDB()
   */
  public String getTypeAsDB() {
    return columnProperty.getTypeAsDB();
  }

  /**
   * @return
   * @see jp.co.powerbeans.powerql.ColumnProperty#isForceAutoValue()
   */
  public boolean isForceAutoValue() {
    return columnProperty.isForceAutoValue();
  }

  /**
   * @return
   * @see jp.co.powerbeans.powerql.ColumnProperty#isNotUseInsertSql()
   */
  public boolean isNotUseInsertSql() {
    return columnProperty.isNotUseInsertSql();
  }

  /**
   * @return
   * @see jp.co.powerbeans.powerql.ColumnProperty#isNullable()
   */
  public boolean isNullable() {
    return columnProperty.isNullable();
  }

  /**
   * @return
   * @see jp.co.powerbeans.powerql.ColumnProperty#isPrimaryKey()
   */
  public boolean isPrimaryKey() {
    return columnProperty.isPrimaryKey();
  }

  /**
   * @param comment
   * @see jp.co.powerbeans.powerql.ColumnProperty#setComment(java.lang.String)
   */
  public void setComment(String comment) {
    columnProperty.setComment(comment);
  }

  /**
   * @param object
   * @see jp.co.powerbeans.powerql.ColumnProperty#setDefaultValue(java.lang.Object)
   */
  public void setDefaultValue(Object object) {
    columnProperty.setDefaultValue(object);
  }

  /**
   * @param forceAutoValue
   * @see jp.co.powerbeans.powerql.ColumnProperty#setForceAutoValue(boolean)
   */
  public void setForceAutoValue(boolean forceAutoValue) {
    columnProperty.setForceAutoValue(forceAutoValue);
  }

  /**
   * @param string
   * @see jp.co.powerbeans.powerql.ColumnProperty#setName(java.lang.String)
   */
  public void setName(String string) {
    columnProperty.setName(string);
  }

  /**
   * @param b
   * @see jp.co.powerbeans.powerql.ColumnProperty#setNullable(boolean)
   */
  public void setNullable(boolean b) {
    columnProperty.setNullable(b);
  }

  /**
   * @param b
   * @see jp.co.powerbeans.powerql.ColumnProperty#setPrimaryKey(boolean)
   */
  public void setPrimaryKey(boolean b) {
    columnProperty.setPrimaryKey(b);
  }

  /**
   * @param primaryKeyName
   * @see jp.co.powerbeans.powerql.ColumnProperty#setPrimaryKeyName(java.lang.String)
   */
  public void setPrimaryKeyName(String primaryKeyName) {
    columnProperty.setPrimaryKeyName(primaryKeyName);
  }

  /**
   * @param i
   * @see jp.co.powerbeans.powerql.ColumnProperty#setSize(int)
   */
  public void setSize(int i) {
    columnProperty.setSize(i);
  }

  /**
   * @param type
   * @see jp.co.powerbeans.powerql.ColumnProperty#setType(java.lang.Class)
   */
  public void setType(Class type) {
    columnProperty.setType(type);
  }

  /**
   * @param string
   * @see jp.co.powerbeans.powerql.ColumnProperty#setTypeAsDB(java.lang.String)
   */
  public void setTypeAsDB(String string) {
    columnProperty.setTypeAsDB(string);
  }

  /**
   * @return property
   */
  public String getProperty() {
    return property;
  }

  /**
   * @param property 設定する property
   */
  public void setProperty(String property) {
    this.property = property;
  }

  /**
   * @return readMethod
   */
  public String getReadMethod() {
    return readMethod;
  }

  /**
   * @param readMethod 設定する readMethod
   */
  public void setReadMethod(String readMethod) {
    this.readMethod = readMethod;
  }

  /**
   * @return writeMethod
   */
  public String getWriteMethod() {
    return writeMethod;
  }

  /**
   * @param writeMethod 設定する writeMethod
   */
  public void setWriteMethod(String writeMethod) {
    this.writeMethod = writeMethod;
  }

}
