/**
 * PowerDBJ
 * create date 2006/09/26
 * amonden
 */
package jp.co.powerbeans.eclipse.plugin.powerdbj.export.java;

import jp.co.powerbeans.docbuild.PBDocumentBuilder;
import jp.co.powerbeans.eclipse.plugin.powerdbj.db.DBManager;
import jp.co.powerbeans.eclipse.plugin.powerdbj.model.JdbcConfig;
import jp.co.powerbeans.powerql.ColumnProperty;
import jp.co.powerbeans.powerql.TableProperty;

/**
 * JavaTableModelExporter
 * 
 * @author amonden
 * @create date 2006/09/26
 */
public class PowerQLDAOJavaExporter extends JavaExporterBase {
  static final String[] TEMPLATE_FILE = { "PowerQLDAO.java", "PowerQLDAOImpl.java" };

  static final String[] SUFFIX = { "DAO", "DAOImpl" };

  /*
   * (non-Javadoc)
   * 
   * @see jp.co.powerbeans.eclipse.plugin.powerdbj.export.Exporter#export(jp.co.powerbeans.eclipse.plugin.powerdbj.model.JdbcConfig,
   *      jp.co.powerbeans.powerql.TableProperty[], java.lang.String)
   */
  public String export(JdbcConfig jdbcConfig, TableProperty[] selectTables, String path) {

    // テーブル毎にDAO,DAOImplを出力
    for (int i = 0; i < selectTables.length; i++) {
      TableProperty table = selectTables[i];
      ColumnProperty[] cps = DBManager.findSysColumnBySchemaTable(table.getSchema(), table
          .getTableName());
      table.setColumnProperties(cps);
      // 値格納
      ClassProperty cp = new ClassProperty(table);

      // テンプレートファイルごとに出力
      for (int j = 0; j < TEMPLATE_FILE.length; j++) {
        PBDocumentBuilder builder = createJavaDocBuilder(TEMPLATE_FILE[j], jdbcConfig.getCharset());
        builder.assign("cls", cp);
        builder.assign("proplist", cp.getProperties());
        
        // ログ
        progressNotify("exporting " + cp.getTableName() + " to " + cp.getClassName() + SUFFIX[j] + ".java", i / selectTables.length);

        // 出力
        builder.output(path + "/" + cp.getClassName() + SUFFIX[j] + ".java");
      }
    }

    return path;
  }

}
