<?php
/*
 * blog2viewer v1.2
 */

/*add below to <lang>.lng
///////////////////////////////////////
// blog2viewer.inc.php
$_plugin_blog2viewer_error_argument = 'argument error.';
$_plugin_blog2viewer_mes_prev = '<-';
$_plugin_blog2viewer_mes_next = '->';
*/

require_once('blog2navi.inc.php');



function plugin_blog2viewer_convert()
{
	global $_plugin_blog2viewer_error_argument;
	
	$page = $GLOBALS['vars']['page'];
	
	$argc = func_num_args();
	$argv = func_get_args();
	
	if($argc == 0){
		$source = get_source($page);
		foreach($source as $s){
			if(substr($s, 0, 3) == '//-'){
				preg_match('/\[\[.*>(.*)\]\]/', $s, $m);
				$colpage[] = $m[1];
			}
		}
		
		$ret = '';
		foreach($colpage as $p){
			$ret .= plugin_blog2viewer_include($p);
		}
		return $ret;
	}
	else if($argc == 2){
		$index = isset($_GET['blog2viewer']) ? $_GET['blog2viewer'] : 0;
		return plugin_blog2viewer_includeblog($argv[0], $index, $argv[1]);
	}
	
	return "<p>$_plugin_blog2viewer_error_argument</p>";
}



function plugin_blog2viewer_includeblog($blogname, $index, $n)
{
	global $_plugin_blog2viewer_mes_prev, $_plugin_blog2viewer_mes_next;
	
	$datelist =& Blog2Navi_DateList::getinstance($blogname);
	$collist =& Blog2Navi_ColumnList::getinstance($datelist);
	
	$ret = '';
	$i = 0;
	$start = $index;
	$end = $index + $n;
	
	$p = $collist->getlast();
	while($i < $start){
		$p = $collist->getprev($p);
		if($p == null){
			return $ret;
		}
		$i++;
	}
	
	$date = '';
	while($i < $end && $p != null){
		if(check_readable($p, true, false)){
			preg_match('|^([^/]+/[^/]+)|', $p, $m);
			if($m[1] != $date){
				$ret .= '<h1>' . make_pagelink($m[1]) . "</h1>\n";
				$date = $m[1];
			}
			
			$ret .= plugin_blog2viewer_include($p);
		}
		$i++;
		$p = $collist->getprev($p);
	}
	
	$str = array();
	if($start != 0){
		$str[] = '<a href="' . $script . '?cmd=read&amp;page=' . urlencode($GLOBALS['vars']['page']) . '&amp;blog2viewer=' . ($index - $n) . '">' . htmlspecialchars($_plugin_blog2viewer_mes_prev) . '</a>';
	}
	if($p != null){
		$str[] = '<a href="' . $script . '?cmd=read&amp;page=' . urlencode($GLOBALS['vars']['page']) . '&amp;blog2viewer=' . ($index + $n) . '">' . htmlspecialchars($_plugin_blog2viewer_mes_next) . '</a>';
	}
	
	if($str != array()){
		$ret .= '<div class="blog2viewer">' . join('&nbsp;', $str) . "</div>\n";
	}
	
	return $ret;
}



function plugin_blog2viewer_include($pagename)
{
	global $vars, $post, $get;
	global $_plugin_blog2_mes_category;
	
	if(!check_readable($pagename, true, false)){
		return false;
	}
	
	$realpage = $vars['page'];
	$vars['page'] = $pagename;
	$post['page'] = $pagename;
	$get['page'] = $pagename;
	
	$source = join('', get_source($pagename));
	
	//ȥ˥󥯤Ϥ
	$source = preg_replace("/^\*([^*].*)\n/m", "*[[$1>$pagename]]\n", $source);
	
	//blog2naviκ
	$source = preg_replace("/#blog2navi\(\)\n/", '', $source);
	
	
	$ret = convert_html($source);
	
	$vars['page'] = $realpage;
	$post['page'] = $realpage;
	$get['page'] = $realpage;
	
	return $ret;
}


?>
