//
// Localization.java
// This file is part of PosterDivider.
//
package jp.sourceforge.posterdivider;

import java.util.HashMap;
import java.util.Locale;

public class Localization {
	private HashMap<String, String> dict = new HashMap<String, String>();

	public void addMessage(String key, String value) {
		dict.put(key, value);
	}

	public void addLanguageMessages(String language, String country) {
		if (language == Locale.JAPANESE.getLanguage()) {
			addJapaneseMessages();
		}
	}

	public void addJapaneseMessages() {
		addMessage("New", "新規");
		addMessage("Open", "開く");
		addMessage("Close", "閉じる");
		addMessage("Output", "出力");
		addMessage("FileName", "ファイル名");
		addMessage("Change", "変更");
		addMessage("PageNum", "ページ番号");
		addMessage("ImageSize", "画像のサイズ");
		addMessage("SrcRect", "ポスターにする範囲（左下右上の座標）");
		addMessage("WholeOfPage", "ページ全体");
		addMessage("PosterSize", "ポスターのサイズ");
		addMessage("KeepAspectRatio", "縦横比を保持");
		addMessage("PaperSize", "印刷用紙のサイズ");
		addMessage("Margin", "のりしろの長さ");
		addMessage("RotatePaper", "用紙を回転する");
		addMessage("Optimize", "最適化");
		addMessage("Preview", "プレビュー");
		addMessage("OutputPaperCount", "推定出力枚数");
		addMessage("OutputFileName", "出力ファイル名");
		addMessage("Output", "出力");
		addMessage("Custom", "カスタム");
		addMessage("Saved '%s'", "'%s' に保存しました");
		addMessage("Failed Write '%s'", "'%s' に書き込めませんでした");
		addMessage("Failed Generate", "pdfファイルの生成に失敗しました");
		addMessage("No Input Files", "ファイルが指定されていません");
		addMessage("Failed Open '%s'", "'%s' の読み込みに失敗しました");
	}

	public String getMessage(String key) {
		String value = dict.get(key);
		return (value == null) ? key : value;
	}
}
