/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.posterdivider;

import com.itextpdf.text.Image;
import com.itextpdf.text.Utilities;
import java.io.File;
import java.io.FileInputStream;
import java.util.Locale;
import jp.sourceforge.posterdivider.Localization;

class Lib {
    public static final String APP_TITLE = "PosterDivider";
    public static final String APP_LOWERTITLE = "posterdivider";
    public static final String APP_VERSION = "1.0.1.20110509";
    public static final String APP_SHORTVERSION = "1.0.1";
    public static final int FT_NONE = 0;
    public static final int FT_PDF = 1;
    public static final int FT_BMP = 2;
    public static final int FT_GIF = 3;
    public static final int FT_JBIG2 = 4;
    public static final int FT_JPEG = 5;
    public static final int FT_JPEG2000 = 6;
    public static final int FT_PNG = 7;
    public static final int FT_TIFF = 8;
    public static final int FT_WMF = 9;
    public static final int FT_OTHERIMAGE = 10;
    public static final double UNIT_POINT_POINT = 1.0;
    public static final double UNIT_POINT_INCH = Utilities.pointsToInches((float)1.0f);
    public static final double UNIT_POINT_MM = Utilities.pointsToMillimeters((float)1.0f);
    public static final double UNIT_POINT_CM = UNIT_POINT_MM / 10.0;
    public static final double UNIT_POINT_M = UNIT_POINT_MM / 1000.0;
    public static final double UNIT_PIXEL_PIXEL = 1.0;
    private static Localization localization = new Localization();

    Lib() {
    }

    public static int getImageFileType(Image image) {
        switch (image.getOriginalType()) {
            case 4: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 9: {
                return 4;
            }
            case 1: {
                return 5;
            }
            case 8: {
                return 6;
            }
            case 2: {
                return 7;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 9;
            }
        }
        return 10;
    }

    public static String getFileTypeName(int n) {
        switch (n) {
            case 1: {
                return "PDF ";
            }
            case 2: {
                return "BMP ";
            }
            case 3: {
                return "GIF";
            }
            case 4: {
                return "JBIG2";
            }
            case 5: {
                return "JPEG";
            }
            case 6: {
                return "JPEG 2000";
            }
            case 7: {
                return "PNG";
            }
            case 8: {
                return "TIFF";
            }
            case 9: {
                return "WMF";
            }
            case 10: {
                return "IMAGE";
            }
        }
        return "";
    }

    public static String getMessage(String string) {
        return localization.getMessage(string);
    }

    public static byte[] FileReadAllBytes(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = fileInputStream.available();
        byte[] byArray = new byte[n];
        fileInputStream.read(byArray);
        fileInputStream.close();
        return byArray;
    }

    static {
        localization.addLanguageMessages(Locale.getDefault().getLanguage(), Locale.getDefault().getCountry());
    }
}

