/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.posterdivider;

import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.PdfReader;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import jp.sourceforge.posterdivider.Lib;

public class FileContainer {
    private int fileType = 0;
    private PdfReader pdf;
    private Image image;
    private BufferedImage awtImage;

    public FileContainer(File file) throws Exception {
        PdfReader pdfReader;
        if (this.fileType == 0) {
            try {
                pdfReader = new PdfReader(file.getAbsolutePath());
                this.fileType = 1;
                this.pdf = pdfReader;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.fileType == 0) {
            try {
                pdfReader = Image.getInstance((String)file.getAbsolutePath());
                this.fileType = Lib.getImageFileType((Image)pdfReader);
                this.image = pdfReader;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.fileType == 0) {
            throw new Exception();
        }
        try {
            this.awtImage = ImageIO.read(file);
        }
        catch (Exception exception) {
            this.awtImage = null;
        }
    }

    public FileContainer(byte[] byArray) throws Exception {
        PdfReader pdfReader;
        if (this.fileType == 0) {
            try {
                pdfReader = new PdfReader(byArray);
                this.fileType = 1;
                this.pdf = pdfReader;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.fileType == 0) {
            try {
                pdfReader = Image.getInstance((byte[])byArray);
                this.fileType = Lib.getImageFileType((Image)pdfReader);
                this.image = pdfReader;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.fileType == 0) {
            throw new Exception();
        }
    }

    public int getFileType() {
        return this.fileType;
    }

    public PdfReader getPdf() {
        return this.pdf;
    }

    public Image getImage() {
        return this.image;
    }

    public int getPageCount() {
        switch (this.fileType) {
            case 1: {
                return this.pdf.getNumberOfPages();
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return 1;
            }
        }
        return -1;
    }

    public BufferedImage getAwtImage() {
        return this.awtImage;
    }
}

