//
// CanvasPreview.java
// This file is part of PosterDivider.
//
package jp.sourceforge.posterdivider;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.*;

public class CanvasPreview extends Canvas {
	private static final long serialVersionUID = 1L;

	private ImageContainer ic;
	private PdfGenerator.CreatePosterArgs args;

	@Override
	public void paint(Graphics g) {
		super.paint(g);

		g.setColor(Color.WHITE);
		g.fillRect(0, 0, this.getWidth(), this.getHeight());
		g.setColor(Color.GRAY);
		g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);

		if (ic == null || args == null) {
			// 未設定項目がある場合
			return;
		}
		BufferedImage awtImage = ic.getAwtImage();

		// 左側
		float srcBoxX = this.getWidth() * 0.05f;
		float srcBoxY = this.getHeight() * 0.05f;
		float srcBoxWidth = this.getWidth() * 0.40f;
		float srcBoxHeight = this.getHeight() * 0.90f;
		// g.setColor(Color.GRAY);
		// g.drawRect((int) srcBoxX, (int) srcBoxY, (int) srcBoxWidth,
		// (int) srcBoxHeight);

		float srcImageX, srcImageY, srcImageWidth, srcImageHeight, srcImageRate;
		if (ic.getImageWidth() * srcBoxHeight > ic.getImageHeight()
				* srcBoxWidth) {
			// 横長
			srcImageX = srcBoxX;
			srcImageWidth = srcBoxWidth;
			srcImageRate = srcImageWidth / ic.getImageWidth();
			srcImageHeight = ic.getImageHeight() * srcImageRate;
			srcImageY = srcBoxY + (srcBoxHeight - srcImageHeight) / 2;
		} else {
			// 縦長
			srcImageY = srcBoxY;
			srcImageHeight = srcBoxHeight;
			srcImageRate = srcImageHeight / ic.getImageHeight();
			srcImageWidth = ic.getImageWidth() * srcImageRate;
			srcImageX = srcBoxX + (srcBoxWidth - srcImageWidth) / 2;
		}
		int srcImageLeft = (int) srcImageX;
		int srcImageTop = (int) srcImageY;
		int srcImageRight = (int) (srcImageX + srcImageWidth);
		int srcImageBottom = (int) (srcImageY + srcImageHeight);
		if (awtImage != null) {
			g.drawImage(awtImage, srcImageLeft, srcImageTop, srcImageRight,
					srcImageBottom, 0, 0, awtImage.getWidth(), awtImage
							.getHeight(), this);
		}

		float srcX = srcImageX + args.getSrcLeft() * srcImageRate;
		// srcは左上原点だが、CreatePosterArgsのsrcは左下原点なのでここで解消する
		float srcY = srcImageY + (ic.getImageHeight() - args.getSrcTop())
				* srcImageRate;
		float srcWidth = args.getSrcWidth() * srcImageRate;
		float srcHeight = args.getSrcHeight() * srcImageRate;
		int srcLeft = (int) srcX;
		int srcTop = (int) srcY;
		int srcRight = (int) (srcX + srcWidth);
		int srcBottom = (int) (srcY + srcHeight);
		if (awtImage != null) {
			// 範囲外の部分を塗りつぶす
			g.setColor(new Color(1.0f, 1.0f, 1.0f, 0.5f));
			g.fillRect(srcImageLeft, srcImageTop, srcImageRight - srcImageLeft,
					srcTop - srcImageTop);
			g.fillRect(srcImageLeft, srcTop, srcLeft - srcImageLeft, srcBottom
					- srcTop);
			g.fillRect(srcRight, srcTop, srcImageRight - srcRight, srcBottom
					- srcTop);
			g.fillRect(srcImageLeft, srcBottom, srcImageRight - srcImageLeft,
					srcImageBottom - srcBottom);
		} else {
			g.setColor(Color.GRAY);
			g.fillRect(srcLeft, srcTop, srcRight - srcLeft, srcBottom - srcTop);
		}
		g.setColor(Color.BLACK);
		g.drawRect(srcImageLeft, srcImageTop, srcImageRight - srcImageLeft,
				srcImageBottom - srcImageTop);
		g.setColor(Color.BLACK);
		g.drawRect(srcLeft, srcTop, srcRight - srcLeft, srcBottom - srcTop);

		// 右側

		float posterBoxX = this.getWidth() * 0.55f;
		float posterBoxY = this.getHeight() * 0.05f;
		float posterBoxWidth = this.getWidth() * 0.40f;
		float posterBoxHeight = this.getHeight() * 0.90f;
		// g.setColor(Color.GRAY);
		// g.drawRect((int) posterBoxX, (int) posterBoxY, (int) posterBoxWidth,
		// (int) posterBoxHeight);

		float posterX, posterY, posterWidth, posterHeight, posterRate;
		if (args.getPosterWidth() * posterBoxHeight > args.getPosterHeight()
				* posterBoxWidth) {
			// 横長
			posterX = posterBoxX;
			posterWidth = posterBoxWidth;
			posterRate = posterWidth / args.getPosterWidth();
			posterHeight = args.getPosterHeight() * posterRate;
			posterY = posterBoxY + (posterBoxHeight - posterHeight) / 2;
		} else {
			// 縦長
			posterY = posterBoxY;
			posterHeight = posterBoxHeight;
			posterRate = posterHeight / args.getPosterHeight();
			posterWidth = args.getPosterWidth() * posterRate;
			posterX = posterBoxX + (posterBoxWidth - posterWidth) / 2;
		}
		int postarLeft = (int) posterX;
		int postarTop = (int) posterY;
		int postarRight = (int) (posterX + posterWidth);
		int postarBottom = (int) (posterY + posterHeight);
		if (awtImage != null) {
			g.drawImage(awtImage, postarLeft, postarTop, postarRight,
					postarBottom, (int) (awtImage.getWidth()
							* args.getSrcLeft() / ic.getImageWidth()),
					(int) (awtImage.getHeight()
							* (ic.getImageHeight() - args.getSrcTop()) / ic
							.getImageHeight()), (int) (awtImage.getWidth()
							* args.getSrcRight() / ic.getImageWidth()),
					(int) (awtImage.getHeight()
							* (ic.getImageHeight() - args.getSrcBottom()) / ic
							.getImageHeight()), this);
		} else {
			g.setColor(Color.GRAY);
			g.fillRect(postarLeft, postarTop, postarRight - postarLeft,
					postarBottom - postarTop);
		}
		g.setColor(Color.BLACK);
		g.drawRect(postarLeft, postarTop, postarRight - postarLeft,
				postarBottom - postarTop);

		int paperCountX = PdfGenerator.simulateOutputPaperCountX(args);
		int paperCountY = PdfGenerator.simulateOutputPaperCountY(args);

		if (paperCountX < 0 || paperCountY < 0) {
			// 設定値が不正
			return;
		}

		float paperX = posterX - args.getMarginLeft() * posterRate;
		float paperY = posterY - args.getMarginTop() * posterRate;
		float paperWidth = args.getPaperWidth() * posterRate;
		float paperHeight = args.getPaperHeight() * posterRate;
		float paperTextWidth = (args.getPaperWidth() - args.getMarginLeft() - args
				.getMarginRight())
				* posterRate;
		float paperTextHeight = (args.getPaperHeight() - args.getMarginTop() - args
				.getMarginBottom())
				* posterRate;

		float y = paperY;
		for (int i = 0; i < paperCountY; i++) {
			float x = paperX;
			for (int j = 0; j < paperCountX; j++) {
				// 交互に色を変える
				if ((i + j) % 2 == 0) {
					g.setColor(Color.RED);
					g.drawRect((int) x, (int) y, (int) paperWidth,
							(int) paperHeight);
				} else {
					g.setColor(Color.BLUE);
					g.drawRect((int) x + 1, (int) y + 1, (int) paperWidth,
							(int) paperHeight);
				}
				x += paperTextWidth;
			}
			y += paperTextHeight;
		}
	}

	public ImageContainer getImageContainer() {
		return ic;
	}

	public void setImageContainer(ImageContainer ic) {
		this.ic = ic;
	}

	public PdfGenerator.CreatePosterArgs getArgs() {
		return this.args;
	}

	public void setArgs(PdfGenerator.CreatePosterArgs args) {
		this.args = args;
	}
}
