//-------------------------------------------------
// drawing.js
//
// Copyright (c) 2006 Hidekazu Kubota (Taro Sosui) All right reserved
//  taro@summer.nifty.jp  
//  http://positlog.storybook.jp/ 
//
// This file is part of PositLog.
//-------------------------------------------------

drawCommand = new Array();

//-------------------------
// Drawing
//-------------------------
function execDrawCommand()
{
	while(drawCommand.length > 0){
		var cmd = drawCommand.shift();
		var cmdArray = cmd.split(",");
		var canvas = document.getElementById(cmdArray[0]);
		if(!canvas){
			continue;
		}
		if(!canvas.getContext){
			return;
		}

		if(document.getElementById(cmdArray[0] + "_title")){
			document.getElementById(cmdArray[0] + "_title").style.display = "none";
		}

		if(cmdArray[1] == "l"){
			var ctx = canvas.getContext("2d");
			ctx.strokeStyle = "#000000";
			ctx.lineWidth = 2;


			ctx.lineCap = "round";
			ctx.lineJoin = "round";
			var cmdStr = new String(cmdArray[2]);
			var startIndex = 4;
			ctx.beginPath();
			if(cmdStr.match(/^s(.+)$/)){
				ctx.lineWidth = parseFloat(RegExp.$1);
				startIndex++;
			}
			cmdStr = new String(cmdArray[3]);
			if(cmdStr.match(/^c(.+)$/)){
				ctx.strokeStyle = RegExp.$1;
				startIndex++;
			}

			ctx.moveTo(parseInt(cmdArray[startIndex-2]),parseInt(cmdArray[startIndex-1]));

			for(var i=startIndex; i<cmdArray.length; i++){
				if(cmdArray[i] == "l"){
					ctx.stroke();
					i++;
					var cmdStr = new String(cmdArray[i]);
					if(cmdStr.match(/^s(.+)$/)){
						ctx.lineWidth = parseFloat(RegExp.$1);
						i++;
					}
					cmdStr = new String(cmdArray[i]);
					if(cmdStr.match(/^c(.+)$/)){
						ctx.strokeStyle = RegExp.$1;
						i++;
					}
					ctx.beginPath();
					ctx.moveTo(parseInt(cmdArray[i]),parseInt(cmdArray[i+1]));
				}
				else{
					ctx.lineTo(parseInt(cmdArray[i]),parseInt(cmdArray[i+1]));
				}

				i++;
			}
			ctx.stroke();
		}
	}
}

function draw(cmd)
{
	drawCommand.push(cmd);
}

function bodyOnLoad()
{
	execDrawCommand();
}