#!/usr/local/bin/perl

# --------------------------------------------------------
# Encoding of this file is UTF-8
# --------------------------------------------------------

# --------------------------------------------------------
# pagerss.cgi
#      CGI script for generating the rss file of a page.
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006-2007 Hidekazu Kubota (Taro Sosui) All right reserved
#  <taro@summer.nifty.jp>
#   http://positlog.storybook.jp/
#
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
# --------------------------------------------------------

use strict;
use Storable qw(lock_retrieve lock_nstore);
use PositLogConfig;
use Walrus::RSS;
use utf8;
use CGI qw/-debug :standard/;

# Please change $siteurl
my $siteurl = $PositLogConfig::site;

chop $siteurl;

my $serializedData = "pagerss";
my $maxnumber = 10;

my $CGI = new CGI;
print "Content-type: application/xml\n\n";

my $pageid = $CGI->param("load");

my $urlSpriteid = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/dynamic/". $serializedData  . ".dat")} or {};

my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/config.dat")} or {};
if($@){ warn $@; print "Page not found.\n"; exit(0); }

my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/permission.cgi")};
if($@){ exit(0); }
if(scalar($permissionHash->{"read_page"}{"public"}) != 1){
		# no permission
		warn $@; print "Page not found.\n"; exit(0);
}

if (exists($urlSpriteid->{"modified_time"})){
		if(scalar($urlSpriteid->{"modified_time"}) > ($configHash->{"modified_time"})){
				# use cache
				print $urlSpriteid->{"rss"};
				exit(1);
		}
}

my $spritesHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/sprites.dat")};
if($@){ warn $@; print "Cannot read the sprite list.\n"; exit(0); }

my $useridAuth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")};
if($@){ warn $@; print "Cannot read the authentication file for users.<br>\n"; exit(0);}

my $counter = 0;

my $rss = new Walrus::RSS(
		version => '1.0',
		encoding => 'utf-8',
		);

for my $sid (sort { ($spritesHash->{$b}->{"modified_time"}) <=> ($spritesHash->{$a}->{"modified_time"}) } (keys %$spritesHash)){
		
		my $tmpdate = $spritesHash->{$sid}{"modified_time"};
		$tmpdate =~ /(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)/i;
		my $modifiedTime = "$1-$2-$3T$4:$5:$6+09:00";

		my $author_id = $spritesHash->{$sid}{"author_id"};
		my $public_author = $spritesHash->{$sid}{"public_author"};
		my $public_password = $spritesHash->{$sid}{"public_password"};

		my $singleContents = "no contents";
		my $contents = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pageid . "/static/" . $sid . ".spr")} or "";
		if($contents ne ""){
				$singleContents = $$contents;
		}
		else{
				next;
		}

		my $abst = $singleContents;
		$abst =~ s/<br>/\n/gis;
		$abst =~ s/&amp;/&/gis;
		$abst =~ s/<.+?>//gis;
		utf8::decode($abst);

		my $header = "";
		if($abst =~ /^(.+?)。.*?$/s){
				$header = $1;
		}
		if($abst =~ /^(.+?)．.*?$/s){
				my $tmpheader = $1;
				if($header eq "" || length($header) > length($tmpheader)){
						$header = $tmpheader;
				}
		}
		if($abst =~ /^(.+?)[\n\r]/s){
				my $tmpheader = $1;
				if($header eq "" || length($header) > length($tmpheader)){
						$header = $tmpheader;
				}
		}


		if($header eq "" || length($header) > 30){
				if($abst =~ /^(.+?)、.*?$/s){
						if(length($1) <= 30){
								$header = $1;
						}
				}
				if($abst =~ /^(.+?)，.*?$/s){
						if(length($1) <= 30){
								my $tmpheader = $1;
								if($header eq "" || length($header) > length($tmpheader)){
										$header = $tmpheader;
								}
						}
				}
		}

		if($header eq "" || length($header) > 30){
				$header = substr($abst, 0, 30);
		}

		utf8::encode($header);
		$header =~ s/&/&amp;/gis;

		if($singleContents =~ /^<canvas/i){
				$header = "Drawing";
				$singleContents = "Cannot display this drawing.";
		}

		if($singleContents =~ /^<img/i){
				if($singleContents =~ /src\s*?=['"].*\/(.+?)['"]/i){
						
						$header = $1;
				}
				else{
						$header = "Image file";
				}
		}

		$singleContents = "<![CDATA[ $singleContents ]]>";
		$rss->add_item(
				title => $header,
				link => $siteurl . $PositLogConfig::cgipath . "positlog.cgi?load=" . $pageid. "&amp;id=" . $sid,
				description => $singleContents,
				dc_date => $modifiedTime,
				);

		$counter ++;
		if($counter >= $maxnumber){
				last;
		}
}

$rss->channel(
		title => $configHash->{"page_title"},
		link => $siteurl . $PositLogConfig::cgipath . "positlog.cgi?load=" . $pageid,
		about => $siteurl . $PositLogConfig::cgipath . "positlog.cgi?load=" . $pageid,
		);


print $rss->as_string;


my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
my $modifiedtime = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);



$urlSpriteid->{"rss"} = $rss->as_string;
$urlSpriteid->{"modified_date"} = $modifiedtime;

if(!eval{Storable::lock_nstore $urlSpriteid, $PositLogConfig::datapath . $pageid . "/dynamic/" . $serializedData . ".dat"}) { print "Cannot write dynamic sprite table.";}



1;
