/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import jp.sourceforge.mergedoc.pleiades.aspect.ITimingLogger;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/**
 * ԌvO@\t̎łB
 * <p>
 * @author C/pHeR
 */
public class TranslationLoggingDictionary extends TranslationDictionary implements ITimingLogger {
	
	/** K[ */
	private static final Logger log = Logger.getLogger(TranslationLoggingDictionary.class);
	
	/** convert \bh̏v */
	private volatile long convertTime;
	
	/** convert \bȟĂяo */
	private volatile int convertCall;
	
	/** lookup \bh̏v */
	private volatile long lookupTime;
	
	/** lookup \bȟĂяo */
	private volatile int lookupCall;
	
	/** lookupNoMnemonic \bh̏v */
	private volatile long lookupIgnoreMnemonicTime;
	
	/** lookupNoMnemonic \bȟĂяo */
	private volatile int lookupIgnoreMnemonicCall;
	
	/** hasJaMnemonic \bh̏v */
	private volatile long hasJaMnemonicTime;
	
	/** hasJaMnemonic \bȟĂяo */
	private volatile int hasJaMnemonicCall;
	
	/** getJaValue \bh̏v */
	private volatile long getJaValueTime;
	
	/** getJaValue \bȟĂяo */
	private volatile int getJaValueCall;
	
	/** getJaValueByRegex \bh̏v */
	private volatile long getJaValueByTrimmedTime;
	
	/** getJaValueByRegex \bȟĂяo */
	private volatile int getJaValueByTrimmedCall;
	
	/** getJaValueByRegex \bh̏v */
	private volatile long getJaValueByRegexTime;
	
	/** getJaValueByRegex \bȟĂяo */
	private volatile int getJaValueByRegexCall;
	
	/** isNoTranslation \bh̏v */
	private volatile long isNoTranslationTime;
	
	/** isNoTranslation \bȟĂяo */
	private volatile int isNoTranslationCall;
	
	/** editMnemonicEnToJa \bh̏v */
	private volatile long editMnemonicEnToJaTime;
	
	/** editMnemonicEnToJa \bȟĂяo */
	private volatile int editMnemonicEnToJaCall;
	
	/**
	 * ̎\z܂B
	 */
	TranslationLoggingDictionary() {
		Pleiades.getInstance().registTimingLogger(this);
	}
	
	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected void convert() {
		
		long startTime = System.currentTimeMillis();
		super.convert();
		synchronized (this) {
			convertTime += System.currentTimeMillis() - startTime;
			convertCall++;
		}
	}
	
	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	public String lookup(String enValue, JointPoint jointPoint) {
		
		long startTime = System.currentTimeMillis();
		String result = super.lookup(enValue, jointPoint);
		synchronized (this) {
			lookupTime += System.currentTimeMillis() - startTime;
			lookupCall++;
		}
		return result;
	}
	
	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	public String lookupIgnoreMnemonic(String enValue, JointPoint jointPoint) {
		
		long startTime = System.currentTimeMillis();
		String result = super.lookupIgnoreMnemonic(enValue, jointPoint);
		synchronized (this) {
			lookupIgnoreMnemonicTime += System.currentTimeMillis() - startTime;
			lookupIgnoreMnemonicCall++;
		}
		return result;
	}
	
	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	public boolean hasJaMnemonic(String value) {
		
		long startTime = System.currentTimeMillis();
		boolean result = super.hasJaMnemonic(value);
		synchronized (this) {
			hasJaMnemonicTime += System.currentTimeMillis() - startTime;
			hasJaMnemonicCall++;
		}
		return result;
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected String getJaValue(String enNoMnemonic, JointPoint jointPoint) {
		
		long startTime = System.currentTimeMillis();
		String result = super.getJaValue(enNoMnemonic, jointPoint);
		synchronized (this) {
			getJaValueTime += System.currentTimeMillis() - startTime;
			getJaValueCall++;
		}
		return result;
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected String getJaValueByTrimmed(String enNoMnemonic) {
		
		long startTime = System.currentTimeMillis();
		String result = super.getJaValueByTrimmed(enNoMnemonic);
		synchronized (this) {
			getJaValueByTrimmedTime += System.currentTimeMillis() - startTime;
			getJaValueByTrimmedCall++;
		}
		return result;
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected String getJaValueByRegex(String enNoMnemonic) {
		
		long startTime = System.currentTimeMillis();
		String result = super.getJaValueByRegex(enNoMnemonic);
		synchronized (this) {
			getJaValueByRegexTime += System.currentTimeMillis() - startTime;
			getJaValueByRegexCall++;
		}
		return result;
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected boolean isNoTranslation(String enValueNonMnemonic, JointPoint jointPoint) {
		
		long startTime = System.currentTimeMillis();
		boolean result = super.isNoTranslation(enValueNonMnemonic, jointPoint);
		synchronized (this) {
			isNoTranslationTime += System.currentTimeMillis() - startTime;
			isNoTranslationCall++;
		}
		return result;
	}
	
	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected String editMnemonicEnToJa(String enValue,
			String enValueNonMnemonic, String result) {
		
		long startTime = System.currentTimeMillis();
		String jaResult = super.editMnemonicEnToJa(enValue, enValueNonMnemonic, result);
		synchronized (this) {
			editMnemonicEnToJaTime += System.currentTimeMillis() - startTime;
			editMnemonicEnToJaCall++;
		}
		return jaResult;
	}

	/**
	 * ԌvOo͂܂B
	 * @see ITimingLogger#logUptime()
	 */
	public void logUptime() {
		
		String msg = "%-30s %6.3f bA%8d ";

		log.debug(String.format(msg, "convert", convertTime / 1000d, convertCall));
		log.debug(String.format(msg, "lookupIgnoreMnemonic", lookupIgnoreMnemonicTime / 1000d, lookupIgnoreMnemonicCall));
		log.debug(String.format(msg, "lookup", lookupTime / 1000d, lookupCall));
		log.debug(String.format(msg, "  hasJaMnemonic", hasJaMnemonicTime / 1000d, hasJaMnemonicCall));
		log.debug(String.format(msg, "  editMnemonicEnToJa", editMnemonicEnToJaTime / 1000d, editMnemonicEnToJaCall));
		log.debug(String.format(msg, "  getJaValue", getJaValueTime / 1000d, getJaValueCall));
		log.debug(String.format(msg, "    isNoTranslation", isNoTranslationTime / 1000d, isNoTranslationCall));
		log.debug(String.format(msg, "    getJaValueByTrimmed", getJaValueByTrimmedTime / 1000d, getJaValueByTrimmedCall));
		log.debug(String.format(msg, "      getJaValueByRegex", getJaValueByRegexTime / 1000d, getJaValueByRegexCall));
	}
}
