/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.FileSystem;

import org.apache.commons.io.IOUtils;

/**
 * |vpeB[ɗvfȂꍇ̏o͂邽߂̃vpeB[łB
 * <p>
 * @author C/pHeR
 */
public class NotFoundProperties {
	
	/** K[ */
	private static final Logger log = Logger.getLogger(NotFoundProperties.class);
	
	/** 󖳂Oo̓t@C */
	private static final File NOT_FOUND_LOG_FILE_NAME =
		new File(Pleiades.configurationPath, "translation-notfound.properties");
	
	/** 󖳂Oo͂珜OvfXgt@C */
	private static final File EXCLUDE_LIST_FILE_NAME =
		FileSystem.getResourceFile("translation-notfound-exclud.list");
	
	/** 󖳂K[CX^X */
	private static NotFoundProperties notFoundLog;
	
	/** 󖳂K[CX^X̏ */
	static {
		if (Pleiades.getInstance().getPleiadesOption().isEnabledNotFoundLog()) {
			notFoundLog = new NotFoundProperties();
			notFoundLog.init();
		} else {
			notFoundLog = new NotFoundProperties() {
				public void println(String enValueNonMnemonic) {
				}
			};
		}
	}
	
	/** 󖳂K[o͂珜Ovf̃Zbg */
	private Set<String> excludSet;
	
	/** 󖳂K[o͂珜Ovf̃ZbgiK\j */
	private Set<Pattern> excludPatternSet;
	
	/** 󖳂K[ɏo͍ς݂̗vfio͗}~pj */
	private Set<String> loggedSet;
	
	/** t@C PrintStream */
	private PrintStream out;
	
	/**
	 * CX^Xł܂B
	 */
	private NotFoundProperties() {
	}
	
	/**
	 * 󖳂K[̃CX^X擾܂B
	 * <p>
	 * @return 󖳂K[̃CX^X
	 */
	public static NotFoundProperties getInstance() {
		return notFoundLog;
	}
	
	/**
	 * ܂B
	 */
	private void init() {
		
		excludSet = new HashSet<String>();
		excludPatternSet = new HashSet<Pattern>();
		loggedSet = new HashSet<String>();
		
		BufferedReader in = null;
		try {
			in = new BufferedReader(new FileReader(EXCLUDE_LIST_FILE_NAME));
			
			for (String line; (line = in.readLine()) != null;) {
				if (!line.startsWith("#")) {
					String str = line.replaceAll("\\\\n", "\n");
					String prefix = "%REGEX%";
					if (str.startsWith(prefix)) {
						Pattern pattern = Pattern.compile(str.replaceFirst(prefix, ""));
						excludPatternSet.add(pattern);
					} else {
						excludSet.add(str);
					}
				}
			}
			
		} catch (IOException e) {
			log.fatal("󖳂Oo͏OXg[hł܂łB", e);
			return;
			
		} finally {
			IOUtils.closeQuietly(in);
		}
		
		try {
			out = new PrintStream(
					new BufferedOutputStream(new FileOutputStream(NOT_FOUND_LOG_FILE_NAME)),
					true);
			
			// VM Vbg_EEtbNƂăt@C PrintStream ̃N[Yo^
			Runtime.getRuntime().addShutdownHook(new Thread() {
				public void run() {
					PrintStream out = NotFoundProperties.getInstance().out;
					IOUtils.closeQuietly(out);
				}
			});
			
		} catch (IOException e) {
			log.fatal("󖳂OC^[𐶐ł܂łB", e);
		}
	}
	
	/**
	 * w肳ꂽvfOo͂܂B
	 * <p>
	 * @param enValueNonMnemonic j[jbN܂܂Ȃpꃊ\[X
	 */
	public void println(String enValueNonMnemonic) {
		
		if (loggedSet.contains(enValueNonMnemonic)) {
			return;
		}
		if (excludSet.contains(enValueNonMnemonic)) {
			return;
		}
		for (Pattern pattern : excludPatternSet) {
			if (pattern.matcher(enValueNonMnemonic).matches()) {
				return;
			}
		}
		loggedSet.add(enValueNonMnemonic);
		
		String key = enValueNonMnemonic
			.replaceAll("[ :=#!\t\\\\]", "\\\\$0")
			.replaceAll("\r", "\\\\r")
			.replaceAll("\n", "\\\\n");
		
		String value = enValueNonMnemonic
			.replaceAll("#", "\\\\$0")
			.replaceAll("\n", " ");
		
		if (key.matches("(?s).*\\p{Alpha}{2}.*")) {
			out.println(key + "=" + value);
		}
	}
}
