/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.IOException;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/**
 * ԌvO@\t TranslationTransformer łB
 * <p>
 * @author C/pHeR
 */
public class TranslationLoggingTransformer extends TranslationTransformer implements ITimingLogger {

	/** K[ */
	private static final Logger log = Logger.getLogger(TranslationLoggingTransformer.class);
	
	/** load \bh̏v */
	private volatile long loadTime;
	
	/** load \bȟĂяo */
	private volatile long loadCall;
	
	/** transform (ۃNX) \bh̏v */
	private volatile long transformAbstractTime;
	
	/** transform (ۃNX) \bȟĂяo */
	private volatile long transformAbstractCall;
	
	/** createCtClass (ۃNX) \bh̏v */
	private volatile long createCtClassTime;
	
	/** createCtClass (ۃNX) \bȟĂяo */
	private volatile long createCtClassCall;
	
	/** transform \bh̏v */
	private volatile long transformTime;
	
	/** transform \bȟĂяo */
	private volatile long transformCall;
	
	/** weaveTranslationAspect \bh̏v */
	private volatile long weaveTranslationAspectTime;
	
	/** weaveTranslationAspect \bȟĂяo */
	private volatile long weaveTranslationAspectCall;

	/**
	 * |gXtH[}[\z܂B
	 */
	public TranslationLoggingTransformer() {
		Pleiades.getInstance().registTimingLogger(this);
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected void load() {
		
		long startTime = System.currentTimeMillis();
		super.load();
		synchronized (this) {
			loadTime += System.currentTimeMillis() - startTime;
			loadCall++;
		}
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	public byte[] transform(
			ClassLoader loader,
			String internalName,
			Class<?> classBeingRedefined,
			ProtectionDomain protectionDomain,
			byte[] bytecode) throws IllegalClassFormatException {
		
		long startTime = System.currentTimeMillis();
		byte[] result = super.transform(loader, internalName, classBeingRedefined, protectionDomain, bytecode);
		synchronized (this) {
			transformAbstractTime += System.currentTimeMillis() - startTime;
			transformAbstractCall++;
		}
		return result;
	}
	
	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected byte[] transform(
			ClassLoader loader,
			String className,
			ProtectionDomain protectionDomain,
			byte[] bytecode)
		throws CannotCompileException, NotFoundException, IOException {

		long startTime = System.currentTimeMillis();
		byte[] result = super.transform(loader, className, protectionDomain, bytecode);
		synchronized (this) {
			transformTime += System.currentTimeMillis() - startTime;
			transformCall++;
		}
		return result;
	}
	
	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected byte[] weaveTranslationAspect(CtClass ctClass)
		throws CannotCompileException, NotFoundException, IOException {
		
		long startTime = System.currentTimeMillis();
		byte[] result = super.weaveTranslationAspect(ctClass);
		synchronized (this) {
			weaveTranslationAspectTime += System.currentTimeMillis() - startTime;
			weaveTranslationAspectCall++;
		}
		return result;
	}

	/**
	 * eNX̓\bhɎԌvOo͂ǉ\bhłB
	 */
	@Override
	protected CtClass createCtClass(
			byte[] bytecode,
			ProtectionDomain protectionDomain) throws IOException, NotFoundException {
		
		long startTime = System.currentTimeMillis();
		CtClass result = super.createCtClass(bytecode, protectionDomain);
		synchronized (this) {
			createCtClassTime += System.currentTimeMillis() - startTime;
			createCtClassCall++;
		}
		return result;
	}

	/**
	 * ԌvOo͂܂B
	 * @see ITimingLogger#logUptime()
	 */
	public void logUptime() {
		
		String msg = "%-30s %6.3f bA%8d ";
		
		log.debug(String.format(msg, "load",
				loadTime / 1000d, loadCall));
		log.debug(String.format(msg, "transform (Abstract)",
				transformAbstractTime / 1000d, transformAbstractCall));
		log.debug(String.format(msg, "  transform",
				transformTime / 1000d, transformCall));
		log.debug(String.format(msg, "    createCtClass (Abstract)",
				createCtClassTime / 1000d, createCtClassCall));
		log.debug(String.format(msg, "    weaveTranslationAspect",
				weaveTranslationAspectTime / 1000d, weaveTranslationAspectCall));
	}
}
