/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;

import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PointCut;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint.EditPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PointCut.Timing;
import jp.sourceforge.mergedoc.pleiades.log.Logger;

/**
 * |󏈗NXEIuWFNgɖߍރGfB^[łB
 * <p>
 * ΏۂƂȂWCgE|CgAhoCX
 * {@link jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping}
 * 擾܂B
 * <p>
 * @author C/pHeR
 */
public class TranslationEditor extends ExprEditor {

	/** K[ */
	@SuppressWarnings("unused")
	private static final Logger log = Logger.getLogger(TranslationEditor.class);

	/** ҏWΏۂƂȂ CtClass IuWFNg */
	private final CtClass ctClass;

	/** ҏWς݂̏ꍇ true */
	private boolean isEdited;

	/**
	 * |GfB^[\z܂B
	 * <p>
	 * @param ctClass CtClass IuWFNg
	 */
	public TranslationEditor(CtClass ctClass) {
		this.ctClass = ctClass;
	}

	/**
	 * RXgN^܂̓\bhĂяoҏW܂B
	 * editPoint  call ̏ꍇɌĂяo܂B
	 */
	@Override
	public void edit(MethodCall methodCall) throws CannotCompileException {

		//-------------------------------------
		// Ăяȍ擾
		//-------------------------------------
		String calleeClassName = methodCall.getClassName();
		String calleeMethodName = methodCall.getMethodName();
		AspectMapping mapping = AspectMapping.getInstance();
		if (!mapping.containesMethodCall(calleeClassName, calleeMethodName)) {
			return;
		}

		JointPoint calleeJP = new JointPoint();
		calleeJP.setEditPoint(EditPoint.CALL);
		calleeJP.setClassName(calleeClassName);
		calleeJP.setMethodName(calleeMethodName);
		try {
			CtMethod calleeMethod = methodCall.getMethod();
			calleeJP.setDescriptor(calleeMethod.getMethodInfo().getDescriptor());
		} catch (NotFoundException e) {
			// NXpXɌĂяo悪܂܂ĂȂꍇ͖
			log.warn("NXpXȂB" + calleeClassName + "  " + ctClass.getName());
			return;
		}
		PointCut pointCut = mapping.getPointCut(calleeJP);
		if (pointCut == null) {
			return;
		}
		if (pointCut.getExcludeTrace().size() > 0 || pointCut.getIncludeTrace().size() > 0) {
			throw new IllegalStateException(
				"editPoint  call ̏ꍇA*cludeTrace w肷邱Ƃ͂ł܂B" +
				pointCut);
		}
		
		//-------------------------------------
		// Ăяȍ擾
		//-------------------------------------
		CtBehavior callerMethod = methodCall.where();
		
		// Ăяȍꏊɂ鏜O
		if (contains(pointCut.getExcludeWheres(), callerMethod)) {
			return;
		}
		// Ăяȍꏊɂ
		List<JointPoint> includeWheres = pointCut.getIncludeWheres();
		if (includeWheres.size() > 0 && !contains(includeWheres, callerMethod)) {
			return;
		}

		String advice = pointCut.getAdvice();
		if (advice.contains("?{JOINT_POINT}")) {
			JointPoint jointPoint = new JointPoint();
			jointPoint.setEditPoint(EditPoint.CALL);
			jointPoint.setClassName(callerMethod.getDeclaringClass().getName());
			jointPoint.setMethodName(callerMethod.getName());
			jointPoint.setDescriptor(callerMethod.getMethodInfo().getDescriptor());
			advice = replaceJointPoint(advice, jointPoint);
		}
		
		methodCall.replace(advice);
		isEdited = true;
	}
	
	/**
	 * WCgE|Cg̃XgɃNXƃ\bh܂܂邩肵܂B
	 * 
	 * @param jointPointList WCgE|Cg̃Xg
	 * @param callerMethod Ăяo\bh
	 * @return ܂܂ꍇ true
	 */
	private boolean contains(List<JointPoint> jointPointList, CtBehavior callerMethod) {
		
		// Ăяȍ
		String callerClassName = callerMethod.getDeclaringClass().getName();
		String callerMethodName = callerMethod.getName();
		
		//  includeAexclude  modefierAdescriptor ͖T|[g
		for (JointPoint jointPoint : jointPointList) {
			
			// NX͑Ov
			if (callerClassName.startsWith(jointPoint.getClassName())) {
				
				// \bh͊Sv
				String mName = jointPoint.getMethodName();
				if (mName == null || callerMethodName.equals(mName)) {
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * AhoCXɊ܂܂ ${JOINT_POINT}  new JointPont(...) 
	 * u܂B
	 * 
	 * @param advice AhoCX
	 * @param jointPoint WCgE|Cg
	 * @return ũAhoCX
	 */
	private String replaceJointPoint(String advice, JointPoint jointPoint) {
		
		String replacement = Matcher.quoteReplacement(
				"new " + JointPoint.class.getName() + "(" +
				EditPoint.class.getName() + "." + jointPoint.getEditPoint().name() +
				",\"" + jointPoint.getClassName() + "\"" +
				",\"" + jointPoint.getMethodName() + "\"" +
				",\"" + jointPoint.getDescriptor() + "\"" +
				")");
		return advice.replaceAll("\\?\\{JOINT_POINT\\}", replacement);
	}
	
	/**
	 * RXgN^܂̓\bhҏW܂B
	 * editPoint  execution ̏ꍇɌĂяo܂B
	 * <p>
	 * @param ctBehavior RXgN^܂̓\bhEIuWFNg
	 * @throws CannotCompileException RpCłȂꍇ
	 */
	public void editBehavior(CtBehavior ctBehavior) throws CannotCompileException {

		String className = ctClass.getName();
		String methodName = ctBehavior.getName();

		JointPoint jointPoint = new JointPoint();
		jointPoint.setEditPoint(EditPoint.EXECUTION);
		jointPoint.setClassName(className);
		jointPoint.setMethodName(methodName);
		jointPoint.setDescriptor(ctBehavior.getMethodInfo().getDescriptor());

		AspectMapping mapping = AspectMapping.getInstance();
		PointCut pointCut = mapping.getPointCut(jointPoint);
		if (pointCut == null) {
			return;
		}
		if (pointCut.getExcludeWheres().size() > 0 || pointCut.getIncludeWheres().size() > 0) {
			throw new IllegalStateException(
				"editPoint  execution ̏ꍇA*cludeWhere w肷邱Ƃ͂ł܂B" +
				pointCut);
		}

		Timing timing = pointCut.getTiming();
		String advice = pointCut.getAdvice();

		if (advice.contains("?{JOINT_POINT}")) {
			advice = replaceJointPoint(advice, jointPoint);
		} else {
			if (pointCut.getExcludeTrace().size() > 0 || pointCut.getIncludeTrace().size() > 0) {
				throw new IllegalStateException(
					"*cludeTrace w肵Ăꍇ Advice  ?{JOINT_POINT} " +
					"܂܂ĂKv܂B" + jointPoint);
			}
		}

		if (timing == Timing.BEFORE) {
			ctBehavior.insertBefore(advice);
		} else if (timing == Timing.AFTER) {
			ctBehavior.insertAfter(advice);
		} else {
			throw new IllegalStateException(
			"ҏW|Cg execution ̏ꍇAtiming  before ܂ after " +
			"łKv܂B" + jointPoint);
		}
		isEdited = true;
	}

	/**
	 * ҏWʂoCgR[hŎ擾܂B
	 * <p>
	 * @return oCgR[hBҏW̏ꍇ nullB
	 * @throws IOException o͗Oꍇ
	 * @throws CannotCompileException RpCłȂꍇ
	 */
	public byte[] toBytecode() throws IOException, CannotCompileException {
		return isEdited ? ctClass.toBytecode() : null;
	}
}
