/*
 * Copyright (c) 2005- Shinji Kashihara.
 * All rights reserved. This program are made available under
 * the terms of the Eclipse Public License v1.0 which accompanies
 * this distribution, and is available at epl-v10.html.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import jp.sourceforge.mergedoc.pleiades.log.Logger;

import org.apache.commons.lang.StringUtils;

/**
 * Pleiades NIvVłB
 * <p>
 * @author C/pHeR
 */
public class PleiadesOption {
	
	/** Eclipse  -clean IvV */
	private boolean isClean;
	
	/** ftHgEXvbVʕ\IvV */
	private final boolean isDefaultSplash;
	
	/** j[jbN\IvV */
	private final boolean isNoMnemonic;
	
	/** 󖳂Oo̓IvV */
	private final boolean isEnabledNotFoundLog;
	
	/** OEx */
	private String logLevel;
	
	/**
	 * NIvV\z܂B
	 * <p>
	 * @param agentArg G[WFgN
	 */
	PleiadesOption(String agentArg) {
		
		String arg = (agentArg == null) ? "" : "," + agentArg.replace(" ", "") + ",";
		
		isDefaultSplash = arg.contains(",default.splash,");
		isNoMnemonic = arg.contains(",no.mnemonic,");
		isEnabledNotFoundLog = arg.contains(",enabled.not.found.log,");
		
		// OEx̎擾
		if (arg.contains("log.level=")) {
			logLevel = arg.replaceFirst("^.*?log\\.level=", "").replaceFirst(",.*$", "");
			try {
				Logger.Level.valueOf(logLevel.toUpperCase());
			} catch (IllegalArgumentException e) {
				throw new IllegalArgumentException(
					"NIvV log.level ̒l [" + logLevel + "] słB" +
					StringUtils.join(Logger.Level.values(), ",") +
					" ̂ꂩłKv܂B");
			}
		} else {
			logLevel = Logger.Level.INFO.toString();
		}
	}
	
	/**
	 * Eclipse  -clean IvVZbg܂B
	 * <p>
	 * @param isClean N -clean w肳Ăꍇ true
	 */
	public void setClean(boolean isClean) {
		this.isClean = isClean;
	}
	
	/**
	 * Eclipse  -clean IvV擾܂B
	 * <p>
	 * @return N -clean w肳Ăꍇ true
	 */
	public boolean isClean() {
		return isClean;
	}
	
	/**
	 * Eclipse ̃ftHgEXvbVʂgp邩肵܂B
	 * <p>
	 * @return gpꍇ true
	 */
	public boolean isDefaultSplash() {
		return isDefaultSplash;
	}
	
	/**
	 * j[jbN\Ȃ肵܂B
	 * <p>
	 * @return gpȂꍇ true
	 */
	public boolean isNoMnemonic() {
		return isNoMnemonic;
	}
	
	/**
	 * 󖳂Oo͂邩肵܂B
	 * <p>
	 * @return o͂ꍇ true
	 */
	public boolean isEnabledNotFoundLog() {
		return isEnabledNotFoundLog;
	}
	
	/**
	 * OEx擾܂B
	 * <p>
	 * @return OEx
	 */
	public String getLogLevel() {
		return logLevel;
	}
}
